/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.StatefulCommandExecutor;
import org.eclipse.jpt.common.utility.internal.SimpleQueue;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSingleUseQueueingCommandExecutor<E extends StatefulCommandExecutor>
implements StatefulCommandExecutor {
    protected final E commandExecutor;
    private State state;
    private SimpleQueue<Command> queue = new SimpleQueue();

    protected AbstractSingleUseQueueingCommandExecutor(E commandExecutor) {
        if (commandExecutor == null) {
            throw new NullPointerException();
        }
        this.commandExecutor = commandExecutor;
        this.state = State.PRE_START;
    }

    @Override
    public synchronized void start() {
        if (this.state != State.PRE_START) {
            throw this.buildISE();
        }
        this.commandExecutor.start();
        while (!this.queue.isEmpty()) {
            this.commandExecutor.execute(this.queue.dequeue());
        }
        this.state = State.ACTIVE;
    }

    @Override
    public void execute(Command command) {
        if (this.commandIsToBeExecuted(command)) {
            this.commandExecutor.execute(command);
        }
    }

    private synchronized boolean commandIsToBeExecuted(Command command) {
        switch (this.state) {
            case ACTIVE: {
                return true;
            }
            case PRE_START: 
            case SUSPENDED: {
                this.queue.enqueue(command);
                return false;
            }
            case DEAD: {
                return false;
            }
        }
        throw this.buildISE();
    }

    public synchronized void suspend() {
        if (this.state != State.ACTIVE) {
            throw this.buildISE();
        }
        this.state = State.SUSPENDED;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void resume() {
        if (this.state == State.SUSPENDED) ** GOTO lbl4
        throw this.buildISE();
lbl-1000:
        // 1 sources

        {
            this.commandExecutor.execute(this.queue.dequeue());
lbl4:
            // 2 sources

            ** while (!this.queue.isEmpty())
        }
lbl5:
        // 1 sources

        this.state = State.ACTIVE;
    }

    @Override
    public synchronized void stop() throws InterruptedException {
        switch (this.state) {
            case ACTIVE: {
                break;
            }
            case SUSPENDED: {
                while (!this.queue.isEmpty()) {
                    this.queue.dequeue();
                }
                break;
            }
            case PRE_START: 
            case DEAD: {
                throw this.buildISE();
            }
        }
        this.commandExecutor.stop();
        this.state = State.DEAD;
    }

    private IllegalStateException buildISE() {
        return new IllegalStateException(String.valueOf((Object)this.state));
    }

    public String toString() {
        return StringTools.buildToStringFor(this, (Object)this.state);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        PRE_START,
        ACTIVE,
        SUSPENDED,
        DEAD;

    }
}

