/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.Collection;
import org.eclipse.jpt.common.utility.internal.model.value.AspectCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionAspectAdapter<S extends Model, E>
extends AspectCollectionValueModelAdapter<S, E> {
    protected final String[] aspectNames;
    protected static final String[] EMPTY_ASPECT_NAMES = new String[0];
    protected final CollectionChangeListener aspectChangeListener;

    protected CollectionAspectAdapter(String aspectName, S subject) {
        this(new String[]{aspectName}, subject);
    }

    protected CollectionAspectAdapter(String[] aspectNames, S subject) {
        this(new StaticPropertyValueModel<S>(subject), aspectNames);
    }

    protected CollectionAspectAdapter(PropertyValueModel<? extends S> subjectModel, String ... aspectNames) {
        super(subjectModel);
        this.aspectNames = aspectNames;
        this.aspectChangeListener = this.buildAspectChangeListener();
    }

    protected CollectionAspectAdapter(PropertyValueModel<? extends S> subjectModel, Collection<String> aspectNames) {
        this(subjectModel, aspectNames.toArray(new String[aspectNames.size()]));
    }

    protected CollectionAspectAdapter(PropertyValueModel<? extends S> subjectModel) {
        this(subjectModel, EMPTY_ASPECT_NAMES);
    }

    protected CollectionChangeListener buildAspectChangeListener() {
        return new AspectChangeListener();
    }

    @Override
    protected void engageSubject_() {
        String[] stringArray = this.aspectNames;
        int n = this.aspectNames.length;
        int n2 = 0;
        while (n2 < n) {
            String collectionName = stringArray[n2];
            ((Model)this.subject).addCollectionChangeListener(collectionName, this.aspectChangeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageSubject_() {
        String[] stringArray = this.aspectNames;
        int n = this.aspectNames.length;
        int n2 = 0;
        while (n2 < n) {
            String collectionName = stringArray[n2];
            ((Model)this.subject).removeCollectionChangeListener(collectionName, this.aspectChangeListener);
            ++n2;
        }
    }

    protected void aspectItemsAdded(CollectionAddEvent event) {
        this.fireItemsAdded(event.clone(this, "values"));
    }

    protected void aspectItemsRemoved(CollectionRemoveEvent event) {
        this.fireItemsRemoved(event.clone(this, "values"));
    }

    protected void aspectCollectionCleared(CollectionClearEvent event) {
        this.fireCollectionCleared(event.clone(this, "values"));
    }

    protected void aspectCollectionChanged(CollectionChangeEvent event) {
        this.fireCollectionChanged(event.clone(this, "values"));
    }

    protected class AspectChangeListener
    extends CollectionChangeAdapter {
        protected AspectChangeListener() {
        }

        public void itemsAdded(CollectionAddEvent event) {
            CollectionAspectAdapter.this.aspectItemsAdded(event);
        }

        public void itemsRemoved(CollectionRemoveEvent event) {
            CollectionAspectAdapter.this.aspectItemsRemoved(event);
        }

        public void collectionCleared(CollectionClearEvent event) {
            CollectionAspectAdapter.this.aspectCollectionCleared(event);
        }

        public void collectionChanged(CollectionChangeEvent event) {
            CollectionAspectAdapter.this.aspectCollectionChanged(event);
        }
    }
}

