/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyValueModelWrapper;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringPropertyValueModel<V>
extends PropertyValueModelWrapper<V>
implements PropertyValueModel<V> {
    protected final Filter<V> filter;
    protected final V defaultValue;

    public FilteringPropertyValueModel(PropertyValueModel<? extends V> valueModel, Filter<V> filter) {
        this(valueModel, filter, null);
    }

    public FilteringPropertyValueModel(PropertyValueModel<? extends V> valueModel, Filter<V> filter, V defaultValue) {
        super(valueModel);
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filter = filter;
        this.defaultValue = defaultValue;
    }

    @Override
    public V getValue() {
        return this.filterValue(this.valueModel.getValue());
    }

    @Override
    protected void wrappedValueChanged(V oldValue, V newValue) {
        this.firePropertyChanged("value", this.filterValue(oldValue), this.filterValue(newValue));
    }

    protected V filterValue(V value) {
        return this.filter.accept(value) ? value : this.getDefaultValue();
    }

    protected V getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.getValue());
    }
}

