/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.Collection;
import org.eclipse.jpt.common.utility.internal.model.value.AspectListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListAspectAdapter<S extends Model, E>
extends AspectListValueModelAdapter<S, E> {
    protected final String[] aspectNames;
    protected static final String[] EMPTY_ASPECT_NAMES = new String[0];
    protected final ListChangeListener aspectChangeListener;

    protected ListAspectAdapter(String aspectName, S subject) {
        this(new String[]{aspectName}, subject);
    }

    protected ListAspectAdapter(String[] aspectNames, S subject) {
        this(new StaticPropertyValueModel<S>(subject), aspectNames);
    }

    protected ListAspectAdapter(PropertyValueModel<? extends S> subjectModel, String ... aspectNames) {
        super(subjectModel);
        this.aspectNames = aspectNames;
        this.aspectChangeListener = this.buildAspectChangeListener();
    }

    protected ListAspectAdapter(PropertyValueModel<? extends S> subjectModel, Collection<String> aspectNames) {
        this(subjectModel, aspectNames.toArray(new String[aspectNames.size()]));
    }

    protected ListAspectAdapter(PropertyValueModel<? extends S> subjectModel) {
        this(subjectModel, EMPTY_ASPECT_NAMES);
    }

    protected ListChangeListener buildAspectChangeListener() {
        return new AspectChangeListener();
    }

    @Override
    protected void engageSubject_() {
        String[] stringArray = this.aspectNames;
        int n = this.aspectNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            ((Model)this.subject).addListChangeListener(listName, this.aspectChangeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageSubject_() {
        String[] stringArray = this.aspectNames;
        int n = this.aspectNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            ((Model)this.subject).removeListChangeListener(listName, this.aspectChangeListener);
            ++n2;
        }
    }

    protected void aspectItemsAdded(ListAddEvent event) {
        this.fireItemsAdded(event.clone(this, "list values"));
    }

    protected void aspectItemsRemoved(ListRemoveEvent event) {
        this.fireItemsRemoved(event.clone(this, "list values"));
    }

    protected void aspectItemsReplaced(ListReplaceEvent event) {
        this.fireItemsReplaced(event.clone(this, "list values"));
    }

    protected void aspectItemsMoved(ListMoveEvent event) {
        this.fireItemsMoved(event.clone(this, "list values"));
    }

    protected void aspectListCleared(ListClearEvent event) {
        this.fireListCleared(event.clone(this, "list values"));
    }

    protected void aspectListChanged(ListChangeEvent event) {
        this.fireListChanged(event.clone(this, "list values"));
    }

    protected class AspectChangeListener
    extends ListChangeAdapter {
        protected AspectChangeListener() {
        }

        public void itemsAdded(ListAddEvent event) {
            ListAspectAdapter.this.aspectItemsAdded(event);
        }

        public void itemsRemoved(ListRemoveEvent event) {
            ListAspectAdapter.this.aspectItemsRemoved(event);
        }

        public void itemsReplaced(ListReplaceEvent event) {
            ListAspectAdapter.this.aspectItemsReplaced(event);
        }

        public void itemsMoved(ListMoveEvent event) {
            ListAspectAdapter.this.aspectItemsMoved(event);
        }

        public void listCleared(ListClearEvent event) {
            ListAspectAdapter.this.aspectListCleared(event);
        }

        public void listChanged(ListChangeEvent event) {
            ListAspectAdapter.this.aspectListChanged(event);
        }
    }
}

