/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationWritablePropertyValueModel<V1, V2>
extends TransformationPropertyValueModel<V1, V2>
implements ModifiablePropertyValueModel<V2> {
    protected final Transformer<V2, V1> reverseTransformer;

    public TransformationWritablePropertyValueModel(ModifiablePropertyValueModel<V1> valueModel) {
        super(valueModel);
        this.reverseTransformer = this.buildReverseTransformer();
    }

    public TransformationWritablePropertyValueModel(ModifiablePropertyValueModel<V1> valueModel, Transformer<V1, V2> transformer, Transformer<V2, V1> reverseTransformer) {
        super(valueModel, transformer);
        if (reverseTransformer == null) {
            throw new NullPointerException();
        }
        this.reverseTransformer = reverseTransformer;
    }

    protected Transformer<V2, V1> buildReverseTransformer() {
        return new DefaultReverseTransformer();
    }

    @Override
    public void setValue(V2 value) {
        this.value = value;
        this.getValueModel().setValue(this.reverseTransform(value));
    }

    protected V1 reverseTransform(V2 v) {
        return this.reverseTransformer.transform(v);
    }

    protected V1 reverseTransform_(V2 v) {
        throw new RuntimeException("This method was not overridden.");
    }

    protected ModifiablePropertyValueModel<V1> getValueModel() {
        return (ModifiablePropertyValueModel)this.valueModel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultReverseTransformer
    implements Transformer<V2, V1> {
        protected DefaultReverseTransformer() {
        }

        @Override
        public V1 transform(V2 v) {
            return v == null ? null : (Object)TransformationWritablePropertyValueModel.this.reverseTransform_(v);
        }
    }
}

