/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.model.value.ValueAspectAdapter;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueListAdapter<V extends Model>
extends ValueAspectAdapter<V> {
    protected final String[] listNames;
    protected final ListChangeListener valueListListener;

    public ValueListAdapter(ModifiablePropertyValueModel<V> valueHolder, String ... listNames) {
        super(valueHolder);
        this.listNames = listNames;
        this.valueListListener = this.buildValueListListener();
    }

    protected ListChangeListener buildValueListListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent event) {
                ValueListAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(ListRemoveEvent event) {
                ValueListAdapter.this.itemsRemoved(event);
            }

            public void itemsReplaced(ListReplaceEvent event) {
                ValueListAdapter.this.itemsReplaced(event);
            }

            public void itemsMoved(ListMoveEvent event) {
                ValueListAdapter.this.itemsMoved(event);
            }

            public void listCleared(ListClearEvent event) {
                ValueListAdapter.this.listCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                ValueListAdapter.this.listChanged(event);
            }

            public String toString() {
                return "value list listener: " + Arrays.asList(ValueListAdapter.this.listNames);
            }
        };
    }

    @Override
    protected void engageValue_() {
        String[] stringArray = this.listNames;
        int n = this.listNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            ((Model)this.value).addListChangeListener(listName, this.valueListListener);
            ++n2;
        }
    }

    @Override
    protected void disengageValue_() {
        String[] stringArray = this.listNames;
        int n = this.listNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            ((Model)this.value).removeListChangeListener(listName, this.valueListListener);
            ++n2;
        }
    }

    protected void itemsAdded(ListAddEvent event) {
        this.valueAspectChanged();
    }

    protected void itemsRemoved(ListRemoveEvent event) {
        this.valueAspectChanged();
    }

    protected void itemsReplaced(ListReplaceEvent event) {
        this.valueAspectChanged();
    }

    protected void itemsMoved(ListMoveEvent event) {
        this.valueAspectChanged();
    }

    protected void listCleared(ListClearEvent event) {
        this.valueAspectChanged();
    }

    protected void listChanged(ListChangeEvent event) {
        this.valueAspectChanged();
    }
}

