/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value.swing;

import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.model.value.FilteringWritablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationWritablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ToggleButtonModelAdapter;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioButtonModelAdapter
extends ToggleButtonModelAdapter {
    public RadioButtonModelAdapter(ModifiablePropertyValueModel<Object> valueHolder, Object buttonValue, boolean defaultValue) {
        super(RadioButtonModelAdapter.buildBooleanHolder(valueHolder, buttonValue), defaultValue);
    }

    public RadioButtonModelAdapter(ModifiablePropertyValueModel<Object> valueHolder, Object buttonValue) {
        super(RadioButtonModelAdapter.buildBooleanHolder(valueHolder, buttonValue));
    }

    public static ModifiablePropertyValueModel<Boolean> buildBooleanHolder(ModifiablePropertyValueModel<Object> valueHolder, Object buttonValue) {
        FilteringWritablePropertyValueModel<Object> filteringPVM = new FilteringWritablePropertyValueModel<Object>(valueHolder, Filter.Transparent.instance(), new SetRadioButtonFilter(buttonValue));
        return new TransformationWritablePropertyValueModel<Object, Boolean>(filteringPVM, new RadioButtonTransformer(buttonValue), new ReverseRadioButtonTransformer(buttonValue));
    }

    @Override
    public void setSelected(boolean b) {
        if (!b && this.isArmed()) {
            return;
        }
        super.setSelected(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RadioButtonTransformer
    implements Transformer<Object, Boolean> {
        private Object buttonValue;

        public RadioButtonTransformer(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        @Override
        public Boolean transform(Object value) {
            return value == null ? null : Boolean.valueOf(value.equals(this.buttonValue));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReverseRadioButtonTransformer
    implements Transformer<Boolean, Object> {
        private Object buttonValue;

        public ReverseRadioButtonTransformer(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        @Override
        public Object transform(Boolean value) {
            return value != false ? this.buttonValue : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetRadioButtonFilter
    implements Filter<Object> {
        private Object buttonValue;

        public SetRadioButtonFilter(Object buttonValue) {
            this.buttonValue = buttonValue;
        }

        @Override
        public boolean accept(Object value) {
            return value != null && value.equals(this.buttonValue);
        }
    }
}

