/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.beans.Introspector;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.JaxbType;
import org.eclipse.jpt.jaxb.core.context.JaxbTypeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlRootElement;
import org.eclipse.jpt.jaxb.core.context.XmlSeeAlso;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaQName;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlSeeAlso;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRootElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSeeAlsoAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTransientAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTypeAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTypeMapping
extends AbstractJavaContextNode
implements JaxbTypeMapping {
    protected boolean xmlTransient;
    protected final JaxbQName qName;
    protected XmlRootElement xmlRootElement;
    protected XmlSeeAlso xmlSeeAlso;

    protected AbstractJavaTypeMapping(JaxbType parent) {
        super(parent);
        this.initXmlTransient();
        this.qName = this.buildQName();
        this.initXmlRootElement();
        this.initializeXmlSeeAlso();
    }

    @Override
    public JaxbType getJaxbType() {
        return (JaxbType)this.getParent();
    }

    protected JavaResourceAbstractType getJavaResourceType() {
        return this.getJaxbType().getJavaResourceType();
    }

    protected JaxbPackage getJaxbPackage() {
        return this.getJaxbType().getJaxbPackage();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncXmlTransient();
        this.qName.synchronizeWithResourceModel();
        this.syncXmlRootElement();
        this.syncXmlSeeAlso();
    }

    @Override
    public void update() {
        super.update();
        this.qName.update();
        this.updateXmlRootElement();
        this.updateXmlSeeAlso();
    }

    @Override
    public boolean isXmlTransient() {
        return this.xmlTransient;
    }

    @Override
    public void setXmlTransient(boolean newValue) {
        this.getJavaResourceType().addAnnotation("javax.xml.bind.annotation.XmlTransient");
        this.setXmlTransient_(newValue);
    }

    protected void setXmlTransient_(boolean newValue) {
        boolean old = this.xmlTransient;
        this.xmlTransient = newValue;
        this.firePropertyChanged("xmlTransient", old, newValue);
    }

    protected XmlTransientAnnotation getXmlTransientAnnotation() {
        return (XmlTransientAnnotation)this.getJavaResourceType().getAnnotation("javax.xml.bind.annotation.XmlTransient");
    }

    protected void initXmlTransient() {
        this.xmlTransient = this.getXmlTransientAnnotation() != null;
    }

    protected void syncXmlTransient() {
        this.setXmlTransient_(this.getXmlTransientAnnotation() != null);
    }

    @Override
    public JaxbQName getQName() {
        return this.qName;
    }

    protected JaxbQName buildQName() {
        return new XmlTypeQName(this);
    }

    protected XmlTypeAnnotation getXmlTypeAnnotation() {
        return (XmlTypeAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlType");
    }

    @Override
    public XmlRootElement getXmlRootElement() {
        return this.xmlRootElement;
    }

    protected void setXmlRootElement_(XmlRootElement rootElement) {
        XmlRootElement old = this.xmlRootElement;
        this.xmlRootElement = rootElement;
        this.firePropertyChanged("xmlRootElement", old, rootElement);
    }

    @Override
    public XmlRootElement addXmlRootElement() {
        if (this.xmlRootElement != null) {
            throw new IllegalStateException();
        }
        XmlRootElementAnnotation annotation = (XmlRootElementAnnotation)this.getJavaResourceType().addAnnotation("javax.xml.bind.annotation.XmlRootElement");
        XmlRootElement xmlRootElement = this.buildXmlRootElement(annotation);
        this.setXmlRootElement_(xmlRootElement);
        return xmlRootElement;
    }

    @Override
    public void removeXmlRootElement() {
        if (this.xmlRootElement == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceType().removeAnnotation("javax.xml.bind.annotation.XmlRootElement");
        this.setXmlRootElement_(null);
    }

    protected XmlRootElementAnnotation getXmlRootElementAnnotation() {
        return (XmlRootElementAnnotation)this.getJavaResourceType().getAnnotation("javax.xml.bind.annotation.XmlRootElement");
    }

    protected XmlRootElement buildXmlRootElement() {
        XmlRootElementAnnotation annotation = this.getXmlRootElementAnnotation();
        return annotation == null ? null : this.buildXmlRootElement(annotation);
    }

    protected XmlRootElement buildXmlRootElement(XmlRootElementAnnotation resourceRootElement) {
        return this.getFactory().buildJavaXmlRootElement(this, resourceRootElement);
    }

    protected void initXmlRootElement() {
        this.xmlRootElement = this.buildXmlRootElement();
    }

    protected void syncXmlRootElement() {
        XmlRootElementAnnotation annotation = this.getXmlRootElementAnnotation();
        if (annotation != null) {
            if (this.xmlRootElement != null) {
                this.xmlRootElement.synchronizeWithResourceModel();
            } else {
                this.setXmlRootElement_(this.buildXmlRootElement(annotation));
            }
        } else if (this.xmlRootElement != null) {
            this.setXmlRootElement_(null);
        }
    }

    protected void updateXmlRootElement() {
        if (this.xmlRootElement != null) {
            this.xmlRootElement.update();
        }
    }

    @Override
    public XmlSeeAlso getXmlSeeAlso() {
        return this.xmlSeeAlso;
    }

    protected void setXmlSeeAlso_(XmlSeeAlso xmlSeeAlso) {
        XmlSeeAlso old = this.xmlSeeAlso;
        this.xmlSeeAlso = xmlSeeAlso;
        this.firePropertyChanged("xmlSeeAlso", old, xmlSeeAlso);
    }

    @Override
    public XmlSeeAlso addXmlSeeAlso() {
        if (this.xmlSeeAlso != null) {
            throw new IllegalStateException();
        }
        XmlSeeAlsoAnnotation annotation = (XmlSeeAlsoAnnotation)this.getJavaResourceType().addAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        XmlSeeAlso xmlSeeAlso = this.buildXmlSeeAlso(annotation);
        this.setXmlSeeAlso_(xmlSeeAlso);
        return xmlSeeAlso;
    }

    @Override
    public void removeXmlSeeAlso() {
        if (this.xmlSeeAlso == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceType().removeAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        this.setXmlSeeAlso_(null);
    }

    protected XmlSeeAlsoAnnotation getXmlSeeAlsoAnnotation() {
        return (XmlSeeAlsoAnnotation)this.getJavaResourceType().getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
    }

    protected XmlSeeAlso buildXmlSeeAlso(XmlSeeAlsoAnnotation annotation) {
        return new GenericJavaXmlSeeAlso(this, annotation);
    }

    protected void initializeXmlSeeAlso() {
        XmlSeeAlsoAnnotation annotation = this.getXmlSeeAlsoAnnotation();
        this.xmlSeeAlso = annotation == null ? null : this.buildXmlSeeAlso(annotation);
    }

    protected void syncXmlSeeAlso() {
        XmlSeeAlsoAnnotation annotation = this.getXmlSeeAlsoAnnotation();
        if (annotation != null) {
            if (this.xmlSeeAlso != null) {
                this.xmlSeeAlso.synchronizeWithResourceModel();
            } else {
                this.setXmlSeeAlso_(this.buildXmlSeeAlso(annotation));
            }
        } else {
            this.setXmlSeeAlso_(null);
        }
    }

    protected void updateXmlSeeAlso() {
        if (this.xmlSeeAlso != null) {
            this.xmlSeeAlso.update();
        }
    }

    @Override
    public final Iterable<String> getReferencedXmlTypeNames() {
        return this.xmlTransient ? this.getTransientReferencedXmlTypeNames() : this.getNonTransientReferencedXmlTypeNames();
    }

    protected Iterable<String> getTransientReferencedXmlTypeNames() {
        return EmptyIterable.instance();
    }

    protected Iterable<String> getNonTransientReferencedXmlTypeNames() {
        if (this.xmlSeeAlso != null) {
            return this.xmlSeeAlso.getReferencedXmlTypeNames();
        }
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result;
        JaxbPackage jaxbPackage = this.getJaxbPackage();
        if (jaxbPackage != null) {
            this.getJaxbProject().getSchemaLibrary().refreshSchema(jaxbPackage.getNamespace());
        }
        if (!CollectionTools.isEmpty(result = super.getJavaCompletionProposals(pos, filter, astRoot))) {
            return result;
        }
        result = this.qName.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        if (this.xmlRootElement != null && !CollectionTools.isEmpty(result = this.xmlRootElement.getJavaCompletionProposals(pos, filter, astRoot))) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getXmlTypeAnnotation().getTextRange(astRoot);
        return textRange != null ? textRange : this.getJaxbType().getValidationTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (!this.xmlTransient) {
            this.qName.validate(messages, reporter, astRoot);
            if (this.xmlRootElement != null) {
                this.xmlRootElement.validate(messages, reporter, astRoot);
            }
        }
    }

    @Override
    public XsdTypeDefinition getXsdTypeDefinition() {
        XsdElementDeclaration xsdElement;
        XsdSchema xsdSchema;
        JaxbPackage jaxbPackage = this.getJaxbPackage();
        XsdSchema xsdSchema2 = xsdSchema = jaxbPackage == null ? null : jaxbPackage.getXsdSchema();
        if (xsdSchema == null) {
            return null;
        }
        if (!StringTools.stringIsEmpty((String)this.qName.getName())) {
            return xsdSchema.getTypeDefinition(this.qName.getNamespace(), this.qName.getName());
        }
        if (this.xmlRootElement != null && (xsdElement = xsdSchema.getElementDeclaration(this.xmlRootElement.getQName().getNamespace(), this.xmlRootElement.getQName().getName())) != null) {
            return xsdElement.getType();
        }
        return null;
    }

    @Override
    public boolean hasRootElementInHierarchy() {
        return this.xmlRootElement != null;
    }

    protected class QNameAnnotationProxy
    extends AbstractJavaQName.AbstractQNameAnnotationProxy {
        protected QNameAnnotationProxy() {
        }

        protected QNameAnnotation getAnnotation(boolean createIfNull) {
            return AbstractJavaTypeMapping.this.getXmlTypeAnnotation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlTypeQName
    extends AbstractJavaQName {
        protected XmlTypeQName(JavaContextNode parent) {
            super(parent, new QNameAnnotationProxy());
        }

        @Override
        protected JaxbPackage getJaxbPackage() {
            return AbstractJavaTypeMapping.this.getJaxbType().getJaxbPackage();
        }

        @Override
        public String getDefaultNamespace() {
            JaxbPackage jaxbPackage = AbstractJavaTypeMapping.this.getJaxbType().getJaxbPackage();
            return jaxbPackage == null ? null : jaxbPackage.getNamespace();
        }

        @Override
        public String getDefaultName() {
            return Introspector.decapitalize(AbstractJavaTypeMapping.this.getJaxbType().getSimpleName());
        }

        @Override
        protected Iterable<String> getNamespaceProposals(Filter<String> filter) {
            XsdSchema schema = this.getXsdSchema();
            if (schema == null) {
                return EmptyIterable.instance();
            }
            return schema.getNamespaceProposals(filter);
        }

        @Override
        protected Iterable<String> getNameProposals(Filter<String> filter) {
            XsdSchema schema = this.getXsdSchema();
            if (schema == null) {
                return EmptyIterable.instance();
            }
            return schema.getTypeNameProposals(this.getNamespace(), filter);
        }

        @Override
        public String getReferencedComponentTypeDescription() {
            return JptJaxbCoreMessages.XML_TYPE_DESC;
        }

        @Override
        protected void validateName(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
            if ("".equals(this.getName()) && !StringTools.stringsAreEqual((String)this.getNamespace(), (String)this.getDefaultNamespace())) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_TYPE__UNMATCHING_NAMESPACE_FOR_ANONYMOUS_TYPE", this, AbstractJavaTypeMapping.this.getXmlTypeAnnotation().getNamespaceTextRange(astRoot)));
            }
        }

        @Override
        protected void validateReference(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
            XsdTypeDefinition schemaType;
            XsdSchema schema;
            String name = this.getName();
            String namespace = this.getNamespace();
            if (!StringTools.stringIsEmpty((String)name) && (schema = this.getXsdSchema()) != null && (schemaType = schema.getTypeDefinition(namespace, name)) == null) {
                messages.add(this.getUnresolveSchemaComponentMessage(astRoot));
            }
        }
    }
}

