/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.XmlAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlNsForm;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaQName;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaXmlNamedNodeMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlIDREF;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAttributeAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdAttributeUse;
import org.eclipse.jpt.jaxb.core.xsd.XsdFeature;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdSimpleTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlAttributeMapping
extends AbstractJavaXmlNamedNodeMapping<XmlAttributeAnnotation>
implements XmlAttributeMapping {
    protected final JaxbQName qName = this.buildQName();
    protected Boolean specifiedRequired = this.buildSpecifiedRequired();

    public GenericJavaXmlAttributeMapping(JaxbPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.qName.synchronizeWithResourceModel();
        this.setSpecifiedRequired_(this.buildSpecifiedRequired());
    }

    @Override
    public void update() {
        super.update();
        this.qName.update();
    }

    @Override
    public String getKey() {
        return "xml-attribute";
    }

    @Override
    protected String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlAttribute";
    }

    @Override
    public JaxbQName getQName() {
        return this.qName;
    }

    protected JaxbQName buildQName() {
        return new XmlAttributeQName(this);
    }

    @Override
    public boolean isRequired() {
        return this.specifiedRequired == null ? this.isDefaultRequired() : this.specifiedRequired.booleanValue();
    }

    @Override
    public Boolean getSpecifiedRequired() {
        return this.specifiedRequired;
    }

    @Override
    public void setSpecifiedRequired(Boolean newSpecifiedRequired) {
        ((XmlAttributeAnnotation)this.getOrCreateAnnotation()).setRequired(newSpecifiedRequired);
        this.setSpecifiedRequired_(newSpecifiedRequired);
    }

    protected void setSpecifiedRequired_(Boolean newSpecifiedRequired) {
        Boolean oldRequired = this.specifiedRequired;
        this.specifiedRequired = newSpecifiedRequired;
        this.firePropertyChanged("specifiedRequired", oldRequired, newSpecifiedRequired);
    }

    protected Boolean buildSpecifiedRequired() {
        XmlAttributeAnnotation annotation = (XmlAttributeAnnotation)this.getAnnotation();
        return annotation == null ? null : annotation.getRequired();
    }

    @Override
    public boolean isDefaultRequired() {
        return false;
    }

    @Override
    protected boolean calculateDefaultXmlList() {
        return this.getPersistentAttribute().isJavaResourceAttributeCollectionType();
    }

    @Override
    protected GenericJavaXmlIDREF.Context buildXmlIDREFContext() {
        return new XmlIDREFContext();
    }

    @Override
    public XsdFeature getXsdFeature() {
        XsdTypeDefinition type = this.getJaxbClassMapping().getXsdTypeDefinition();
        if (type != null) {
            XsdAttributeUse attributeUse = type.getAttribute(this.qName.getNamespace(), this.qName.getName());
            return attributeUse == null ? null : attributeUse.getAttributeDeclaration();
        }
        return null;
    }

    @Override
    public XsdTypeDefinition getDataTypeXsdTypeDefinition() {
        XsdTypeDefinition xsdType = super.getDataTypeXsdTypeDefinition();
        if (xsdType != null && this.isXmlList() && xsdType.getKind() == XsdTypeDefinition.Kind.SIMPLE && ((XsdSimpleTypeDefinition)xsdType).getItemType() != null) {
            xsdType = ((XsdSimpleTypeDefinition)xsdType).getItemType();
        }
        return xsdType;
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        result = this.qName.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateQName(messages, reporter, astRoot);
        this.validateSchemaType(messages, reporter, astRoot);
    }

    protected void validateQName(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.qName.validate(messages, reporter, astRoot);
    }

    protected void validateSchemaType(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        boolean isItemType;
        XsdFeature xsdFeature = this.getXsdFeature();
        if (xsdFeature == null) {
            return;
        }
        XsdTypeDefinition expectedSchemaType = null;
        expectedSchemaType = this.xmlID != null ? XsdUtil.getSchemaForSchema().getTypeDefinition("ID") : (this.xmlIDREF != null ? XsdUtil.getSchemaForSchema().getTypeDefinition("IDREF") : this.getDataTypeXsdTypeDefinition());
        if (expectedSchemaType == null) {
            return;
        }
        boolean bl = isItemType = this.isXmlList() && this.xmlSchemaType == null;
        if (!xsdFeature.typeIsValid(expectedSchemaType, isItemType)) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ATTRIBUTE__INVALID_SCHEMA_TYPE", new String[]{this.getValueTypeName(), xsdFeature.getName()}, this, this.qName.getNameTextRange(astRoot)));
        }
    }

    protected class QNameAnnotationProxy
    extends AbstractJavaQName.AbstractQNameAnnotationProxy {
        protected QNameAnnotationProxy() {
        }

        protected QNameAnnotation getAnnotation(boolean createIfNull) {
            if (createIfNull) {
                return (QNameAnnotation)GenericJavaXmlAttributeMapping.this.getOrCreateAnnotation();
            }
            return (QNameAnnotation)GenericJavaXmlAttributeMapping.this.getAnnotation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlAttributeQName
    extends AbstractJavaQName {
        protected XmlAttributeQName(JavaContextNode parent) {
            super(parent, new QNameAnnotationProxy());
        }

        @Override
        protected JaxbPackage getJaxbPackage() {
            return GenericJavaXmlAttributeMapping.this.getJaxbPackage();
        }

        @Override
        public String getReferencedComponentTypeDescription() {
            return JptJaxbCoreMessages.XML_ATTRIBUTE_DESC;
        }

        @Override
        public String getDefaultName() {
            return GenericJavaXmlAttributeMapping.this.getPersistentAttribute().getJavaResourceAttribute().getName();
        }

        @Override
        public Iterable<String> getNameProposals(Filter<String> filter) {
            XsdTypeDefinition xsdType = GenericJavaXmlAttributeMapping.this.getJaxbClassMapping().getXsdTypeDefinition();
            return xsdType == null ? EmptyIterable.instance() : xsdType.getAttributeNameProposals(this.getNamespace(), filter);
        }

        @Override
        public String getDefaultNamespace() {
            JaxbPackage jaxbPackage = this.getJaxbPackage();
            return jaxbPackage != null && jaxbPackage.getAttributeFormDefault() == XmlNsForm.QUALIFIED ? GenericJavaXmlAttributeMapping.this.getJaxbClassMapping().getQName().getNamespace() : "";
        }

        @Override
        public Iterable<String> getNamespaceProposals(Filter<String> filter) {
            XsdSchema schema = this.getXsdSchema();
            return schema == null ? EmptyIterable.instance() : schema.getNamespaceProposals(filter);
        }

        @Override
        protected void validateReference(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
            XsdTypeDefinition type = GenericJavaXmlAttributeMapping.this.getJaxbClassMapping().getXsdTypeDefinition();
            if (type != null && type.getAttribute(this.getNamespace(), this.getName()) == null) {
                messages.add(this.getUnresolveSchemaComponentMessage(astRoot));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlIDREFContext
    extends AbstractJavaXmlNamedNodeMapping.XmlIDREFContext {
        protected XmlIDREFContext() {
        }

        @Override
        public Iterable<GenericJavaXmlIDREF.ValidatableReference> getReferences() {
            return new SingleElementIterable((Object)new GenericJavaXmlIDREF.ValidatableReference(){

                public String getFullyQualifiedType() {
                    return GenericJavaXmlAttributeMapping.this.getPersistentAttribute().getJavaResourceAttributeBaseTypeName();
                }

                public TextRange getTypeTextRange(CompilationUnit astRoot) {
                    return GenericJavaXmlAttributeMapping.this.getXmlIDREF().getValidationTextRange(astRoot);
                }

                public XsdFeature getXsdFeature() {
                    return GenericJavaXmlAttributeMapping.this.getXsdFeature();
                }

                public TextRange getXsdFeatureTextRange(CompilationUnit astRoot) {
                    return GenericJavaXmlAttributeMapping.this.getQName().getNameTextRange(astRoot);
                }
            });
        }

        @Override
        public boolean isList() {
            return super.isList() || GenericJavaXmlAttributeMapping.this.getPersistentAttribute().isJavaResourceAttributeCollectionType();
        }
    }
}

