/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.xsd;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.xsd.XsdComponent;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdSimpleTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsdSchema
extends XsdComponent<XSDSchema> {
    XsdSchema(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public XSDSchema getXSDSchema() {
        return (XSDSchema)this.getXSDComponent();
    }

    public Iterable<String> getNamespaces() {
        SnapshotCloneIterable result = new SnapshotCloneIterable(this.getXSDSchema().getQNamePrefixToNamespaceMap().values());
        if (StringTools.stringIsEmpty((String)this.getXSDSchema().getTargetNamespace())) {
            result = new CompositeIterable((Object)"", (Iterable)result);
        }
        return result;
    }

    public Iterable<XsdTypeDefinition> getAllTypeDefinitions() {
        return new TransformationIterable<XSDTypeDefinition, XsdTypeDefinition>(this.getAllXSDTypeDefinitions()){

            protected XsdTypeDefinition transform(XSDTypeDefinition o) {
                return (XsdTypeDefinition)((Object)XsdUtil.getAdapter((Notifier)o));
            }
        };
    }

    public Iterable<XsdTypeDefinition> getDeclaredTypeDefinitions() {
        return new TransformationIterable<XSDTypeDefinition, XsdTypeDefinition>(this.getDeclaredXSDTypeDefinitions()){

            protected XsdTypeDefinition transform(XSDTypeDefinition o) {
                return (XsdTypeDefinition)((Object)XsdUtil.getAdapter((Notifier)o));
            }
        };
    }

    public Iterable<XsdTypeDefinition> getBuiltInTypeDefinitions() {
        return new TransformationIterable<XSDTypeDefinition, XsdTypeDefinition>(this.getBuiltInXSDTypeDefinitions()){

            protected XsdTypeDefinition transform(XSDTypeDefinition o) {
                return (XsdTypeDefinition)((Object)XsdUtil.getAdapter((Notifier)o));
            }
        };
    }

    public Iterable<XsdTypeDefinition> getTypeDefinitions(String namespace) {
        return new TransformationIterable<XSDTypeDefinition, XsdTypeDefinition>(this.getXSDTypeDefinitions(namespace)){

            protected XsdTypeDefinition transform(XSDTypeDefinition o) {
                return (XsdTypeDefinition)((Object)XsdUtil.getAdapter((Notifier)o));
            }
        };
    }

    public Iterable<XsdSimpleTypeDefinition> getSimpleTypeDefinitions(String namespace) {
        return new TransformationIterable<XSDSimpleTypeDefinition, XsdSimpleTypeDefinition>(this.getXSDSimpleTypeDefinitions(namespace)){

            protected XsdSimpleTypeDefinition transform(XSDSimpleTypeDefinition o) {
                return (XsdSimpleTypeDefinition)((Object)XsdUtil.getAdapter((Notifier)o));
            }
        };
    }

    public XsdTypeDefinition getTypeDefinition(String name) {
        return this.getTypeDefinition(((XSDSchema)this.getXSDComponent()).getTargetNamespace(), name);
    }

    public XsdTypeDefinition getTypeDefinition(String namespace, String name) {
        for (XSDTypeDefinition typeDefinition : this.getXSDTypeDefinitions(namespace)) {
            if (!XsdUtil.namespaceEquals((XSDNamedComponent)typeDefinition, namespace) || !typeDefinition.getName().equals(name)) continue;
            return (XsdTypeDefinition)((Object)XsdUtil.getAdapter((Notifier)typeDefinition));
        }
        return null;
    }

    protected Iterable<XSDTypeDefinition> getAllXSDTypeDefinitions() {
        return new CompositeIterable(new Iterable[]{this.getDeclaredXSDTypeDefinitions(), this.getBuiltInXSDTypeDefinitions()});
    }

    protected Iterable<XSDTypeDefinition> getDeclaredXSDTypeDefinitions() {
        return new SnapshotCloneIterable((Collection)this.getXSDSchema().getTypeDefinitions());
    }

    protected Iterable<XSDTypeDefinition> getBuiltInXSDTypeDefinitions() {
        return new SnapshotCloneIterable((Collection)this.getXSDSchema().getSchemaForSchema().getTypeDefinitions());
    }

    protected Iterable<XSDTypeDefinition> getXSDTypeDefinitions(final String namespace) {
        if ("http://www.w3.org/2001/XMLSchema".equals(namespace)) {
            return this.getBuiltInXSDTypeDefinitions();
        }
        return new FilteringIterable<XSDTypeDefinition>(this.getDeclaredXSDTypeDefinitions()){

            protected boolean accept(XSDTypeDefinition o) {
                return XsdUtil.namespaceEquals((XSDNamedComponent)o, namespace);
            }
        };
    }

    protected Iterable<XSDSimpleTypeDefinition> getXSDSimpleTypeDefinitions(String namespace) {
        return new TransformationIterable<XSDTypeDefinition, XSDSimpleTypeDefinition>((Iterable)new FilteringIterable<XSDTypeDefinition>(this.getXSDTypeDefinitions(namespace)){

            protected boolean accept(XSDTypeDefinition o) {
                return o instanceof XSDSimpleTypeDefinition;
            }
        }){

            protected XSDSimpleTypeDefinition transform(XSDTypeDefinition o) {
                return (XSDSimpleTypeDefinition)o;
            }
        };
    }

    public Iterable<XsdElementDeclaration> getElementDeclarations() {
        return new TransformationIterable<XSDElementDeclaration, XsdElementDeclaration>(this.getXSDElementDeclarations()){

            protected XsdElementDeclaration transform(XSDElementDeclaration o) {
                return (XsdElementDeclaration)((Object)XsdUtil.getAdapter((Notifier)o));
            }
        };
    }

    public Iterable<XsdElementDeclaration> getElementDeclarations(final String namespace) {
        return new TransformationIterable<XSDElementDeclaration, XsdElementDeclaration>((Iterable)new FilteringIterable<XSDElementDeclaration>(this.getXSDElementDeclarations()){

            protected boolean accept(XSDElementDeclaration o) {
                return XsdUtil.namespaceEquals((XSDNamedComponent)o, namespace);
            }
        }){

            protected XsdElementDeclaration transform(XSDElementDeclaration o) {
                return (XsdElementDeclaration)((Object)XsdUtil.getAdapter((Notifier)o));
            }
        };
    }

    public XsdElementDeclaration getElementDeclaration(String namespace, String name) {
        for (XSDElementDeclaration elementDeclaration : this.getXSDElementDeclarations()) {
            if (!XsdUtil.namespaceEquals((XSDNamedComponent)elementDeclaration, namespace) || !elementDeclaration.getName().equals(name)) continue;
            return (XsdElementDeclaration)((Object)XsdUtil.getAdapter((Notifier)elementDeclaration));
        }
        return null;
    }

    protected Iterable<XSDElementDeclaration> getXSDElementDeclarations() {
        return new SnapshotCloneIterable((Collection)this.getXSDSchema().getElementDeclarations());
    }

    public Iterable<String> getNamespaceProposals(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals((Iterable)new FilteringIterable(this.getNamespaces(), filter));
    }

    public Iterable<String> getTypeNameProposals(String namespace, Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals((Iterable)new FilteringIterable((Iterable)new TransformationIterable<XsdTypeDefinition, String>(this.getTypeDefinitions(namespace)){

            protected String transform(XsdTypeDefinition o) {
                return o.getName();
            }
        }, filter));
    }

    public Iterable<String> getSimpleTypeNameProposals(String namespace, Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals((Iterable)new FilteringIterable((Iterable)new TransformationIterable<XsdSimpleTypeDefinition, String>(this.getSimpleTypeDefinitions(namespace)){

            protected String transform(XsdSimpleTypeDefinition o) {
                return o.getName();
            }
        }, filter));
    }

    public Iterable<String> getElementNameProposals(String namespace, Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals((Iterable)new FilteringIterable((Iterable)new TransformationIterable<XsdElementDeclaration, String>(this.getElementDeclarations(namespace)){

            protected String transform(XsdElementDeclaration o) {
                return o.getName();
            }
        }, filter));
    }
}

