/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlJoinNodeAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceXmlJoinNodeAnnotation
extends SourceAnnotation
implements XmlJoinNodeAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.oxm.annotations.XmlJoinNode");
    public static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.oxm.annotations.XmlJoinNodes");
    private final DeclarationAnnotationElementAdapter<String> xmlPathDeclarationAdapter;
    private final AnnotationElementAdapter<String> xmlPathAdapter;
    private String xmlPath;
    private final DeclarationAnnotationElementAdapter<String> referencedXmlPathDeclarationAdapter;
    private final AnnotationElementAdapter<String> referencedXmlPathAdapter;
    private String referencedXmlPath;

    public static SourceXmlJoinNodeAnnotation buildSourceXmlJoinNodeAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, int index) {
        IndexedDeclarationAnnotationAdapter idaa = SourceXmlJoinNodeAnnotation.buildXmlJoinNodeDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = SourceXmlJoinNodeAnnotation.buildXmlJoinNodeAnnotationAdapter(annotatedElement, idaa);
        return new SourceXmlJoinNodeAnnotation(parent, annotatedElement, idaa, iaa);
    }

    private SourceXmlJoinNodeAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter daa, IndexedAnnotationAdapter annotationAdapter) {
        super((JavaResourceNode)parent, annotatedElement, (DeclarationAnnotationAdapter)daa, (AnnotationAdapter)annotationAdapter);
        this.xmlPathDeclarationAdapter = this.buildXmlPathAdapter((DeclarationAnnotationAdapter)daa);
        this.xmlPathAdapter = this.buildAnnotationElementAdapter(this.xmlPathDeclarationAdapter);
        this.referencedXmlPathDeclarationAdapter = this.buildReferencedXmlPathAdapter((DeclarationAnnotationAdapter)daa);
        this.referencedXmlPathAdapter = this.buildAnnotationElementAdapter(this.referencedXmlPathDeclarationAdapter);
    }

    private DeclarationAnnotationElementAdapter<String> buildXmlPathAdapter(DeclarationAnnotationAdapter daa) {
        return this.buildAnnotationElementAdapter(daa, "xmlPath", (ExpressionConverter<String>)StringExpressionConverter.instance());
    }

    private DeclarationAnnotationElementAdapter<String> buildReferencedXmlPathAdapter(DeclarationAnnotationAdapter daa) {
        return this.buildAnnotationElementAdapter(daa, "referencedXmlPath", (ExpressionConverter<String>)StringExpressionConverter.instance());
    }

    private DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.oxm.annotations.XmlJoinNode";
    }

    public void initialize(CompilationUnit astRoot) {
        this.xmlPath = this.buildXmlPath(astRoot);
        this.referencedXmlPath = this.buildReferencedXmlPath(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncXmlPath(this.buildXmlPath(astRoot));
        this.syncReferencedXmlPath(this.buildReferencedXmlPath(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(String.valueOf(this.xmlPath) + " -> " + this.referencedXmlPath);
    }

    @Override
    public String getXmlPath() {
        return this.xmlPath;
    }

    @Override
    public void setXmlPath(String xmlPath) {
        if (this.attributeValueHasChanged(this.xmlPath, xmlPath)) {
            this.xmlPath = xmlPath;
            this.xmlPathAdapter.setValue((Object)xmlPath);
        }
    }

    private void syncXmlPath(String astXmlPath) {
        String old = this.xmlPath;
        this.xmlPath = astXmlPath;
        this.firePropertyChanged("xmlPath", old, astXmlPath);
    }

    private String buildXmlPath(CompilationUnit astRoot) {
        return (String)this.xmlPathAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getXmlPathTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.xmlPathDeclarationAdapter, astRoot);
    }

    @Override
    public boolean xmlPathTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.xmlPathDeclarationAdapter, pos, astRoot);
    }

    @Override
    public String getReferencedXmlPath() {
        return this.referencedXmlPath;
    }

    @Override
    public void setReferencedXmlPath(String referencedXmlPath) {
        if (this.attributeValueHasChanged(this.referencedXmlPath, referencedXmlPath)) {
            this.referencedXmlPath = referencedXmlPath;
            this.referencedXmlPathAdapter.setValue((Object)referencedXmlPath);
        }
    }

    private void syncReferencedXmlPath(String astReferencedXmlPath) {
        String old = this.referencedXmlPath;
        this.referencedXmlPath = astReferencedXmlPath;
        this.firePropertyChanged("referencedXmlPath", old, astReferencedXmlPath);
    }

    private String buildReferencedXmlPath(CompilationUnit astRoot) {
        return (String)this.referencedXmlPathAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getReferencedXmlPathTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.referencedXmlPathDeclarationAdapter, astRoot);
    }

    @Override
    public boolean referencedXmlPathTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.referencedXmlPathDeclarationAdapter, pos, astRoot);
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    private IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    private static IndexedAnnotationAdapter buildXmlJoinNodeAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    private static IndexedDeclarationAnnotationAdapter buildXmlJoinNodeDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        return idaa;
    }
}

