/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import java.util.HashSet;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.internal.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.utility.command.CommandJobCommandAdapter;
import org.eclipse.jpt.common.core.internal.utility.command.SimpleJobCommandExecutor;
import org.eclipse.jpt.common.core.internal.utility.command.SingleUseQueueingExtendedJobCommandExecutor;
import org.eclipse.jpt.common.core.utility.command.ExtendedJobCommandExecutor;
import org.eclipse.jpt.common.core.utility.command.JobCommand;
import org.eclipse.jpt.common.utility.BooleanReference;
import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.ModifiableObjectReference;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandExecutor;
import org.eclipse.jpt.common.utility.command.ExtendedCommandExecutor;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.command.ThreadLocalExtendedCommandExecutor;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaProject;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.internal.SimpleJpaProjectConfig;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalJpaProjectManager
extends AbstractModel
implements JpaProjectManager,
JpaProject.Manager {
    private final IWorkspace workspace;
    private volatile ExtendedJobCommandExecutor commandExecutor;
    private final Vector<JpaProject> jpaProjects = new Vector();
    private final IResourceChangeListener resourceChangeListener = new ResourceChangeListener();
    private static final int RESOURCE_CHANGE_EVENT_TYPES = 17;
    private static final String FACETED_PROJECT_FRAMEWORK_SETTINGS_FILE_NAME = "org.eclipse.wst.common.project.facet.core.xml";
    private final JavaElementChangeListener javaElementChangeListener = new JavaElementChangeListener();
    private static final int JAVA_CHANGE_EVENT_TYPES = 5;
    private final HashSet<BooleanReference> asyncEventListenerFlags = new HashSet();
    private final ThreadLocalExtendedCommandExecutor modifySharedDocumentCommandExecutor = new ThreadLocalExtendedCommandExecutor();
    private final ExceptionHandler exceptionHandler;
    volatile boolean test = false;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String DEBUG_OPTION = JpaProjectManager.class.getSimpleName();
    private static final String DEBUG_OPTION_ = String.valueOf(DEBUG_OPTION) + '.';
    private static final String DEBUG_STACK_TRACE_OPTION = String.valueOf(DEBUG_OPTION_) + "stack_trace";

    public InternalJpaProjectManager(IWorkspace workspace) {
        this.workspace = workspace;
        this.exceptionHandler = this.buildExceptionHandler();
    }

    private ExceptionHandler buildExceptionHandler() {
        return new LocalExceptionHandler();
    }

    public void start() {
        InternalJpaProjectManager.debug("*** JPA project manager START ***");
        try {
            this.commandExecutor = this.buildAsynchronousCommandExecutor();
            this.buildJpaProjects();
            this.workspace.addResourceChangeListener(this.resourceChangeListener, 17);
            JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener, (int)5);
        }
        catch (RuntimeException ex) {
            this.log(ex);
            this.stop();
        }
    }

    public void stop() {
        InternalJpaProjectManager.debug("*** JPA project manager STOP ***");
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        this.workspace.removeResourceChangeListener(this.resourceChangeListener);
        this.clearJpaProjects();
        this.commandExecutor = ExtendedJobCommandExecutor.Inactive.instance();
        InternalJpaProjectManager.debug("*** JPA project manager DEAD ***");
    }

    private void buildJpaProjects() {
        InternalJpaProjectManager.debug("dispatch: build JPA projects");
        BuildJpaProjectsCommand command = new BuildJpaProjectsCommand();
        this.execute((JobCommand)command, JptCoreMessages.BUILD_JPA_PROJECTS_JOB_NAME, (ISchedulingRule)this.getWorkspaceRoot());
    }

    void buildJpaProjects_(IProgressMonitor monitor) {
        InternalJpaProjectManager.debug("execute: build JPA projects");
        try {
            this.getWorkspaceRoot().accept((IResourceProxyVisitor)new ResourceProxyVisitor(monitor), 0);
        }
        catch (Exception ex) {
            this.log(ex);
        }
        InternalJpaProjectManager.debug("end: build JPA projects");
    }

    private void clearJpaProjects() {
        try {
            this.getJobManager().beginRule((ISchedulingRule)this.getWorkspaceRoot(), null);
            this.clearJpaProjects_();
        }
        finally {
            this.getJobManager().endRule((ISchedulingRule)this.getWorkspaceRoot());
        }
    }

    private void clearJpaProjects_() {
        InternalJpaProjectManager.debug("execute: clear JPA projects");
        for (JpaProject jpaProject : this.getJpaProjects()) {
            this.removeJpaProject(jpaProject);
        }
        InternalJpaProjectManager.debug("end: clear JPA projects");
    }

    @Override
    public Iterable<JpaProject> waitToGetJpaProjects() throws InterruptedException {
        InternalJpaProjectManager.debug("dispatch: get JPA projects");
        GetJpaProjectsCommand command = new GetJpaProjectsCommand();
        this.waitToExecute(command, JptCoreMessages.GET_JPA_PROJECTS_JOB_NAME, (ISchedulingRule)this.getWorkspaceRoot());
        return command.result;
    }

    Iterable<JpaProject> getJpaProjects_() {
        InternalJpaProjectManager.debug("execute: get JPA projects: {0}", this.jpaProjects);
        return this.getJpaProjects();
    }

    @Override
    public Iterable<JpaProject> getJpaProjects() {
        return new SnapshotCloneIterable(this.jpaProjects);
    }

    @Override
    public int getJpaProjectsSize() {
        return this.jpaProjects.size();
    }

    JpaProject waitToGetJpaProject(IProject project) throws InterruptedException {
        InternalJpaProjectManager.debug("dispatch: get JPA project: {0}", project.getName());
        GetJpaProjectCommand command = new GetJpaProjectCommand(project);
        this.waitToExecute(command, JptCoreMessages.GET_JPA_PROJECT_JOB_NAME, (ISchedulingRule)project);
        return command.result;
    }

    private boolean waitToGetJpaProject(ModifiableObjectReference<JpaProject> jpaProjectRef, IProject project, long timeout) throws InterruptedException {
        InternalJpaProjectManager.debug("dispatch: get JPA project (time-out): {0}", project.getName());
        GetJpaProjectCommand command = new GetJpaProjectCommand(project);
        boolean result = this.waitToExecute(command, JptCoreMessages.GET_JPA_PROJECT_JOB_NAME, (ISchedulingRule)project, timeout);
        if (result) {
            jpaProjectRef.setValue((Object)command.result);
        } else {
            InternalJpaProjectManager.debug("time-out: get JPA project: {0}", project.getName());
        }
        return result;
    }

    JpaProject getJpaProjectUnsafe(IProject project) {
        InternalJpaProjectManager.debug("execute: get JPA project: {0}", project.getName());
        JpaProject jpaProject = InternalJpaProjectManager.selectJpaProject(this.jpaProjects, project);
        if (jpaProject == null) {
            InternalJpaProjectManager.debug("not found: get JPA project: {0}", project.getName());
        }
        return jpaProject;
    }

    JpaProject getJpaProject_(IProject project) {
        return InternalJpaProjectManager.selectJpaProject(this.getJpaProjects(), project);
    }

    private static JpaProject selectJpaProject(Iterable<JpaProject> jpaProjects, IProject project) {
        for (JpaProject jpaProject : jpaProjects) {
            if (!jpaProject.getProject().equals((Object)project)) continue;
            return jpaProject;
        }
        return null;
    }

    JpaProject rebuildJpaProject(IProject project) throws InterruptedException {
        InternalJpaProjectManager.debug("dispatch: rebuild JPA project: {0}", project.getName());
        RebuildJpaProjectCommand command = new RebuildJpaProjectCommand(project);
        this.waitToExecute(command, JptCoreMessages.REBUILD_JPA_PROJECT_JOB_NAME, (ISchedulingRule)project);
        return command.result;
    }

    JpaProject rebuildJpaProject_(IProject project, IProgressMonitor monitor) {
        InternalJpaProjectManager.debug("execute: rebuild JPA project: {0}", project.getName());
        this.removeJpaProject(this.getJpaProject_(project));
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return this.addJpaProject(project);
    }

    Iterable<IMessage> buildValidationMessages(IProject project, IReporter reporter) throws InterruptedException {
        InternalJpaProjectManager.debug("dispatch: build validation messages: {0}", project.getName());
        BuildValidationMessagesCommand command = new BuildValidationMessagesCommand(project, reporter);
        this.waitToExecute(command, JptCoreMessages.BUILD_VALIDATION_MESSAGES_JOB_NAME, (ISchedulingRule)project);
        return command.result;
    }

    Iterable<IMessage> buildValidationMessages_(IProject project, IReporter reporter) {
        InternalJpaProjectManager.debug("execute: build validation messages: {0}", project.getName());
        JpaProject jpaProject = this.getJpaProject_(project);
        if (jpaProject == null) {
            return this.buildNoJpaProjectMessages(project);
        }
        try {
            return jpaProject.getValidationMessages(reporter);
        }
        catch (RuntimeException ex) {
            this.log(ex);
            return EmptyIterable.instance();
        }
    }

    private Iterable<IMessage> buildNoJpaProjectMessages(IProject project) {
        return new SingleElementIterable((Object)this.buildNoJpaProjectMessage(project));
    }

    private IMessage buildNoJpaProjectMessage(IProject project) {
        return DefaultJpaValidationMessages.buildMessage(1, "NO_JPA_PROJECT", (IResource)project);
    }

    JpaProject addJpaProject(IProject project) {
        JpaProject jpaProject = this.buildJpaProject(project);
        if (jpaProject == null) {
            InternalJpaProjectManager.dumpStackTrace("add JPA project fail: {0}", project);
        } else {
            InternalJpaProjectManager.dumpStackTrace("add JPA project: {0}", jpaProject);
        }
        if (jpaProject != null) {
            this.addItemToCollection(jpaProject, this.jpaProjects, "jpaProjects");
        }
        return jpaProject;
    }

    private JpaProject buildJpaProject(IProject project) {
        return this.buildJpaProject(this.buildJpaProjectConfig(project));
    }

    private JpaProject buildJpaProject(JpaProject.Config config) {
        return this.buildJpaProject(config.getJpaPlatform(), config);
    }

    private JpaProject buildJpaProject(JpaPlatform jpaPlatform, JpaProject.Config config) {
        try {
            return jpaPlatform == null ? null : jpaPlatform.getJpaFactory().buildJpaProject(config);
        }
        catch (RuntimeException ex) {
            this.log(ex);
            return null;
        }
    }

    private JpaProject.Config buildJpaProjectConfig(IProject project) {
        SimpleJpaProjectConfig config = new SimpleJpaProjectConfig();
        config.setJpaProjectManager(this);
        config.setProject(project);
        config.setJpaPlatform(JptJpaCorePlugin.getJpaPlatformManager().buildJpaPlatformImplementation(project));
        config.setConnectionProfileName(JptJpaCorePlugin.getConnectionProfileName(project));
        config.setUserOverrideDefaultCatalog(JptJpaCorePlugin.getUserOverrideDefaultCatalog(project));
        config.setUserOverrideDefaultSchema(JptJpaCorePlugin.getUserOverrideDefaultSchema(project));
        config.setDiscoverAnnotatedClasses(JptJpaCorePlugin.getDiscoverAnnotatedClasses(project));
        config.setMetamodelSourceFolderName(JptJpaCorePlugin.getMetamodelSourceFolderName(project));
        return config;
    }

    private void removeJpaProject(JpaProject jpaProject) {
        InternalJpaProjectManager.dumpStackTrace("remove JPA project: {0}", jpaProject);
        this.removeItemFromCollection(jpaProject, this.jpaProjects, "jpaProjects");
        try {
            jpaProject.dispose();
        }
        catch (RuntimeException ex) {
            this.log(ex);
        }
    }

    void projectChanged(IResourceDelta delta) {
        InternalJpaProjectManager.debug("dispatch: project changed: {0}", delta.getResource());
        ProjectChangeEventHandlerCommand command = new ProjectChangeEventHandlerCommand(delta);
        this.execute((JobCommand)command, JptCoreMessages.PROJECT_CHANGE_EVENT_HANDLER_JOB_NAME, (ISchedulingRule)this.getWorkspaceRoot());
    }

    void projectChanged_(IResourceDelta delta, IProgressMonitor monitor) {
        InternalJpaProjectManager.debug("execute: project changed: {0}", delta.getResource());
        for (JpaProject jpaProject : this.jpaProjects) {
            try {
                jpaProject.projectChanged(delta);
            }
            catch (RuntimeException ex) {
                this.log(ex);
            }
            if (!monitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    void projectPostCleanBuild(IProject project) {
        InternalJpaProjectManager.debug("dispatch: post clean build: {0}", project.getName());
        ProjectPostCleanBuildEventHandlerCommand command = new ProjectPostCleanBuildEventHandlerCommand(project);
        this.execute((JobCommand)command, JptCoreMessages.PROJECT_POST_CLEAN_BUILD_EVENT_HANDLER_JOB_NAME, (ISchedulingRule)project);
    }

    void projectPostCleanBuild_(IProject project, IProgressMonitor monitor) {
        InternalJpaProjectManager.debug("execute: post clean build: {0}", project.getName());
        JpaProject jpaProject = this.getJpaProject_(project);
        if (jpaProject != null) {
            this.removeJpaProject(jpaProject);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.addJpaProject(project);
        }
    }

    void checkForJpaFacetTransition(IProject project) {
        InternalJpaProjectManager.debug("dispatch: project facet file changed: {0}", project.getName());
        FacetFileChangeEventHandlerCommand command = new FacetFileChangeEventHandlerCommand(project);
        this.execute(command, JptCoreMessages.FACET_FILE_CHANGE_EVENT_HANDLER_JOB_NAME, (ISchedulingRule)project);
    }

    void checkForJpaFacetTransition_(IProject project) {
        InternalJpaProjectManager.debug("execute: project facet file changed: {0}", project.getName());
        JpaProject jpaProject = this.getJpaProject_(project);
        if (JpaFacet.isInstalled(project)) {
            if (jpaProject == null) {
                this.addJpaProject(project);
            }
        } else if (jpaProject != null) {
            this.removeJpaProject(jpaProject);
        }
    }

    void javaElementChanged(ElementChangedEvent event) {
        if (this.handleJavaElementChangedEvent(event)) {
            InternalJpaProjectManager.debug("dispatch: Java element changed: {0}", event.getDelta());
            JavaChangeEventHandlerCommand command = new JavaChangeEventHandlerCommand(event);
            this.execute((JobCommand)command, JptCoreMessages.JAVA_CHANGE_EVENT_HANDLER_JOB_NAME, (ISchedulingRule)this.getWorkspaceRoot());
        }
    }

    void javaElementChanged_(ElementChangedEvent event, IProgressMonitor monitor) {
        InternalJpaProjectManager.debug("execute: Java element changed: {0}", event.getDelta());
        for (JpaProject jpaProject : this.jpaProjects) {
            try {
                jpaProject.javaElementChanged(event);
            }
            catch (RuntimeException ex) {
                this.log(ex);
            }
            if (!monitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }

    private boolean handleJavaElementChangedEvent(ElementChangedEvent event) {
        return this.handleJavaDelta(event.getDelta());
    }

    protected boolean handleJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: {
                return this.handleJavaModelDelta(delta);
            }
            case 2: {
                return this.handleJavaProjectDelta(delta);
            }
            case 3: {
                return this.handleJavaPackageFragmentRootDelta(delta);
            }
            case 4: {
                return this.processJavaPackageFragmentDelta(delta);
            }
            case 5: {
                return this.handleJavaCompilationUnitDelta(delta);
            }
        }
        return false;
    }

    protected boolean handleJavaDeltaChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            if (this.handleJavaDelta(child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean handleJavaModelDelta(IJavaElementDelta delta) {
        return this.handleJavaDeltaChildren(delta);
    }

    protected boolean handleJavaProjectDelta(IJavaElementDelta delta) {
        return this.handleJavaDeltaChildren(delta) || AbstractJpaProject.classpathHasChanged(delta);
    }

    protected boolean handleJavaPackageFragmentRootDelta(IJavaElementDelta delta) {
        return this.handleJavaDeltaChildren(delta) || AbstractJpaProject.classpathEntryHasBeenAdded(delta) || AbstractJpaProject.classpathEntryHasBeenRemoved(delta);
    }

    protected boolean processJavaPackageFragmentDelta(IJavaElementDelta delta) {
        return this.handleJavaDeltaChildren(delta);
    }

    protected boolean handleJavaCompilationUnitDelta(IJavaElementDelta delta) {
        return AbstractJpaProject.javaCompilationUnitDeltaIsRelevant(delta);
    }

    @Override
    public ExtendedCommandExecutor getModifySharedDocumentCommandExecutor() {
        return this.modifySharedDocumentCommandExecutor;
    }

    private void setThreadLocalModifySharedDocumentCommandExecutor(ExtendedCommandExecutor commandExecutor) {
        this.modifySharedDocumentCommandExecutor.set((CommandExecutor)commandExecutor);
    }

    @Override
    public void log(String msg) {
        JptJpaCorePlugin.log(msg);
    }

    @Override
    public void log(Throwable throwable) {
        JptJpaCorePlugin.log(throwable);
    }

    @Override
    public void log(String msg, Throwable throwable) {
        JptJpaCorePlugin.log(msg, throwable);
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return this.workspace.getRoot();
    }

    private ISchedulingRule getCurrentRule() {
        return this.getJobManager().currentRule();
    }

    private IJobManager getJobManager() {
        return Job.getJobManager();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getJpaProjects());
    }

    @Override
    public void execute(JobCommand command, String jobName, JpaProject jpaProject) {
        InternalJpaProjectManager.debug("dispatch: client command: {0}", command);
        this.execute((JobCommand)new ClientJobCommandWrapper(command, jpaProject), jobName, (ISchedulingRule)jpaProject.getProject());
    }

    private void execute(Command command, String jobName, ISchedulingRule schedulingRule) {
        this.execute((JobCommand)new CommandJobCommandAdapter(command), jobName, schedulingRule);
    }

    private void execute(JobCommand command, String jobName, ISchedulingRule schedulingRule) {
        this.commandExecutor.execute(command, jobName, schedulingRule);
    }

    private void waitToExecute(Command command, String jobName, ISchedulingRule schedulingRule) throws InterruptedException {
        this.waitToExecute((JobCommand)new CommandJobCommandAdapter(command), jobName, schedulingRule);
    }

    private void waitToExecute(JobCommand command, String jobName, ISchedulingRule schedulingRule) throws InterruptedException {
        this.waitToExecute(command, jobName, schedulingRule, 0L);
    }

    private boolean waitToExecute(Command command, String jobName, ISchedulingRule schedulingRule, long timeout) throws InterruptedException {
        return this.waitToExecute((JobCommand)new CommandJobCommandAdapter(command), jobName, schedulingRule, timeout);
    }

    private boolean waitToExecute(JobCommand command, String jobName, ISchedulingRule schedulingRule, long timeout) throws InterruptedException {
        ISchedulingRule currentRule = this.getCurrentRule();
        if (currentRule != null && schedulingRule.isConflicting(currentRule)) {
            InternalJpaProjectManager.dumpStackTrace("scheduling rule conflict: {0} vs. {1}", schedulingRule, currentRule);
            command.execute((IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        return this.commandExecutor.waitToExecute(command, jobName, schedulingRule, timeout);
    }

    @Override
    public void execute(Command command) throws InterruptedException {
        this.execute(command, null);
    }

    @Override
    public void execute(Command command, ExtendedCommandExecutor threadLocalModifySharedDocumentCommandExecutor) throws InterruptedException {
        this.setThreadLocalModifySharedDocumentCommandExecutor(threadLocalModifySharedDocumentCommandExecutor);
        this.executeCommandsSynchronously();
        try {
            command.execute();
        }
        finally {
            this.executeCommandsAsynchronously();
        }
        this.setThreadLocalModifySharedDocumentCommandExecutor(null);
    }

    private synchronized void executeCommandsSynchronously() throws InterruptedException {
        if (!(this.commandExecutor instanceof SimpleJobCommandExecutor)) {
            throw new IllegalStateException();
        }
        this.addAsyncEventListenerFlag(BooleanReference.False.instance());
        SimpleJobCommandExecutor old = (SimpleJobCommandExecutor)this.commandExecutor;
        SingleUseQueueingExtendedJobCommandExecutor newCE = this.buildSynchronousCommandExecutor();
        this.commandExecutor = newCE;
        old.waitToExecute(Command.Null.instance());
        newCE.start();
    }

    private SingleUseQueueingExtendedJobCommandExecutor buildSynchronousCommandExecutor() {
        return new SingleUseQueueingExtendedJobCommandExecutor();
    }

    private synchronized void executeCommandsAsynchronously() {
        if (!(this.commandExecutor instanceof SingleUseQueueingExtendedJobCommandExecutor)) {
            throw new IllegalStateException();
        }
        this.commandExecutor = this.buildAsynchronousCommandExecutor();
        this.removeAsyncEventListenerFlag(BooleanReference.False.instance());
    }

    private SimpleJobCommandExecutor buildAsynchronousCommandExecutor() {
        return new SimpleJobCommandExecutor(JptCommonCoreMessages.DALI_JOB_NAME);
    }

    void execute_(JobCommand command, IProgressMonitor monitor, JpaProject jpaProject) {
        if (this.jpaProjects.contains(jpaProject)) {
            InternalJpaProjectManager.debug("execute: client command: {0}", command);
            command.execute(monitor);
        } else {
            InternalJpaProjectManager.debug("ignore: client command: {0}", command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean asyncEventListenersAreActive() {
        HashSet<BooleanReference> hashSet = this.asyncEventListenerFlags;
        synchronized (hashSet) {
            return this.asyncEventListenersAreActive_();
        }
    }

    private boolean asyncEventListenersAreActive_() {
        for (BooleanReference flag : this.asyncEventListenerFlags) {
            if (!flag.isFalse()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAsyncEventListenerFlag(BooleanReference flag) {
        HashSet<BooleanReference> hashSet = this.asyncEventListenerFlags;
        synchronized (hashSet) {
            this.addAsyncEventListenerFlag_(flag);
        }
    }

    private void addAsyncEventListenerFlag_(BooleanReference flag) {
        if (!this.asyncEventListenerFlags.add(flag)) {
            throw new IllegalArgumentException("duplicate flag: " + flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAsyncEventListenerFlag(BooleanReference flag) {
        HashSet<BooleanReference> hashSet = this.asyncEventListenerFlags;
        synchronized (hashSet) {
            this.removeAsyncEventListenerFlag_(flag);
        }
    }

    private void removeAsyncEventListenerFlag_(BooleanReference flag) {
        if (!this.asyncEventListenerFlags.remove(flag)) {
            throw new IllegalArgumentException("missing flag: " + flag);
        }
    }

    static void debug(String message) {
        InternalJpaProjectManager.debug(message, EMPTY_OBJECT_ARRAY);
    }

    static void debug(String message, Object ... args) {
        if (InternalJpaProjectManager.debug()) {
            InternalJpaProjectManager.debug_(message, args);
        }
    }

    private static void debug_(String message, Object ... args) {
        JptJpaCorePlugin.instance().log(1, NLS.bind((String)message, (Object[])args));
    }

    private static boolean debug() {
        return JptJpaCorePlugin.instance().getBooleanDebugOption(DEBUG_OPTION);
    }

    static void dumpStackTrace(String message) {
        InternalJpaProjectManager.dumpStackTrace(message, EMPTY_OBJECT_ARRAY);
    }

    static void dumpStackTrace(String message, Object ... args) {
        if (InternalJpaProjectManager.debug()) {
            InternalJpaProjectManager.dumpStackTrace_(message, args);
        }
    }

    private static void dumpStackTrace_(String message, Object ... args) {
        Exception ex = InternalJpaProjectManager.debugStackTrace() ? new Exception() : null;
        JptJpaCorePlugin.instance().log(1, NLS.bind((String)message, (Object[])args), ex);
    }

    private static boolean debugStackTrace() {
        return JptJpaCorePlugin.instance().getBooleanDebugOption(DEBUG_STACK_TRACE_OPTION);
    }

    class BuildJpaProjectsCommand
    implements JobCommand {
        BuildJpaProjectsCommand() {
        }

        public IStatus execute(IProgressMonitor monitor) {
            InternalJpaProjectManager.this.buildJpaProjects_(monitor);
            return Status.OK_STATUS;
        }
    }

    class BuildValidationMessagesCommand
    implements Command {
        private final IProject project;
        private final IReporter reporter;
        Iterable<IMessage> result;

        BuildValidationMessagesCommand(IProject project, IReporter reporter) {
            this.project = project;
            this.reporter = reporter;
        }

        public void execute() {
            this.result = InternalJpaProjectManager.this.buildValidationMessages_(this.project, this.reporter);
        }
    }

    class ClientJobCommandWrapper
    implements JobCommand {
        private final JobCommand jobCommand;
        private final JpaProject jpaProject;

        ClientJobCommandWrapper(JobCommand jobCommand, JpaProject jpaProject) {
            if (jobCommand == null || jpaProject == null) {
                throw new NullPointerException();
            }
            this.jobCommand = jobCommand;
            this.jpaProject = jpaProject;
        }

        public IStatus execute(IProgressMonitor monitor) {
            InternalJpaProjectManager.this.execute_(this.jobCommand, monitor, this.jpaProject);
            return Status.OK_STATUS;
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.jobCommand);
        }
    }

    class FacetFileChangeEventHandlerCommand
    implements Command {
        private final IProject project;

        FacetFileChangeEventHandlerCommand(IProject project) {
            this.project = project;
        }

        public void execute() {
            InternalJpaProjectManager.this.checkForJpaFacetTransition_(this.project);
        }
    }

    class GetJpaProjectCommand
    implements Command {
        private final IProject project;
        JpaProject result;

        GetJpaProjectCommand(IProject project) {
            this.project = project;
        }

        public void execute() {
            this.result = InternalJpaProjectManager.this.getJpaProjectUnsafe(this.project);
        }
    }

    class GetJpaProjectsCommand
    implements Command {
        Iterable<JpaProject> result;

        GetJpaProjectsCommand() {
        }

        public void execute() {
            this.result = InternalJpaProjectManager.this.getJpaProjects_();
        }
    }

    class JavaChangeEventHandlerCommand
    implements JobCommand {
        private final ElementChangedEvent event;

        JavaChangeEventHandlerCommand(ElementChangedEvent event) {
            this.event = event;
        }

        public IStatus execute(IProgressMonitor monitor) {
            InternalJpaProjectManager.this.javaElementChanged_(this.event, monitor);
            return Status.OK_STATUS;
        }
    }

    class JavaElementChangeListener
    implements IElementChangedListener {
        JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (this.isActive()) {
                InternalJpaProjectManager.this.javaElementChanged(event);
            }
        }

        private boolean isActive() {
            return InternalJpaProjectManager.this.asyncEventListenersAreActive();
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)(this.isActive() ? "active" : "inactive"));
        }
    }

    class LocalExceptionHandler
    implements ExceptionHandler {
        LocalExceptionHandler() {
        }

        public void handleException(Throwable t) {
            InternalJpaProjectManager.this.log(t);
            if (InternalJpaProjectManager.this.test) {
                t.printStackTrace();
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    class ProjectChangeEventHandlerCommand
    implements JobCommand {
        private final IResourceDelta delta;

        ProjectChangeEventHandlerCommand(IResourceDelta delta) {
            this.delta = delta;
        }

        public IStatus execute(IProgressMonitor monitor) {
            InternalJpaProjectManager.this.projectChanged_(this.delta, monitor);
            return Status.OK_STATUS;
        }
    }

    class ProjectPostCleanBuildEventHandlerCommand
    implements JobCommand {
        private final IProject project;

        ProjectPostCleanBuildEventHandlerCommand(IProject project) {
            this.project = project;
        }

        public IStatus execute(IProgressMonitor monitor) {
            InternalJpaProjectManager.this.projectPostCleanBuild_(this.project, monitor);
            return Status.OK_STATUS;
        }
    }

    class RebuildJpaProjectCommand
    implements JobCommand {
        private final IProject project;
        JpaProject result;

        RebuildJpaProjectCommand(IProject project) {
            this.project = project;
        }

        public IStatus execute(IProgressMonitor monitor) {
            this.result = InternalJpaProjectManager.this.rebuildJpaProject_(this.project, monitor);
            return Status.OK_STATUS;
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 1: {
                    this.processPostChangeEvent(event);
                    break;
                }
                case 32: {
                    break;
                }
                case 8: {
                    break;
                }
                case 16: {
                    this.processPostBuildEvent(event);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
            }
        }

        private void processPostChangeEvent(IResourceChangeEvent event) {
            InternalJpaProjectManager.debug("Resource POST_CHANGE event: {0}", event.getResource());
            this.processPostChangeDelta(event.getDelta());
        }

        private void processPostChangeDelta(IResourceDelta delta) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    this.processPostChangeRootDelta(delta);
                    break;
                }
                case 4: {
                    this.processPostChangeProjectDelta(delta);
                    break;
                }
                case 2: {
                    this.processPostChangeFolderDelta((IFolder)resource, delta);
                    break;
                }
                case 1: {
                    this.processPostChangeFileDelta((IFile)resource, delta);
                    break;
                }
            }
        }

        private void processPostChangeRootDelta(IResourceDelta delta) {
            this.processPostChangeDeltaChildren(delta);
        }

        private void processPostChangeProjectDelta(IResourceDelta delta) {
            InternalJpaProjectManager.this.projectChanged(delta);
            this.processPostChangeDeltaChildren(delta);
        }

        private void processPostChangeFolderDelta(IFolder folder, IResourceDelta delta) {
            if (folder.getName().equals(".settings")) {
                this.processPostChangeDeltaChildren(delta);
            }
        }

        private void processPostChangeFileDelta(IFile file, IResourceDelta delta) {
            if (file.getName().equals(InternalJpaProjectManager.FACETED_PROJECT_FRAMEWORK_SETTINGS_FILE_NAME)) {
                this.checkForFacetFileChanges(file, delta);
            }
        }

        private void checkForFacetFileChanges(IFile file, IResourceDelta delta) {
            switch (delta.getKind()) {
                case 1: 
                case 2: 
                case 4: {
                    InternalJpaProjectManager.this.checkForJpaFacetTransition(file.getProject());
                    break;
                }
                case 8: {
                    break;
                }
                case 16: {
                    break;
                }
            }
        }

        private void processPostChangeDeltaChildren(IResourceDelta delta) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                this.processPostChangeDelta(child);
                ++n2;
            }
        }

        private void processPostBuildEvent(IResourceChangeEvent event) {
            InternalJpaProjectManager.debug("Resource POST_BUILD event: {0}", event.getDelta().getResource());
            if (event.getBuildKind() == 15) {
                this.processPostCleanBuildDelta(event.getDelta());
            }
        }

        private void processPostCleanBuildDelta(IResourceDelta delta) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    this.processPostCleanBuildDeltaChildren(delta);
                    break;
                }
                case 4: {
                    this.processProjectPostCleanBuild((IProject)resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
            }
        }

        private void processPostCleanBuildDeltaChildren(IResourceDelta delta) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                this.processPostCleanBuildDelta(child);
                ++n2;
            }
        }

        private void processProjectPostCleanBuild(IProject project) {
            InternalJpaProjectManager.debug("\tProject CLEAN event: {0}", project.getName());
            InternalJpaProjectManager.this.projectPostCleanBuild(project);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private final IProgressMonitor monitor;

        ResourceProxyVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceProxy resourceProxy) {
            switch (resourceProxy.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    this.processProject(resourceProxy);
                    return false;
                }
                case 2: {
                    return false;
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }

        private void processProject(IResourceProxy resourceProxy) {
            IProject project;
            if (resourceProxy.isAccessible() && JpaFacet.isInstalled(project = (IProject)resourceProxy.requestResource())) {
                InternalJpaProjectManager.this.addJpaProject(project);
            }
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

