/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.jpa.core.JpaProject;

public class JptResourceModelPropertyTester
extends PropertyTester {
    public static final String IS_LATEST_SUPPORTED_VERSION = "isLatestSupportedVersion";
    public static final String IS_NOT_LATEST_SUPPORTED_VERSION = "isNotLatestSupportedVersion";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof JptResourceModel) {
            return this.test((JptResourceModel)receiver, property, expectedValue);
        }
        return false;
    }

    private boolean test(JptResourceModel resourceModel, String property, Object expectedValue) {
        if (property.equals(IS_NOT_LATEST_SUPPORTED_VERSION)) {
            return !this.test(resourceModel, IS_LATEST_SUPPORTED_VERSION, expectedValue);
        }
        if (property.equals(IS_LATEST_SUPPORTED_VERSION)) {
            boolean expected = expectedValue == null ? true : (Boolean)expectedValue;
            boolean actual = this.isLatestSupportedVersion(resourceModel);
            return actual == expected;
        }
        return false;
    }

    private boolean isLatestSupportedVersion(JptResourceModel resourceModel) {
        JpaProject jpaProject = this.getJpaProject(resourceModel.getFile().getProject());
        if (jpaProject == null) {
            return true;
        }
        JptResourceType resourceType = resourceModel.getResourceType();
        if (resourceType == null) {
            return true;
        }
        String latestVersion = jpaProject.getJpaPlatform().getMostRecentSupportedResourceType(resourceType.getContentType()).getVersion();
        return Tools.valuesAreEqual((Object)resourceType.getVersion(), (Object)latestVersion);
    }

    private JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }
}

