/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.Association;
import org.eclipse.jpt.common.utility.internal.SimpleAssociation;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaConverter;
import org.eclipse.jpt.jpa.core.context.java.JavaEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.java.JavaLobConverter;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaTemporalConverter;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TableColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.NamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.NullJavaConverter;
import org.eclipse.jpt.jpa.core.resource.java.BasicAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ColumnAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaBasicMapping
extends AbstractJavaAttributeMapping<BasicAnnotation>
implements JavaBasicMapping {
    protected final JavaColumn column;
    protected FetchType specifiedFetch;
    protected FetchType defaultFetch = DEFAULT_FETCH_TYPE;
    protected Boolean specifiedOptional;
    protected boolean defaultOptional = true;
    protected JavaConverter converter;
    protected static final JavaConverter.Adapter[] CONVERTER_ADAPTER_ARRAY = new JavaConverter.Adapter[]{JavaEnumeratedConverter.Adapter.instance(), JavaTemporalConverter.BasicAdapter.instance(), JavaLobConverter.Adapter.instance()};
    protected static final Iterable<JavaConverter.Adapter> CONVERTER_ADAPTERS = new ArrayIterable((Object[])CONVERTER_ADAPTER_ARRAY);

    protected AbstractJavaBasicMapping(JavaPersistentAttribute parent) {
        super(parent);
        this.column = this.buildColumn();
        this.specifiedFetch = this.buildSpecifiedFetch();
        this.specifiedOptional = this.buildSpecifiedOptional();
        this.converter = this.buildConverter();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.column.synchronizeWithResourceModel();
        this.setSpecifiedFetch_(this.buildSpecifiedFetch());
        this.setSpecifiedOptional_(this.buildSpecifiedOptional());
        this.syncConverter();
    }

    @Override
    public void update() {
        super.update();
        this.column.update();
        this.setDefaultFetch(this.buildDefaultFetch());
        this.setDefaultOptional(this.buildDefaultOptional());
        this.converter.update();
    }

    @Override
    public JavaColumn getColumn() {
        return this.column;
    }

    protected JavaColumn buildColumn() {
        return this.getJpaFactory().buildJavaColumn(this, this);
    }

    @Override
    public FetchType getFetch() {
        return this.specifiedFetch != null ? this.specifiedFetch : this.defaultFetch;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType fetch) {
        if (this.valuesAreDifferent((Object)fetch, (Object)this.specifiedFetch)) {
            ((BasicAnnotation)this.getAnnotationForUpdate()).setFetch(FetchType.toJavaResourceModel(fetch));
            this.setSpecifiedFetch_(fetch);
        }
    }

    protected void setSpecifiedFetch_(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected FetchType buildSpecifiedFetch() {
        BasicAnnotation annotation = (BasicAnnotation)this.getMappingAnnotation();
        return annotation == null ? null : FetchType.fromJavaResourceModel(annotation.getFetch());
    }

    @Override
    public FetchType getDefaultFetch() {
        return this.defaultFetch;
    }

    protected void setDefaultFetch(FetchType fetch) {
        FetchType old = this.defaultFetch;
        this.defaultFetch = fetch;
        this.firePropertyChanged("defaultFetch", (Object)old, (Object)fetch);
    }

    protected FetchType buildDefaultFetch() {
        return DEFAULT_FETCH_TYPE;
    }

    @Override
    public boolean isOptional() {
        return this.specifiedOptional != null ? this.specifiedOptional.booleanValue() : this.isDefaultOptional();
    }

    @Override
    public Boolean getSpecifiedOptional() {
        return this.specifiedOptional;
    }

    @Override
    public void setSpecifiedOptional(Boolean optional) {
        if (this.valuesAreDifferent(optional, this.specifiedOptional)) {
            ((BasicAnnotation)this.getAnnotationForUpdate()).setOptional(optional);
            this.setSpecifiedOptional_(optional);
        }
    }

    protected void setSpecifiedOptional_(Boolean optional) {
        Boolean old = this.specifiedOptional;
        this.specifiedOptional = optional;
        this.firePropertyChanged("specifiedOptional", old, optional);
    }

    protected Boolean buildSpecifiedOptional() {
        BasicAnnotation annotation = (BasicAnnotation)this.getMappingAnnotation();
        return annotation == null ? null : annotation.getOptional();
    }

    @Override
    public boolean isDefaultOptional() {
        return this.defaultOptional;
    }

    protected void setDefaultOptional(boolean optional) {
        boolean old = this.defaultOptional;
        this.defaultOptional = optional;
        this.firePropertyChanged("defaultOptional", old, optional);
    }

    protected boolean buildDefaultOptional() {
        return true;
    }

    @Override
    public JavaConverter getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(Class<? extends Converter> converterType) {
        if (this.converter.getType() != converterType) {
            this.converter.dispose();
            JavaConverter.Adapter converterAdapter = this.getConverterAdapter(converterType);
            this.retainConverterAnnotation(converterAdapter);
            this.setConverter_(this.buildConverter(converterAdapter));
        }
    }

    protected JavaConverter buildConverter(JavaConverter.Adapter converterAdapter) {
        return converterAdapter != null ? converterAdapter.buildNewConverter(this, this.getJpaFactory()) : this.buildNullConverter();
    }

    protected void setConverter_(JavaConverter converter) {
        JavaConverter old = this.converter;
        this.converter = converter;
        this.firePropertyChanged("converter", old, converter);
    }

    protected void retainConverterAnnotation(JavaConverter.Adapter converterAdapter) {
        JavaResourceAttribute resourceAttribute = this.getResourceAttribute();
        for (JavaConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter == converterAdapter) continue;
            adapter.removeConverterAnnotation(resourceAttribute);
        }
    }

    protected JavaConverter buildConverter() {
        JpaFactory jpaFactory = this.getJpaFactory();
        for (JavaConverter.Adapter adapter : this.getConverterAdapters()) {
            JavaConverter javaConverter = adapter.buildConverter(this, jpaFactory);
            if (javaConverter == null) continue;
            return javaConverter;
        }
        return this.buildNullConverter();
    }

    protected void syncConverter() {
        Association<JavaConverter.Adapter, Annotation> assoc = this.getConverterAnnotation();
        if (assoc == null) {
            if (this.converter.getType() != null) {
                this.setConverter_(this.buildNullConverter());
            }
        } else {
            JavaConverter.Adapter adapter = (JavaConverter.Adapter)assoc.getKey();
            Annotation annotation = (Annotation)assoc.getValue();
            if (this.converter.getType() == adapter.getConverterType() && this.converter.getConverterAnnotation() == annotation) {
                this.converter.synchronizeWithResourceModel();
            } else {
                this.setConverter_(adapter.buildConverter(annotation, this, this.getJpaFactory()));
            }
        }
    }

    protected Association<JavaConverter.Adapter, Annotation> getConverterAnnotation() {
        JavaResourceAttribute resourceAttribute = this.getResourceAttribute();
        for (JavaConverter.Adapter adapter : this.getConverterAdapters()) {
            Annotation annotation = adapter.getConverterAnnotation(resourceAttribute);
            if (annotation == null) continue;
            return new SimpleAssociation((Object)adapter, (Object)annotation);
        }
        return null;
    }

    protected JavaConverter buildNullConverter() {
        return new NullJavaConverter(this);
    }

    protected JavaConverter.Adapter getConverterAdapter(Class<? extends Converter> converterType) {
        for (JavaConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter.getConverterType() != converterType) continue;
            return adapter;
        }
        return null;
    }

    protected Iterable<JavaConverter.Adapter> getConverterAdapters() {
        return CONVERTER_ADAPTERS;
    }

    @Override
    public String getKey() {
        return "basic";
    }

    @Override
    protected String getAnnotationName() {
        return "javax.persistence.Basic";
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public ColumnAnnotation getColumnAnnotation() {
        return (ColumnAnnotation)this.getResourceAttribute().getNonNullAnnotation("javax.persistence.Column");
    }

    @Override
    public void removeColumnAnnotation() {
        this.getResourceAttribute().removeAnnotation("javax.persistence.Column");
    }

    @Override
    public String getDefaultColumnName(ReadOnlyNamedColumn column) {
        return this.getName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.getTypeMapping().tableNameIsInvalid(tableName);
    }

    @Override
    public Iterable<String> getCandidateTableNames() {
        return this.getTypeMapping().getAllAssociatedTableNames();
    }

    @Override
    public JptValidator buildColumnValidator(ReadOnlyNamedColumn col, NamedColumnTextRangeResolver textRangeResolver) {
        return new NamedColumnValidator((ReadOnlyPersistentAttribute)this.getPersistentAttribute(), (ReadOnlyBaseColumn)col, (TableColumnTextRangeResolver)textRangeResolver, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.column.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.converter.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.column.validate(messages, reporter, astRoot);
        this.converter.validate(messages, reporter, astRoot);
    }
}

