/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.io.Serializable;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaEmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaBaseEmbeddedMapping;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.EmbeddedIdMapping2_0;
import org.eclipse.jpt.jpa.core.resource.java.EmbeddedIdAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaEmbeddedIdMapping
extends AbstractJavaBaseEmbeddedMapping<EmbeddedIdAnnotation>
implements EmbeddedIdMapping2_0,
JavaEmbeddedIdMapping {
    protected boolean derived;

    protected AbstractJavaEmbeddedIdMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void update() {
        super.update();
        this.setDerived(this.buildDerived());
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    protected void setDerived(boolean derived) {
        boolean old = this.derived;
        this.derived = derived;
        this.firePropertyChanged("derived", old, derived);
    }

    protected boolean buildDerived() {
        return this.isJpa2_0Compatible() && this.buildDerived_();
    }

    protected boolean buildDerived_() {
        return this.getTypeMapping().attributeIsDerivedId(this.getName());
    }

    @Override
    public String getKey() {
        return "embeddedId";
    }

    @Override
    protected String getAnnotationName() {
        return "javax.persistence.EmbeddedId";
    }

    @Override
    protected Iterable<String> getEmbeddableOverridableAttributeMappingNames() {
        return this.derived ? EmptyIterable.instance() : super.getEmbeddableOverridableAttributeMappingNames();
    }

    @Override
    protected JavaAttributeOverrideContainer.Owner buildAttributeOverrideContainerOwner() {
        return new AttributeOverrideContainerOwner();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.derived && this.attributeOverrideContainer.getSpecifiedOverridesSize() > 0) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_EMBEDDED_ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_ATTRIBUTE_OVERRIDES_SPECIFIED", new String[]{this.getName()}, this.attributeOverrideContainer, this.attributeOverrideContainer.getValidationTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "EMBEDDED_ID_MAPPING_MAPPED_BY_RELATIONSHIP_AND_ATTRIBUTE_OVERRIDES_SPECIFIED", EMPTY_STRING_ARRAY, this.attributeOverrideContainer, this.attributeOverrideContainer.getValidationTextRange(astRoot)));
            }
        }
        this.validateTargetEmbeddableImplementsSerializable(messages, reporter, astRoot);
        this.validateNoRelationshipMappingsOnTargetEmbeddable(messages, reporter, astRoot);
        this.validateTargetEmbeddableImplementsEqualsAndHashcode(messages, reporter, astRoot);
        this.validateTargetEmbeddableIsPublic(messages, reporter, astRoot);
        this.validateTargetEmbeddableImplementsZeroArgConstructor(messages, reporter, astRoot);
    }

    protected void validateTargetEmbeddableImplementsZeroArgConstructor(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.getTargetEmbeddable() != null) {
            String targetEmbeddableClassName = this.getTargetEmbeddable().getPersistentType().getName();
            IJavaProject javaProject = this.getJpaProject().getJavaProject();
            if (!JDTTools.classHasPublicZeroArgConstructor((IJavaProject)javaProject, (String)targetEmbeddableClassName)) {
                if (this.getPersistentAttribute().isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_NO_ARG_CONSTRUCTOR", new String[]{this.getName()}, this, this.getValidationTextRange(astRoot)));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_NO_ARG_CONSTRUCTOR", EMPTY_STRING_ARRAY, this, this.getValidationTextRange(astRoot)));
                }
            }
        }
    }

    protected void validateTargetEmbeddableImplementsEqualsAndHashcode(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        JavaResourceType resourceType;
        if (!(this.getTargetEmbeddable() == null || (resourceType = this.getTargetEmbeddable().getJavaResourceType()) == null || resourceType.hasHashCodeMethod() && resourceType.hasEqualsMethod())) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_EQUALS_HASHCODE", new String[]{this.getName()}, this, this.getValidationTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_EQUALS_HASHCODE", EMPTY_STRING_ARRAY, this, this.getValidationTextRange(astRoot)));
            }
        }
    }

    protected void validateTargetEmbeddableIsPublic(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.getTargetEmbeddable() != null && !this.getTargetEmbeddable().getJavaResourceType().isPublic()) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_BE_PUBLIC", new String[]{this.getName()}, this, this.getValidationTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "EMBEDDED_ID_CLASS_SHOULD_BE_PUBLIC", EMPTY_STRING_ARRAY, this, this.getValidationTextRange(astRoot)));
            }
        }
    }

    protected void validateTargetEmbeddableImplementsSerializable(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.getTargetEmbeddable() != null) {
            String targetEmbeddableClassName = this.getTargetEmbeddable().getPersistentType().getName();
            IJavaProject javaProject = this.getJpaProject().getJavaProject();
            if (!JDTTools.typeIsSubType((IJavaProject)javaProject, (String)targetEmbeddableClassName, (String)Serializable.class.getName())) {
                if (this.getPersistentAttribute().isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_SERIALIZABLE", new String[]{this.getName()}, this, this.getValidationTextRange(astRoot)));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "EMBEDDED_ID_CLASS_SHOULD_IMPLEMENT_SERIALIZABLE", EMPTY_STRING_ARRAY, this, this.getValidationTextRange(astRoot)));
                }
            }
        }
    }

    protected void validateNoRelationshipMappingsOnTargetEmbeddable(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        TypeMapping targetEmbeddableTypeMapping;
        if (this.getTargetEmbeddable() != null && ((targetEmbeddableTypeMapping = this.getTargetEmbeddable().getPersistentType().getMapping()).getAllAttributeMappings("manyToMany").iterator().hasNext() || targetEmbeddableTypeMapping.getAllAttributeMappings("manyToOne").iterator().hasNext() || targetEmbeddableTypeMapping.getAllAttributeMappings("oneToMany").iterator().hasNext() || targetEmbeddableTypeMapping.getAllAttributeMappings("oneToOne").iterator().hasNext())) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_EMBEDDED_ID_CLASS_SHOULD_NOT_CONTAIN_RELATIONSHIP_MAPPINGS", new String[]{this.getName()}, this, this.getValidationTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "EMBEDDED_ID_CLASS_SHOULD_NOT_CONTAIN_RELATIONSHIP_MAPPINGS", EMPTY_STRING_ARRAY, this, this.getValidationTextRange(astRoot)));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeOverrideContainerOwner
    extends AbstractJavaBaseEmbeddedMapping.AttributeOverrideContainerOwner {
        protected AttributeOverrideContainerOwner() {
        }

        @Override
        public Iterable<String> getAllOverridableNames() {
            return AbstractJavaEmbeddedIdMapping.this.isDerived() ? EmptyIterable.instance() : super.getAllOverridableNames();
        }

        @Override
        protected Iterable<String> getAllOverridableAttributeNames_(TypeMapping overriddenTypeMapping) {
            return new FilteringIterable<String>(super.getAllOverridableAttributeNames_(overriddenTypeMapping)){

                protected boolean accept(String attributeName) {
                    return !AttributeOverrideContainerOwner.this.getTypeMapping().attributeIsDerivedId(attributeName);
                }
            };
        }
    }
}

