/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.java.GeneratorAnnotation;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaGenerator<A extends GeneratorAnnotation>
extends AbstractJavaJpaContextNode
implements JavaGenerator {
    protected final A generatorAnnotation;
    protected String name;
    protected Integer specifiedInitialValue;
    protected int defaultInitialValue;
    protected Integer specifiedAllocationSize;
    protected int defaultAllocationSize;

    protected AbstractJavaGenerator(JavaGeneratorContainer parent, A generatorAnnotation) {
        super(parent);
        this.generatorAnnotation = generatorAnnotation;
        this.name = generatorAnnotation.getName();
        this.specifiedInitialValue = generatorAnnotation.getInitialValue();
        this.specifiedAllocationSize = generatorAnnotation.getAllocationSize();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.generatorAnnotation.getName());
        this.setSpecifiedInitialValue_(this.generatorAnnotation.getInitialValue());
        this.setSpecifiedAllocationSize_(this.generatorAnnotation.getAllocationSize());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultInitialValue(this.buildDefaultInitialValue());
        this.setDefaultAllocationSize(this.buildDefaultAllocationSize());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.generatorAnnotation.setName(name);
        this.setName_(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public int getInitialValue() {
        return this.specifiedInitialValue != null ? this.specifiedInitialValue : this.defaultInitialValue;
    }

    @Override
    public Integer getSpecifiedInitialValue() {
        return this.specifiedInitialValue;
    }

    @Override
    public void setSpecifiedInitialValue(Integer value) {
        this.generatorAnnotation.setInitialValue(value);
        this.setSpecifiedInitialValue_(value);
    }

    protected void setSpecifiedInitialValue_(Integer value) {
        Integer old = this.specifiedInitialValue;
        this.specifiedInitialValue = value;
        this.firePropertyChanged("specifiedInitialValue", old, value);
    }

    @Override
    public int getDefaultInitialValue() {
        return this.defaultInitialValue;
    }

    protected void setDefaultInitialValue(int value) {
        int old = this.defaultInitialValue;
        this.defaultInitialValue = value;
        this.firePropertyChanged("defaultInitialValue", old, value);
    }

    protected abstract int buildDefaultInitialValue();

    @Override
    public int getAllocationSize() {
        return this.specifiedAllocationSize != null ? this.specifiedAllocationSize : this.defaultAllocationSize;
    }

    @Override
    public Integer getSpecifiedAllocationSize() {
        return this.specifiedAllocationSize;
    }

    @Override
    public void setSpecifiedAllocationSize(Integer size) {
        this.generatorAnnotation.setAllocationSize(size);
        this.setSpecifiedAllocationSize_(size);
    }

    protected void setSpecifiedAllocationSize_(Integer size) {
        Integer old = this.specifiedAllocationSize;
        this.specifiedAllocationSize = size;
        this.firePropertyChanged("specifiedAllocationSize", old, size);
    }

    @Override
    public int getDefaultAllocationSize() {
        return this.defaultAllocationSize;
    }

    protected void setDefaultAllocationSize(int size) {
        int old = this.defaultAllocationSize;
        this.defaultAllocationSize = size;
        this.firePropertyChanged("defaultAllocationSize", old, size);
    }

    protected int buildDefaultAllocationSize() {
        return 50;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (StringTools.stringIsEmpty((String)this.name)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_NAME_UNDEFINED", EMPTY_STRING_ARRAY, this, this.getNameTextRange(astRoot)));
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.generatorAnnotation.getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.generatorAnnotation.getNameTextRange(), astRoot);
    }

    @Override
    public boolean isEquivalentTo(JpaNamedContextNode node) {
        return this != node && this.getType() == node.getType() && this.isEquivalentTo((Generator)node);
    }

    protected boolean isEquivalentTo(Generator generator) {
        return Tools.valuesAreEqual((Object)this.name, (Object)generator.getName()) && Tools.valuesAreEqual((Object)this.specifiedAllocationSize, (Object)generator.getSpecifiedAllocationSize()) && Tools.valuesAreEqual((Object)this.specifiedInitialValue, (Object)generator.getSpecifiedInitialValue());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    protected abstract String getSchema();

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    protected abstract String getCatalog();

    @Override
    public JavaGeneratorContainer getParent() {
        return (JavaGeneratorContainer)super.getParent();
    }

    public A getGeneratorAnnotation() {
        return this.generatorAnnotation;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

