/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.ClassName;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.ChainIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.Access2_0Annotation;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaPersistentType
extends AbstractJavaJpaContextNode
implements JavaPersistentType {
    protected final JavaResourceType resourceType;
    protected String name;
    protected PersistentType superPersistentType;
    protected AccessType specifiedAccess;
    protected AccessType defaultAccess;
    protected JavaTypeMapping mapping;
    protected final Vector<JavaPersistentAttribute> attributes = new Vector();
    public static Filter<JavaResourceField> ANNOTATED_RESOURCE_FIELDS_FILTER = new Filter<JavaResourceField>(){

        public boolean accept(JavaResourceField resourceField) {
            return resourceField.isAnnotated();
        }
    };

    protected AbstractJavaPersistentType(PersistentType.Owner parent, JavaResourceType resourceType) {
        super(parent);
        this.resourceType = resourceType;
        this.name = this.resourceType.getQualifiedName();
        this.specifiedAccess = this.buildSpecifiedAccess();
        this.defaultAccess = AccessType.FIELD;
        this.mapping = this.buildMapping();
        this.initializeAttributes();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName(this.resourceType.getQualifiedName());
        this.setSpecifiedAccess_(this.buildSpecifiedAccess());
        this.syncMapping();
        this.synchronizeNodesWithResourceModel((Iterable<? extends JpaContextNode>)this.getAttributes());
    }

    @Override
    public void update() {
        super.update();
        this.setSuperPersistentType(this.buildSuperPersistentType());
        this.setDefaultAccess(this.buildDefaultAccess());
        this.mapping.update();
        this.updateAttributes();
        this.registerRootStructureNode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimpleName() {
        return ClassName.getSimpleName((String)this.name);
    }

    protected void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public PersistentType getSuperPersistentType() {
        return this.superPersistentType;
    }

    protected void setSuperPersistentType(PersistentType superPersistentType) {
        PersistentType old = this.superPersistentType;
        this.superPersistentType = superPersistentType;
        this.firePropertyChanged("superPersistentType", old, superPersistentType);
    }

    protected PersistentType buildSuperPersistentType() {
        HashSet<JavaResourceType> visited = new HashSet<JavaResourceType>();
        visited.add(this.resourceType);
        PersistentType spt = this.resolveSuperPersistentType(this.resourceType.getSuperclassQualifiedName(), visited);
        if (spt == null) {
            return null;
        }
        if (CollectionTools.contains(spt.getInheritanceHierarchy(), (Object)this)) {
            return null;
        }
        return spt.isMapped() ? spt : spt.getSuperPersistentType();
    }

    protected PersistentType resolveSuperPersistentType(String typeName, Collection<JavaResourceType> visited) {
        if (typeName == null) {
            return null;
        }
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType(typeName, JavaResourceAnnotatedElement.Kind.TYPE);
        if (resourceType == null || visited.contains(resourceType)) {
            return null;
        }
        visited.add(resourceType);
        PersistentType spt = this.resolvePersistentType(typeName);
        return spt != null ? spt : this.resolveSuperPersistentType(resourceType.getSuperclassQualifiedName(), visited);
    }

    protected PersistentType resolvePersistentType(String typeName) {
        return this.getPersistenceUnit().getPersistentType(typeName);
    }

    protected Access2_0Annotation getAccessAnnotation() {
        return (Access2_0Annotation)this.resourceType.getNonNullAnnotation(this.getAccessAnnotationName());
    }

    protected void removeAccessAnnotationIfUnset() {
        Access2_0Annotation accessAnnotation = this.getAccessAnnotation();
        if (accessAnnotation != null && accessAnnotation.isUnset()) {
            this.removeAccessAnnotation();
        }
    }

    protected void removeAccessAnnotation() {
        this.resourceType.removeAnnotation(this.getAccessAnnotationName());
    }

    protected String getAccessAnnotationName() {
        return "javax.persistence.Access";
    }

    @Override
    public AccessType getAccess() {
        return this.specifiedAccess != null ? this.specifiedAccess : this.defaultAccess;
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType access) {
        if (this.valuesAreDifferent(this.specifiedAccess, access)) {
            this.getAccessAnnotation().setValue(AccessType.toJavaResourceModel(access));
            this.removeAccessAnnotationIfUnset();
            this.setSpecifiedAccess_(access);
        }
    }

    protected void setSpecifiedAccess_(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.firePropertyChanged("specifiedAccess", old, access);
    }

    protected AccessType buildSpecifiedAccess() {
        return AccessType.fromJavaResourceModel(this.getAccessAnnotation().getValue(), this.getJpaPlatform(), this.getResourceType());
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", old, access);
    }

    protected AccessType buildDefaultAccess() {
        AccessType accessType = AbstractJavaPersistentType.buildAccess(this.resourceType);
        if (accessType != null) {
            return accessType;
        }
        accessType = this.getOwnerOverrideAccess();
        if (accessType != null) {
            return accessType;
        }
        if (this.superPersistentType != null && (accessType = this.superPersistentType.getAccess()) != null) {
            return accessType;
        }
        accessType = this.getOwnerDefaultAccess();
        if (accessType != null) {
            return accessType;
        }
        return AccessType.FIELD;
    }

    @Override
    public JavaTypeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public void setMappingKey(String key) {
        if (this.valuesAreDifferent(key, this.getMappingKey())) {
            this.setMapping(this.buildMapping(key));
        }
    }

    protected JavaTypeMapping buildMapping(String key) {
        for (JavaTypeMappingDefinition definition : this.getMappingDefinitions()) {
            if (!Tools.valuesAreEqual((Object)definition.getKey(), (Object)key)) continue;
            Annotation annotation = this.resourceType.setPrimaryAnnotation(definition.getAnnotationName(), definition.getSupportingAnnotationNames());
            return definition.buildMapping(this, annotation, this.getJpaFactory());
        }
        this.resourceType.setPrimaryAnnotation(null, EmptyIterable.instance());
        return this.buildNullMapping();
    }

    protected void setMapping(JavaTypeMapping mapping) {
        JavaTypeMapping old = this.mapping;
        this.mapping = mapping;
        this.firePropertyChanged("mapping", old, mapping);
    }

    protected JavaTypeMapping buildMapping() {
        for (JavaTypeMappingDefinition definition : this.getMappingDefinitions()) {
            Annotation annotation = this.resourceType.getAnnotation(definition.getAnnotationName());
            if (annotation == null) continue;
            return definition.buildMapping(this, annotation, this.getJpaFactory());
        }
        return this.buildNullMapping();
    }

    protected void syncMapping() {
        JavaTypeMappingDefinition definition = null;
        Annotation annotation = null;
        Iterator<JavaTypeMappingDefinition> stream = this.mappingDefinitions();
        while (stream.hasNext()) {
            definition = stream.next();
            annotation = this.resourceType.getAnnotation(definition.getAnnotationName());
            if (annotation != null) break;
        }
        if (this.mapping.getMappingAnnotation() == annotation) {
            this.mapping.synchronizeWithResourceModel();
        } else {
            this.setMapping(this.buildMapping(annotation, definition));
        }
    }

    protected JavaTypeMapping buildMapping(Annotation annotation, JavaTypeMappingDefinition definition) {
        return annotation != null ? definition.buildMapping(this, annotation, this.getJpaFactory()) : this.buildNullMapping();
    }

    protected Iterator<JavaTypeMappingDefinition> mappingDefinitions() {
        return this.getMappingDefinitions().iterator();
    }

    protected Iterable<JavaTypeMappingDefinition> getMappingDefinitions() {
        return this.getJpaPlatform().getJavaTypeMappingDefinitions();
    }

    protected JavaTypeMapping buildNullMapping() {
        return this.getJpaFactory().buildJavaNullTypeMapping(this);
    }

    @Override
    public boolean isMapped() {
        return this.mapping.isMapped();
    }

    @Override
    public ListIterable<JavaPersistentAttribute> getAttributes() {
        return new LiveCloneListIterable(this.attributes);
    }

    @Override
    public int getAttributesSize() {
        return this.attributes.size();
    }

    @Override
    public Iterable<String> getAttributeNames() {
        return this.convertToNames((Iterable<? extends ReadOnlyPersistentAttribute>)this.getAttributes());
    }

    @Override
    public JavaPersistentAttribute getAttributeNamed(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.getAttributesNamed(attributeName).iterator();
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public JavaPersistentAttribute getAttributeFor(JavaResourceAttribute javaResourceAttribute) {
        for (JavaPersistentAttribute javaAttribute : this.getAttributes()) {
            if (javaAttribute.getResourceAttribute() != javaResourceAttribute) continue;
            return javaAttribute;
        }
        return null;
    }

    @Override
    public Iterable<ReadOnlyPersistentAttribute> getAllAttributes() {
        return new CompositeIterable((Iterable)new TransformationIterable<PersistentType, Iterable<ReadOnlyPersistentAttribute>>(this.getInheritanceHierarchy()){

            protected Iterable<ReadOnlyPersistentAttribute> transform(PersistentType pt) {
                return new SuperListIterableWrapper(pt.getAttributes());
            }
        });
    }

    @Override
    public Iterable<String> getAllAttributeNames() {
        return this.convertToNames(this.getAllAttributes());
    }

    protected Iterable<JavaPersistentAttribute> getAttributesNamed(final String attributeName) {
        return new FilteringIterable<JavaPersistentAttribute>(this.getAttributes()){

            protected boolean accept(JavaPersistentAttribute attribute) {
                return Tools.valuesAreEqual((Object)attributeName, (Object)attribute.getName());
            }
        };
    }

    @Override
    public ReadOnlyPersistentAttribute resolveAttribute(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.getAttributesNamed(attributeName).iterator();
        if (stream.hasNext()) {
            JavaPersistentAttribute attribute = stream.next();
            return stream.hasNext() ? null : attribute;
        }
        return this.superPersistentType == null ? null : this.superPersistentType.resolveAttribute(attributeName);
    }

    protected Iterable<String> convertToNames(Iterable<? extends ReadOnlyPersistentAttribute> attrs) {
        return new TransformationIterable<ReadOnlyPersistentAttribute, String>(attrs){

            protected String transform(ReadOnlyPersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    protected JavaPersistentAttribute buildField(JavaResourceField resourceField) {
        return this.getJpaFactory().buildJavaPersistentField(this, resourceField);
    }

    protected JavaPersistentAttribute buildProperty(JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        return this.getJpaFactory().buildJavaPersistentProperty(this, resourceGetter, resourceSetter);
    }

    @Override
    public boolean hasAnyAnnotatedAttributes() {
        return this.resourceType.hasAnyAnnotatedFields() || this.resourceType.hasAnyAnnotatedMethods();
    }

    protected void moveAttribute(int index, JavaPersistentAttribute attribute) {
        this.moveItemInList(index, attribute, this.attributes, "attributes");
    }

    protected void addAttribute(int index, JavaPersistentAttribute persistentAttribute) {
        this.addItemToList(index, persistentAttribute, this.attributes, "attributes");
    }

    protected void removeAttribute(JavaPersistentAttribute attribute) {
        this.removeItemFromList(attribute, this.attributes, "attributes");
    }

    protected void initializeAttributes() {
        if (this.getAccess() == AccessType.FIELD) {
            this.intializeFieldAccessAttributes();
        } else if (this.getAccess() == AccessType.PROPERTY) {
            this.intializePropertyAccessAttributes();
        }
    }

    private void intializeFieldAccessAttributes() {
        this.initializeFieldAttributes(AbstractJavaPersistentType.buildNonTransientNonStaticResourceFieldsFilter());
        this.initializeAnnotatedPropertyAttributes();
    }

    private void initializeFieldAttributes(Filter<JavaResourceField> filter) {
        for (JavaResourceField resourceField : this.getResourceFields(filter)) {
            this.attributes.add(this.buildField(resourceField));
        }
    }

    private void intializePropertyAccessAttributes() {
        this.initializeFieldAttributes(ANNOTATED_RESOURCE_FIELDS_FILTER);
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourceMethods(this.buildPersistablePropertyGetterMethodsFilter())) {
            JavaResourceMethod setterMethod;
            if (AbstractJavaPersistentType.methodsArePersistableProperties(getterMethod, setterMethod = AbstractJavaPersistentType.getValidSiblingSetMethod(getterMethod, (Iterable<JavaResourceMethod>)resourceMethods))) {
                this.attributes.add(this.buildProperty(getterMethod, setterMethod));
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.initializeRemainingResourceMethodAttributes((Collection<JavaResourceMethod>)resourceMethods);
    }

    private void initializeAnnotatedPropertyAttributes() {
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourceMethods(this.buildPersistablePropertyGetterMethodsFilter())) {
            JavaResourceMethod setterMethod = AbstractJavaPersistentType.getValidSiblingSetMethod(getterMethod, (Iterable<JavaResourceMethod>)resourceMethods);
            if (getterMethod.isAnnotated() || setterMethod != null && setterMethod.isAnnotated()) {
                this.attributes.add(this.buildProperty(getterMethod, setterMethod));
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.initializeRemainingResourceMethodAttributes((Collection<JavaResourceMethod>)resourceMethods);
    }

    private void initializeRemainingResourceMethodAttributes(Collection<JavaResourceMethod> resourceMethods) {
        for (JavaResourceMethod resourceMethod : resourceMethods) {
            if (!resourceMethod.isAnnotated()) continue;
            this.attributes.add(this.buildProperty(null, resourceMethod));
        }
    }

    protected void updateAttributes() {
        if (this.getAccess() == AccessType.FIELD) {
            this.syncFieldAccessAttributes();
        } else if (this.getAccess() == AccessType.PROPERTY) {
            this.syncPropertyAccessAttributes();
        }
    }

    private void syncFieldAccessAttributes() {
        HashSet contextAttributes = CollectionTools.set(this.getAttributes());
        this.syncFieldAttributes(contextAttributes, AbstractJavaPersistentType.buildNonTransientNonStaticResourceFieldsFilter());
        this.syncAnnotatedPropertyAttributes(contextAttributes);
    }

    private void syncPropertyAccessAttributes() {
        HashSet contextAttributes = CollectionTools.set(this.getAttributes());
        this.syncFieldAttributes(contextAttributes, ANNOTATED_RESOURCE_FIELDS_FILTER);
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourceMethods(this.buildPersistablePropertyGetterMethodsFilter())) {
            JavaResourceMethod setterMethod;
            if (AbstractJavaPersistentType.methodsArePersistableProperties(getterMethod, setterMethod = AbstractJavaPersistentType.getValidSiblingSetMethod(getterMethod, (Iterable<JavaResourceMethod>)resourceMethods))) {
                boolean match = false;
                Iterator stream = contextAttributes.iterator();
                while (stream.hasNext()) {
                    JavaPersistentAttribute contextAttribute = (JavaPersistentAttribute)stream.next();
                    if (!contextAttribute.isFor(getterMethod, setterMethod)) continue;
                    match = true;
                    contextAttribute.update();
                    stream.remove();
                    break;
                }
                if (!match) {
                    this.addAttribute(this.getAttributesSize(), this.buildProperty(getterMethod, setterMethod));
                }
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.syncRemainingResourceMethods(contextAttributes, (Collection<JavaResourceMethod>)resourceMethods);
    }

    private void syncAnnotatedPropertyAttributes(HashSet<JavaPersistentAttribute> contextAttributes) {
        HashBag resourceMethods = CollectionTools.collection(this.getResourceMethods());
        for (JavaResourceMethod getterMethod : this.getResourceMethods(this.buildPersistablePropertyGetterMethodsFilter())) {
            JavaResourceMethod setterMethod = AbstractJavaPersistentType.getValidSiblingSetMethod(getterMethod, (Iterable<JavaResourceMethod>)resourceMethods);
            if (getterMethod.isAnnotated() || setterMethod != null && setterMethod.isAnnotated()) {
                boolean match = false;
                Iterator<JavaPersistentAttribute> stream = contextAttributes.iterator();
                while (stream.hasNext()) {
                    JavaPersistentAttribute contextAttribute = stream.next();
                    if (!contextAttribute.isFor(getterMethod, setterMethod)) continue;
                    match = true;
                    contextAttribute.update();
                    stream.remove();
                    break;
                }
                if (!match) {
                    this.addAttribute(this.getAttributesSize(), this.buildProperty(getterMethod, setterMethod));
                }
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.syncRemainingResourceMethods(contextAttributes, (Collection<JavaResourceMethod>)resourceMethods);
    }

    private void syncFieldAttributes(HashSet<JavaPersistentAttribute> contextAttributes, Filter<JavaResourceField> filter) {
        for (JavaResourceField resourceField : this.getResourceFields(filter)) {
            boolean match = false;
            Iterator<JavaPersistentAttribute> stream = contextAttributes.iterator();
            while (stream.hasNext()) {
                JavaPersistentAttribute contextAttribute = stream.next();
                if (!contextAttribute.isFor(resourceField)) continue;
                match = true;
                contextAttribute.update();
                stream.remove();
                break;
            }
            if (match) continue;
            this.addAttribute(this.getAttributesSize(), this.buildField(resourceField));
        }
    }

    private void syncRemainingResourceMethods(HashSet<JavaPersistentAttribute> contextAttributes, Collection<JavaResourceMethod> resourceMethods) {
        for (JavaResourceMethod resourceMethod : resourceMethods) {
            if (!resourceMethod.isAnnotated()) continue;
            boolean match = false;
            Iterator<JavaPersistentAttribute> stream = contextAttributes.iterator();
            while (stream.hasNext()) {
                JavaPersistentAttribute contextAttribute = stream.next();
                if (!contextAttribute.isFor(null, resourceMethod)) continue;
                match = true;
                contextAttribute.update();
                stream.remove();
                break;
            }
            if (match) continue;
            this.addAttribute(this.getAttributesSize(), this.buildProperty(null, resourceMethod));
        }
        for (JavaPersistentAttribute contextAttribute : contextAttributes) {
            this.removeAttribute(contextAttribute);
        }
    }

    protected Iterable<JavaResourceField> getResourceFields() {
        return this.resourceType.getFields();
    }

    protected Iterable<JavaResourceMethod> getResourceMethods() {
        return this.resourceType.getMethods();
    }

    protected Iterable<JavaResourceField> getResourceFields(Filter<JavaResourceField> filter) {
        return new FilteringIterable(this.getResourceFields(), filter);
    }

    protected Iterable<JavaResourceMethod> getResourceMethods(Filter<JavaResourceMethod> filter) {
        return new FilteringIterable(this.getResourceMethods(), filter);
    }

    public static Filter<JavaResourceField> buildNonTransientNonStaticResourceFieldsFilter() {
        return new Filter<JavaResourceField>(){

            public boolean accept(JavaResourceField resourceField) {
                return AbstractJavaPersistentType.memberIsNonTransientNonStatic((JavaResourceMember)resourceField) || resourceField.isAnnotated();
            }
        };
    }

    protected static boolean memberIsNonTransientNonStatic(JavaResourceMember resourceMember) {
        return !resourceMember.isTransient() && !resourceMember.isStatic();
    }

    protected Filter<JavaResourceMethod> buildPersistablePropertyGetterMethodsFilter() {
        return new Filter<JavaResourceMethod>(){

            public boolean accept(JavaResourceMethod resourceMethod) {
                return AbstractJavaPersistentType.methodIsPersistablePropertyGetter(resourceMethod, AbstractJavaPersistentType.this.getResourceMethods());
            }
        };
    }

    public static boolean methodIsPersistablePropertyGetter(JavaResourceMethod resourceMethod, Iterable<JavaResourceMethod> allMethods) {
        if (AbstractJavaPersistentType.methodHasInvalidModifiers(resourceMethod)) {
            return false;
        }
        if (resourceMethod.isConstructor()) {
            return false;
        }
        String returnTypeName = resourceMethod.getTypeName();
        if (returnTypeName == null) {
            return false;
        }
        if (returnTypeName.equals("void")) {
            return false;
        }
        if (AbstractJavaPersistentType.methodHasParameters(resourceMethod)) {
            return false;
        }
        boolean booleanGetter = AbstractJavaPersistentType.methodIsBooleanGetter(resourceMethod);
        return !booleanGetter || !AbstractJavaPersistentType.methodHasValidSiblingIsMethod(resourceMethod, allMethods);
    }

    private static boolean methodIsBooleanGetter(JavaResourceMethod resourceMethod) {
        String returnTypeName = resourceMethod.getTypeName();
        String name = resourceMethod.getMethodName();
        boolean booleanGetter = false;
        if (name.startsWith("is")) {
            if (!returnTypeName.equals("boolean")) {
                return false;
            }
        } else if (name.startsWith("get")) {
            if (returnTypeName.equals("boolean")) {
                booleanGetter = true;
            }
        } else {
            return false;
        }
        return booleanGetter;
    }

    private static boolean methodHasInvalidModifiers(JavaResourceMethod resourceMethod) {
        int modifiers = resourceMethod.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    private static boolean methodHasParameters(JavaResourceMethod resourceMethod) {
        return resourceMethod.getParametersSize() != 0;
    }

    private static boolean methodHasValidSiblingIsMethod(JavaResourceMethod getMethod, Iterable<JavaResourceMethod> resourceMethods) {
        String capitalizedAttributeName = StringTools.capitalize((String)getMethod.getName());
        for (JavaResourceMethod sibling : resourceMethods) {
            if (sibling.getParametersSize() != 0 || !sibling.getMethodName().equals("is" + capitalizedAttributeName)) continue;
            return AbstractJavaPersistentType.methodIsValidSibling(sibling, "boolean");
        }
        return false;
    }

    public static JavaResourceMethod getValidSiblingSetMethod(JavaResourceMethod getMethod, Iterable<JavaResourceMethod> resourceMethods) {
        String capitalizedSetAttributeName = "set" + StringTools.capitalize((String)getMethod.getName());
        String parameterTypeErasureName = getMethod.getTypeName();
        for (JavaResourceMethod sibling : resourceMethods) {
            if (sibling.getParametersSize() != 1 || !sibling.getMethodName().equals(capitalizedSetAttributeName) || !sibling.getParameterTypeName(0).equals(parameterTypeErasureName)) continue;
            return AbstractJavaPersistentType.methodIsValidSibling(sibling, "void") ? sibling : null;
        }
        return null;
    }

    private static boolean methodIsValidSibling(JavaResourceMethod resourceMethod, String returnTypeName) {
        if (resourceMethod == null) {
            return false;
        }
        if (AbstractJavaPersistentType.methodHasInvalidModifiers(resourceMethod)) {
            return false;
        }
        if (resourceMethod.isConstructor()) {
            return false;
        }
        String rtName = resourceMethod.getTypeName();
        if (rtName == null) {
            return false;
        }
        return rtName.equals(returnTypeName);
    }

    public static boolean methodsArePersistableProperties(JavaResourceMethod getterMethod, JavaResourceMethod setterMethod) {
        if (setterMethod != null) {
            return true;
        }
        return getterMethod.isAnnotated();
    }

    @Override
    public Iterable<PersistentType> getInheritanceHierarchy() {
        return this.getInheritanceHierarchyOf(this);
    }

    @Override
    public Iterable<PersistentType> getAncestors() {
        return this.getInheritanceHierarchyOf(this.superPersistentType);
    }

    protected Iterable<PersistentType> getInheritanceHierarchyOf(PersistentType start) {
        return new ChainIterable<PersistentType>(start){

            protected PersistentType nextLink(PersistentType persistentType) {
                return persistentType.getSuperPersistentType();
            }
        };
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    public Class<JavaPersistentType> getType() {
        return JavaPersistentType.class;
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        CompilationUnit astRoot = this.buildASTRoot();
        if (this.contains(offset, astRoot)) {
            for (JavaPersistentAttribute persistentAttribute : this.getAttributes()) {
                if (!persistentAttribute.contains(offset, astRoot)) continue;
                return persistentAttribute;
            }
            return this;
        }
        return null;
    }

    protected boolean contains(int offset, CompilationUnit astRoot) {
        TextRange fullTextRange = this.resourceType.getTextRange(astRoot);
        return fullTextRange == null ? false : fullTextRange.includes(offset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getSelectionTextRange(this.buildASTRoot());
    }

    protected TextRange getSelectionTextRange(CompilationUnit astRoot) {
        return this.resourceType.getNameTextRange(astRoot);
    }

    @Override
    public void dispose() {
        this.unregisterRootStructureNode();
    }

    protected void registerRootStructureNode() {
        JpaFile jpaFile = this.getJpaFile();
        if (jpaFile != null) {
            jpaFile.addRootStructureNode(this.name, this);
        }
    }

    protected void unregisterRootStructureNode() {
        JpaFile jpaFile = this.getJpaFile();
        if (jpaFile != null) {
            jpaFile.removeRootStructureNode(this.name, this);
        }
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        Iterable values = this.mapping.getJavaCompletionProposals(pos, filter, astRoot);
        if (values != null) {
            return values;
        }
        for (JavaPersistentAttribute attribute : this.getAttributes()) {
            values = attribute.getJavaCompletionProposals(pos, filter, astRoot);
            if (values == null) continue;
            return values;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        if (MappingTools.nodeIsInternalSource(this, (JavaResourceNode)this.resourceType)) {
            this.validate(messages, reporter, this.buildASTRoot());
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateMapping(messages, reporter, astRoot);
        this.validateAttributes(messages, reporter, astRoot);
    }

    protected void validateMapping(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        try {
            this.mapping.validate(messages, reporter, astRoot);
        }
        catch (Throwable t) {
            JptJpaCorePlugin.log(t);
        }
    }

    protected void validateAttributes(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        for (JavaPersistentAttribute attribute : this.getAttributes()) {
            this.validateAttribute(attribute, reporter, messages, astRoot);
        }
    }

    protected void validateAttribute(JavaPersistentAttribute attribute, IReporter reporter, List<IMessage> messages, CompilationUnit astRoot) {
        try {
            attribute.validate(messages, reporter, astRoot);
        }
        catch (Throwable t) {
            JptJpaCorePlugin.log(t);
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getSelectionTextRange(astRoot);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getSelectionTextRange();
    }

    @Override
    public PersistentType.Owner getParent() {
        return (PersistentType.Owner)super.getParent();
    }

    @Override
    public IResource getResource() {
        return this.resourceType.getFile();
    }

    @Override
    public JavaResourceType getJavaResourceType() {
        return this.resourceType;
    }

    @Override
    public AccessType getOwnerOverrideAccess() {
        return this.getParent().getOverridePersistentTypeAccess();
    }

    @Override
    public AccessType getOwnerDefaultAccess() {
        return this.getParent().getDefaultPersistentTypeAccess();
    }

    protected CompilationUnit buildASTRoot() {
        return this.resourceType.getJavaResourceCompilationUnit().buildASTRoot();
    }

    protected JpaFile getJpaFile() {
        return this.getJpaFile(this.resourceType.getFile());
    }

    @Override
    public boolean isFor(String typeName) {
        return Tools.valuesAreEqual((Object)typeName, (Object)this.getName());
    }

    @Override
    public boolean isIn(IPackageFragment packageFragment) {
        return Tools.valuesAreEqual((Object)packageFragment.getElementName(), (Object)this.getPackageName());
    }

    protected String getPackageName() {
        return this.getJavaResourceType().getPackageName();
    }

    @Override
    public PersistentType getOverriddenPersistentType() {
        return null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    public static AccessType buildAccess(JavaResourceType jrType) {
        for (JavaResourceField field : jrType.getFields()) {
            if (!field.isAnnotated()) continue;
            return AccessType.FIELD;
        }
        for (JavaResourceMethod method : jrType.getMethods()) {
            if (!method.isAnnotated()) continue;
            return AccessType.PROPERTY;
        }
        return null;
    }
}

