/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextNode;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.QueryHint;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaQuery;
import org.eclipse.jpt.jpa.core.context.java.JavaQueryContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaQueryHint;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.core.resource.java.QueryAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.QueryHintAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaQuery<A extends QueryAnnotation>
extends AbstractJavaJpaContextNode
implements JavaQuery {
    protected final A queryAnnotation;
    protected String name;
    protected String query;
    protected final AbstractJpaNode.ContextListContainer<JavaQueryHint, QueryHintAnnotation> hintContainer;

    protected AbstractJavaQuery(JavaJpaContextNode parent, A queryAnnotation) {
        super(parent);
        this.queryAnnotation = queryAnnotation;
        this.name = queryAnnotation.getName();
        this.query = queryAnnotation.getQuery();
        this.hintContainer = this.buildHintContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.queryAnnotation.getName());
        this.setQuery_(this.queryAnnotation.getQuery());
        this.syncHints();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getHints());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.queryAnnotation.setName(name);
        this.setName_(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        this.queryAnnotation.setQuery(query);
        this.setQuery_(query);
    }

    protected void setQuery_(String query) {
        String old = this.query;
        this.query = query;
        this.firePropertyChanged("query", old, query);
    }

    @Override
    public ListIterable<JavaQueryHint> getHints() {
        return this.hintContainer.getContextElements();
    }

    @Override
    public int getHintsSize() {
        return this.hintContainer.getContextElementsSize();
    }

    @Override
    public JavaQueryHint addHint() {
        return this.addHint(this.getHintsSize());
    }

    @Override
    public JavaQueryHint addHint(int index) {
        QueryHintAnnotation annotation = this.queryAnnotation.addHint(index);
        return (JavaQueryHint)this.hintContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeHint(QueryHint hint) {
        this.removeHint(this.hintContainer.indexOfContextElement((JavaQueryHint)hint));
    }

    @Override
    public void removeHint(int index) {
        this.queryAnnotation.removeHint(index);
        this.hintContainer.removeContextElement(index);
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        this.queryAnnotation.moveHint(targetIndex, sourceIndex);
        this.hintContainer.moveContextElement(targetIndex, sourceIndex);
    }

    @Override
    public JavaQueryHint getHint(int index) {
        return (JavaQueryHint)this.hintContainer.get(index);
    }

    protected JavaQueryHint buildHint(QueryHintAnnotation hintAnnotation) {
        return this.getJpaFactory().buildJavaQueryHint(this, hintAnnotation);
    }

    protected void syncHints() {
        this.hintContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<QueryHintAnnotation> getHintAnnotations() {
        return this.queryAnnotation.getHints();
    }

    protected AbstractJpaNode.ContextListContainer<JavaQueryHint, QueryHintAnnotation> buildHintContainer() {
        HintContainer container = new HintContainer();
        container.initialize();
        return container;
    }

    @Override
    public void validate(JpaJpqlQueryHelper queryHelper, List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateName(messages, astRoot);
        this.validateQuery(queryHelper, messages, reporter, astRoot);
    }

    protected void validateName(List<IMessage> messages, CompilationUnit astRoot) {
        if (StringTools.stringIsEmpty((String)this.name)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_NAME_UNDEFINED", EMPTY_STRING_ARRAY, this, this.getNameTextRange(astRoot)));
        }
    }

    public void validateQuery(JpaJpqlQueryHelper queryHelper, List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (StringTools.stringIsEmpty((String)this.query)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_STATEMENT_UNDEFINED", new String[]{this.name}, this, this.getNameTextRange(astRoot)));
        } else {
            this.validateQuery_(queryHelper, messages, reporter);
        }
    }

    protected abstract void validateQuery_(JpaJpqlQueryHelper var1, List<IMessage> var2, IReporter var3);

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.queryAnnotation.getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.queryAnnotation.getNameTextRange(), astRoot);
    }

    @Override
    public boolean isEquivalentTo(JpaNamedContextNode node) {
        return this != node && this.getType() == node.getType() && this.isEquivalentTo((Query)node);
    }

    protected boolean isEquivalentTo(Query other) {
        return Tools.valuesAreEqual((Object)this.name, (Object)other.getName()) && Tools.valuesAreEqual((Object)this.query, (Object)other.getQuery()) && this.hintsAreEquivalentTo(other);
    }

    protected boolean hintsAreEquivalentTo(Query other) {
        ArrayList hints1 = CollectionTools.list(this.getHints());
        ArrayList hints2 = CollectionTools.list(other.getHints());
        if (hints1.size() != hints2.size()) {
            return false;
        }
        int i = 0;
        while (i < hints1.size()) {
            if (!((JavaQueryHint)hints1.get(i)).isEquivalentTo((QueryHint)hints2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public JavaQueryContainer getParent() {
        return (JavaQueryContainer)super.getParent();
    }

    public A getQueryAnnotation() {
        return this.queryAnnotation;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HintContainer
    extends AbstractJpaNode.ContextListContainer<JavaQueryHint, QueryHintAnnotation> {
        protected HintContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "hints";
        }

        @Override
        protected JavaQueryHint buildContextElement(QueryHintAnnotation resourceElement) {
            return AbstractJavaQuery.this.buildHint(resourceElement);
        }

        @Override
        protected ListIterable<QueryHintAnnotation> getResourceElements() {
            return AbstractJavaQuery.this.getHintAnnotations();
        }

        @Override
        protected QueryHintAnnotation getResourceElement(JavaQueryHint contextElement) {
            return contextElement.getQueryHintAnnotation();
        }
    }
}

