/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaCascade;
import org.eclipse.jpt.jpa.core.context.java.JavaMappingRelationship;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaRelationshipMapping;
import org.eclipse.jpt.jpa.core.internal.context.AttributeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaCascade;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.jpa.core.resource.java.RelationshipMappingAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaRelationshipMapping<A extends RelationshipMappingAnnotation>
extends AbstractJavaAttributeMapping<A>
implements JavaRelationshipMapping {
    protected String specifiedTargetEntity = this.buildSpecifiedTargetEntity();
    protected String defaultTargetEntity;
    protected String fullyQualifiedTargetEntity;
    protected final JavaMappingRelationship relationship = this.buildRelationship();
    protected final JavaCascade cascade = this.buildCascade();
    protected FetchType specifiedFetch = this.buildSpecifiedFetch();
    protected FetchType defaultFetch;

    protected AbstractJavaRelationshipMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedTargetEntity_(this.buildSpecifiedTargetEntity());
        this.relationship.synchronizeWithResourceModel();
        this.cascade.synchronizeWithResourceModel();
        this.setSpecifiedFetch_(this.buildSpecifiedFetch());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultTargetEntity(this.buildDefaultTargetEntity());
        this.setFullyQualifiedTargetEntity(this.buildFullyQualifiedTargetEntity());
        this.relationship.update();
        this.cascade.update();
        this.setDefaultFetch(this.buildDefaultFetch());
    }

    @Override
    public String getTargetEntity() {
        return this.specifiedTargetEntity != null ? this.specifiedTargetEntity : this.defaultTargetEntity;
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String entity) {
        if (this.valuesAreDifferent(entity, this.specifiedTargetEntity)) {
            ((RelationshipMappingAnnotation)this.getAnnotationForUpdate()).setTargetEntity(entity);
            this.setSpecifiedTargetEntity_(entity);
        }
    }

    protected void setSpecifiedTargetEntity_(String entity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = entity;
        this.firePropertyChanged("specifiedTargetEntity", old, entity);
    }

    protected String buildSpecifiedTargetEntity() {
        RelationshipMappingAnnotation annotation = (RelationshipMappingAnnotation)this.getMappingAnnotation();
        return annotation == null ? null : annotation.getTargetEntity();
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    protected void setDefaultTargetEntity(String entity) {
        String old = this.defaultTargetEntity;
        this.defaultTargetEntity = entity;
        this.firePropertyChanged("defaultTargetEntity", old, entity);
    }

    protected abstract String buildDefaultTargetEntity();

    @Override
    public String getFullyQualifiedTargetEntity() {
        return this.fullyQualifiedTargetEntity;
    }

    protected void setFullyQualifiedTargetEntity(String entity) {
        String old = this.fullyQualifiedTargetEntity;
        this.fullyQualifiedTargetEntity = entity;
        this.firePropertyChanged("fullyQualifiedTargetEntity", old, entity);
    }

    protected String buildFullyQualifiedTargetEntity() {
        return this.specifiedTargetEntity == null ? this.defaultTargetEntity : ((RelationshipMappingAnnotation)this.getMappingAnnotation()).getFullyQualifiedTargetEntityClassName();
    }

    @Override
    public Entity getResolvedTargetEntity() {
        return this.getPersistenceUnit().getEntity(this.fullyQualifiedTargetEntity);
    }

    public PersistentType getResolvedTargetType() {
        return this.getPersistenceUnit().getPersistentType(this.fullyQualifiedTargetEntity);
    }

    @Override
    public char getTargetEntityEnclosingTypeSeparator() {
        return '.';
    }

    @Override
    public JavaMappingRelationship getRelationship() {
        return this.relationship;
    }

    protected abstract JavaMappingRelationship buildRelationship();

    @Override
    public JavaCascade getCascade() {
        return this.cascade;
    }

    protected JavaCascade buildCascade() {
        return new GenericJavaCascade(this);
    }

    @Override
    public FetchType getFetch() {
        return this.specifiedFetch != null ? this.specifiedFetch : this.defaultFetch;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType fetch) {
        if (this.valuesAreDifferent((Object)fetch, (Object)this.specifiedFetch)) {
            ((RelationshipMappingAnnotation)this.getAnnotationForUpdate()).setFetch(FetchType.toJavaResourceModel(fetch));
            this.setSpecifiedFetch_(fetch);
        }
    }

    protected void setSpecifiedFetch_(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected FetchType buildSpecifiedFetch() {
        RelationshipMappingAnnotation annotation = (RelationshipMappingAnnotation)this.getMappingAnnotation();
        return annotation == null ? null : FetchType.fromJavaResourceModel(annotation.getFetch());
    }

    @Override
    public FetchType getDefaultFetch() {
        return this.defaultFetch;
    }

    protected void setDefaultFetch(FetchType fetch) {
        FetchType old = this.defaultFetch;
        this.defaultFetch = fetch;
        this.firePropertyChanged("defaultFetch", (Object)old, (Object)fetch);
    }

    protected abstract FetchType buildDefaultFetch();

    @Override
    public boolean isRelationshipOwner() {
        return this.relationship.isOwner();
    }

    @Override
    public boolean isOwnedBy(AttributeMapping mapping) {
        return mapping.isRelationshipOwner() && this.relationship.isOwnedBy((RelationshipMapping)mapping);
    }

    @Override
    public RelationshipMapping getRelationshipOwner() {
        Entity entity = this.getResolvedTargetEntity();
        if (entity == null) {
            return null;
        }
        for (ReadOnlyPersistentAttribute attribute : entity.getPersistentType().getAllAttributes()) {
            AttributeMapping mapping = attribute.getMapping();
            if (!this.isOwnedBy(mapping)) continue;
            return (RelationshipMapping)mapping;
        }
        return null;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return this.relationship.isOverridable();
    }

    @Override
    public Iterable<String> getAllTargetEntityAttributeNames() {
        return new CompositeIterable(this.getAllTargetEntityAttributeNamesLists());
    }

    protected Iterable<Iterable<String>> getAllTargetEntityAttributeNamesLists() {
        return new TransformationIterable(this.getAllTargetEntityAttributeMappings(), AttributeMappingTools.ALL_MAPPING_NAMES_TRANSFORMER);
    }

    protected Iterable<AttributeMapping> getAllTargetEntityAttributeMappings() {
        Entity entity = this.getResolvedTargetEntity();
        return entity != null ? entity.getAllAttributeMappings() : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getTargetEntityNonTransientAttributeNames() {
        return new CompositeIterable(this.getTargetEntityNonTransientAttributeNamesLists());
    }

    protected Iterable<Iterable<String>> getTargetEntityNonTransientAttributeNamesLists() {
        return new TransformationIterable(this.getTargetEntityNonTransientAttributeMappings(), AttributeMappingTools.ALL_MAPPING_NAMES_TRANSFORMER);
    }

    protected Iterable<AttributeMapping> getTargetEntityNonTransientAttributeMappings() {
        Entity entity = this.getResolvedTargetEntity();
        return entity != null ? entity.getNonTransientAttributeMappings() : EmptyIterable.instance();
    }

    protected String getTargetEntityIdAttributeName() {
        PersistentAttribute attribute = this.getTargetEntityIdAttribute();
        return attribute == null ? null : attribute.getName();
    }

    protected PersistentAttribute getTargetEntityIdAttribute() {
        Entity entity = this.getResolvedTargetEntity();
        return entity == null ? null : entity.getIdAttribute();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.relationship.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public String getMetamodelTypeName() {
        return this.fullyQualifiedTargetEntity != null ? this.fullyQualifiedTargetEntity : MetamodelField.DEFAULT_TYPE_NAME;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateTargetEntity(messages, astRoot);
        this.relationship.validate(messages, reporter, astRoot);
    }

    protected void validateTargetEntity(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getTargetEntity() == null) {
            String msg = this.getPersistentAttribute().isVirtual() ? "VIRTUAL_ATTRIBUTE_TARGET_ENTITY_NOT_DEFINED" : "TARGET_ENTITY_NOT_DEFINED";
            messages.add(DefaultJpaValidationMessages.buildMessage(1, msg, new String[]{this.getName()}, this, this.getValidationTextRange(astRoot)));
            return;
        }
        IType targetEntityJdtType = JDTTools.findType((IJavaProject)this.getJavaProject(), (String)this.getFullyQualifiedTargetEntity());
        if (targetEntityJdtType == null) {
            return;
        }
        if (this.getResolvedTargetEntity() == null) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_TARGET_ENTITY_IS_NOT_AN_ENTITY", new String[]{this.getName(), this.getFullyQualifiedTargetEntity()}, this, this.getValidationTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "TARGET_ENTITY_IS_NOT_AN_ENTITY", new String[]{this.getFullyQualifiedTargetEntity()}, this, this.getTargetEntityTextRange(astRoot)));
            }
        }
    }

    protected TextRange getTargetEntityTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getAnnotationTargetEntityTextRange(), astRoot);
    }

    protected TextRange getAnnotationTargetEntityTextRange() {
        RelationshipMappingAnnotation annotation = (RelationshipMappingAnnotation)this.getMappingAnnotation();
        return annotation == null ? null : annotation.getTargetEntityTextRange();
    }
}

