/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryContainer;
import org.eclipse.jpt.jpa.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.jpa.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.jpa.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityMappings
extends AbstractOrmXmlContextNode
implements EntityMappings {
    protected final XmlEntityMappings xmlEntityMappings;
    protected String description;
    protected String package_;
    protected AccessType specifiedAccess;
    protected AccessType defaultAccess;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected final OrmPersistenceUnitMetadata persistenceUnitMetadata;
    protected final Vector<OrmPersistentType> persistentTypes = new Vector();
    protected final PersistentTypeContainerAdapter persistentTypeContainerAdapter = new PersistentTypeContainerAdapter();
    protected final AbstractJpaNode.ContextListContainer<OrmSequenceGenerator, XmlSequenceGenerator> sequenceGeneratorContainer;
    protected final AbstractJpaNode.ContextListContainer<OrmTableGenerator, XmlTableGenerator> tableGeneratorContainer;
    protected final OrmQueryContainer queryContainer;
    protected static Map<String, String> PRIMITIVE_CLASSES = null;
    protected static final TypeLookupAdapter PERSISTENT_TYPE_LOOKUP_ADAPTER = new TypeLookupAdapter(){

        public Object resolveType(EntityMappings entityMappings, String className) {
            return entityMappings.getPersistenceUnit().getPersistentType(className);
        }
    };
    protected static final TypeLookupAdapter RESOURCE_TYPE_LOOKUP_ADAPTER = new TypeLookupAdapter(){

        public Object resolveType(EntityMappings entityMappings, String className) {
            return entityMappings.getJpaProject().getJavaResourceType(className);
        }
    };
    protected static final TypeLookupAdapter JDT_TYPE_LOOKUP_ADAPTER = new TypeLookupAdapter(){

        public Object resolveType(EntityMappings entityMappings, String className) {
            IJavaProject javaProject = entityMappings.getJpaProject().getJavaProject();
            return JDTTools.findType((IJavaProject)javaProject, (String)className);
        }
    };
    protected static final Comparator<OrmPersistentType> MAPPING_COMPARATOR = new Comparator<OrmPersistentType>(){

        @Override
        public int compare(OrmPersistentType o1, OrmPersistentType o2) {
            int o2Sequence;
            int o1Sequence = o1.getMapping().getXmlSequence();
            if (o1Sequence < (o2Sequence = o2.getMapping().getXmlSequence())) {
                return -1;
            }
            if (o1Sequence == o2Sequence) {
                return 0;
            }
            return 1;
        }
    };

    protected AbstractEntityMappings(OrmXml parent, XmlEntityMappings xmlEntityMappings) {
        super(parent);
        this.xmlEntityMappings = xmlEntityMappings;
        this.description = this.xmlEntityMappings.getDescription();
        this.package_ = this.xmlEntityMappings.getPackage();
        this.specifiedAccess = this.buildSpecifiedAccess();
        this.specifiedCatalog = this.xmlEntityMappings.getCatalog();
        this.specifiedSchema = this.xmlEntityMappings.getSchema();
        this.persistenceUnitMetadata = this.buildPersistenceUnitMetadata();
        this.initializePersistentTypes();
        this.sequenceGeneratorContainer = this.buildSequenceGeneratorContainer();
        this.tableGeneratorContainer = this.buildTableGeneratorContainer();
        this.queryContainer = this.buildQueryContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setDescription_(this.xmlEntityMappings.getDescription());
        this.setPackage_(this.xmlEntityMappings.getPackage());
        this.setSpecifiedAccess_(this.buildSpecifiedAccess());
        this.setSpecifiedCatalog_(this.xmlEntityMappings.getCatalog());
        this.setSpecifiedSchema_(this.xmlEntityMappings.getSchema());
        this.persistenceUnitMetadata.synchronizeWithResourceModel();
        this.syncPersistentTypes();
        this.syncSequenceGenerators();
        this.syncTableGenerators();
        this.queryContainer.synchronizeWithResourceModel();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultAccess(this.buildDefaultAccess());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.persistenceUnitMetadata.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getPersistentTypes());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSequenceGenerators());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getTableGenerators());
        this.queryContainer.update();
    }

    @Override
    public OrmXml getParent() {
        return (OrmXml)super.getParent();
    }

    public OrmXml getOrmXml() {
        return this.getParent();
    }

    @Override
    public EntityMappings getMappingFileRoot() {
        return this;
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    public Class<EntityMappings> getType() {
        return EntityMappings.class;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (OrmPersistentType persistentType : this.getPersistentTypes()) {
            if (!persistentType.contains(textOffset)) continue;
            return persistentType.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlEntityMappings.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        for (OrmPersistentType ormPersistentType : this.getPersistentTypes()) {
            ormPersistentType.dispose();
        }
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return this.isXmlMappingMetadataComplete() ? this.specifiedAccess : null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getAccess();
    }

    @Override
    public String getDefaultPersistentTypePackage() {
        return this.getPackage();
    }

    protected boolean isXmlMappingMetadataComplete() {
        return this.getPersistenceUnit().isXmlMappingMetadataComplete();
    }

    @Override
    public OrmPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.persistenceUnitMetadata;
    }

    protected OrmPersistenceUnitMetadata buildPersistenceUnitMetadata() {
        return this.getContextNodeFactory().buildOrmPersistenceUnitMetadata(this);
    }

    @Override
    public XmlEntityMappings getXmlEntityMappings() {
        return this.xmlEntityMappings;
    }

    @Override
    public String getVersion() {
        return this.xmlEntityMappings.getVersion();
    }

    @Override
    public void changeMapping(OrmPersistentType ormPersistentType, OrmTypeMapping oldMapping, OrmTypeMapping newMapping) {
        AccessType savedAccess = ormPersistentType.getSpecifiedAccess();
        int sourceIndex = this.persistentTypes.indexOf(ormPersistentType);
        this.persistentTypes.remove(sourceIndex);
        oldMapping.removeXmlTypeMappingFrom(this.xmlEntityMappings);
        int targetIndex = this.calculateInsertionIndex(ormPersistentType);
        this.persistentTypes.add(targetIndex, ormPersistentType);
        newMapping.addXmlTypeMappingTo(this.xmlEntityMappings);
        newMapping.initializeFrom(oldMapping);
        ormPersistentType.setSpecifiedAccess(savedAccess);
        this.fireItemMoved("persistentTypes", targetIndex, sourceIndex);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlEntityMappings.getValidationTextRange();
        return textRange != null ? textRange : this.getOrmXml().getValidationTextRange();
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlEntityMappings != null && this.xmlEntityMappings.containsOffset(textOffset);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.setDescription_(description);
        this.xmlEntityMappings.setDescription(description);
    }

    protected void setDescription_(String description) {
        String old = this.description;
        this.description = description;
        this.firePropertyChanged("description", old, description);
    }

    @Override
    public String getPackage() {
        return this.package_;
    }

    @Override
    public void setPackage(String package_) {
        this.setPackage_(package_);
        this.xmlEntityMappings.setPackage(package_);
    }

    protected void setPackage_(String package_) {
        String old = this.package_;
        this.package_ = package_;
        this.firePropertyChanged("package", old, package_);
    }

    @Override
    public AccessType getAccess() {
        return this.specifiedAccess != null ? this.specifiedAccess : this.defaultAccess;
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType access) {
        this.setSpecifiedAccess_(access);
        this.xmlEntityMappings.setAccess(AccessType.toOrmResourceModel(access));
    }

    protected void setSpecifiedAccess_(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.firePropertyChanged("specifiedAccess", old, access);
    }

    protected AccessType buildSpecifiedAccess() {
        return AccessType.fromOrmResourceModel(this.xmlEntityMappings.getAccess(), this.getJpaPlatform(), this.getResourceType());
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", old, access);
    }

    protected AccessType buildDefaultAccess() {
        return this.getPersistenceUnit().getDefaultAccess();
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        this.setSpecifiedCatalog_(catalog);
        this.xmlEntityMappings.setCatalog(catalog);
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected String buildDefaultCatalog() {
        return this.getPersistenceUnit().getDefaultCatalog();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        this.setSpecifiedSchema_(schema);
        this.xmlEntityMappings.setSchema(schema);
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected String buildDefaultSchema() {
        return this.getPersistenceUnit().getDefaultSchema();
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public ListIterable<OrmPersistentType> getPersistentTypes() {
        return new LiveCloneListIterable(this.persistentTypes);
    }

    @Override
    public int getPersistentTypesSize() {
        return this.persistentTypes.size();
    }

    @Override
    public OrmPersistentType getPersistentType(String className) {
        for (OrmPersistentType ormPersistentType : this.getPersistentTypes()) {
            if (!ormPersistentType.isFor(className)) continue;
            return ormPersistentType;
        }
        return null;
    }

    @Override
    public boolean containsPersistentType(String className) {
        return this.getPersistentType(className) != null;
    }

    @Override
    public PersistentType resolvePersistentType(String className) {
        return (PersistentType)this.resolveType(PERSISTENT_TYPE_LOOKUP_ADAPTER, className);
    }

    @Override
    public JavaResourceAbstractType resolveJavaResourceType(String className) {
        return (JavaResourceAbstractType)this.resolveType(RESOURCE_TYPE_LOOKUP_ADAPTER, className);
    }

    @Override
    public JavaResourceAbstractType resolveJavaResourceType(String className, JavaResourceAnnotatedElement.Kind kind) {
        JavaResourceAbstractType resourceType = this.resolveJavaResourceType(className);
        if (resourceType == null || resourceType.getKind() != kind) {
            return null;
        }
        return resourceType;
    }

    @Override
    public IType resolveJdtType(String className) {
        return (IType)this.resolveType(JDT_TYPE_LOOKUP_ADAPTER, className);
    }

    @Override
    public String getFullyQualifiedName(String className) {
        if (StringTools.stringIsEmpty((String)className)) {
            return null;
        }
        String primitiveClassName = AbstractEntityMappings.getPrimitiveClassName(className);
        if (primitiveClassName != null) {
            return primitiveClassName;
        }
        if (this.getPackage() != null && className.indexOf(46) == -1) {
            className = this.prependGlobalPackage(className);
        }
        className = className.replace('$', '.');
        return className;
    }

    protected Object resolveType(TypeLookupAdapter adapter, String className) {
        if (className == null) {
            return null;
        }
        return adapter.resolveType(this, this.getFullyQualifiedName(className));
    }

    protected String prependGlobalPackage(String unqualifiedClassName) {
        return String.valueOf(this.getPackage()) + '.' + unqualifiedClassName;
    }

    protected static String getPrimitiveClassName(String className) {
        if (PRIMITIVE_CLASSES == null) {
            PRIMITIVE_CLASSES = new HashMap<String, String>();
            PRIMITIVE_CLASSES.put("Boolean", Boolean.class.getName());
            PRIMITIVE_CLASSES.put("Byte", Byte.class.getName());
            PRIMITIVE_CLASSES.put("Character", Character.class.getName());
            PRIMITIVE_CLASSES.put("Double", Double.class.getName());
            PRIMITIVE_CLASSES.put("Float", Float.class.getName());
            PRIMITIVE_CLASSES.put("Integer", Integer.class.getName());
            PRIMITIVE_CLASSES.put("Long", Long.class.getName());
            PRIMITIVE_CLASSES.put("Number", Number.class.getName());
            PRIMITIVE_CLASSES.put("Short", Short.class.getName());
            PRIMITIVE_CLASSES.put("String", String.class.getName());
            PRIMITIVE_CLASSES.put("boolean", "boolean");
            PRIMITIVE_CLASSES.put("byte", "byte");
            PRIMITIVE_CLASSES.put("char", "char");
            PRIMITIVE_CLASSES.put("double", "double");
            PRIMITIVE_CLASSES.put("float", "float");
            PRIMITIVE_CLASSES.put("int", "int");
            PRIMITIVE_CLASSES.put("long", "long");
            PRIMITIVE_CLASSES.put("short", "short");
            PRIMITIVE_CLASSES.put("byte[]", "byte[]");
            PRIMITIVE_CLASSES.put("char[]", "char[]");
            PRIMITIVE_CLASSES.put("boolean[]", "boolean[]");
            PRIMITIVE_CLASSES.put("double[]", "double[]");
            PRIMITIVE_CLASSES.put("float[]", "float[]");
            PRIMITIVE_CLASSES.put("int[]", "int[]");
            PRIMITIVE_CLASSES.put("long[]", "long[]");
            PRIMITIVE_CLASSES.put("short[]", "short[]");
        }
        return className == null ? null : PRIMITIVE_CLASSES.get(className);
    }

    @Override
    public OrmPersistentType addPersistentType(String mappingKey, String className) {
        OrmTypeMappingDefinition md = this.getMappingFileDefinition().getTypeMappingDefinition(mappingKey);
        XmlTypeMapping xmlTypeMapping = md.buildResourceMapping(this.getResourceNodeFactory());
        className = this.normalizeClassName(className);
        xmlTypeMapping.setClassName(className);
        OrmPersistentType persistentType = this.buildPersistentType(xmlTypeMapping);
        int index = this.calculateInsertionIndex(persistentType);
        this.addItemToList(index, persistentType, this.persistentTypes, "persistentTypes");
        persistentType.getMapping().addXmlTypeMappingTo(this.xmlEntityMappings);
        return persistentType;
    }

    public void addPersistentTypes(AbstractPersistenceUnit.MappedType[] mappedTypes, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)3);
        if (sm.isCanceled()) {
            return;
        }
        this.addMappedSuperclasses(mappedTypes, (IProgressMonitor)sm.newChild(1));
        if (sm.isCanceled()) {
            return;
        }
        this.addEntities(mappedTypes, (IProgressMonitor)sm.newChild(1));
        if (sm.isCanceled()) {
            return;
        }
        this.addEmbeddables(mappedTypes, (IProgressMonitor)sm.newChild(1));
    }

    protected void addMappedSuperclasses(AbstractPersistenceUnit.MappedType[] types, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)5);
        sm.setTaskName(JptCoreMessages.MAKE_PERSISTENT_PROCESSING_MAPPED_SUPERCLASSES);
        List<OrmPersistentType> addedItems = this.addOrmPersistentTypes(types, "mappedSuperclass", (IProgressMonitor)sm.newChild(4));
        if (addedItems.size() == 0 || sm.isCanceled()) {
            return;
        }
        ArrayList<XmlMappedSuperclass> mappedSuperclasses = new ArrayList<XmlMappedSuperclass>(addedItems.size());
        for (OrmPersistentType persistentType : addedItems) {
            mappedSuperclasses.add((XmlMappedSuperclass)persistentType.getMapping().getXmlTypeMapping());
        }
        sm.subTask(JptCoreMessages.MAKE_PERSISTENT_ADD_TO_XML_RESOURCE_MODEL);
        this.xmlEntityMappings.getMappedSuperclasses().addAll(mappedSuperclasses);
        sm.worked(1);
    }

    protected void addEntities(AbstractPersistenceUnit.MappedType[] types, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)5);
        sm.setTaskName(JptCoreMessages.MAKE_PERSISTENT_PROCESSING_ENTITIES);
        List<OrmPersistentType> addedItems = this.addOrmPersistentTypes(types, "entity", (IProgressMonitor)sm.newChild(4));
        if (addedItems.size() == 0 || sm.isCanceled()) {
            return;
        }
        ArrayList<XmlEntity> entities = new ArrayList<XmlEntity>(addedItems.size());
        for (OrmPersistentType persistentType : addedItems) {
            entities.add((XmlEntity)persistentType.getMapping().getXmlTypeMapping());
        }
        sm.subTask(JptCoreMessages.MAKE_PERSISTENT_ADD_TO_XML_RESOURCE_MODEL);
        this.xmlEntityMappings.getEntities().addAll(0, entities);
        sm.worked(1);
    }

    protected void addEmbeddables(AbstractPersistenceUnit.MappedType[] types, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)5);
        sm.setTaskName(JptCoreMessages.MAKE_PERSISTENT_PROCESSING_EMBEDDABLES);
        List<OrmPersistentType> addedItems = this.addOrmPersistentTypes(types, "embeddable", (IProgressMonitor)sm.newChild(4));
        if (addedItems.size() == 0 || sm.isCanceled()) {
            return;
        }
        ArrayList<XmlEmbeddable> embeddables = new ArrayList<XmlEmbeddable>(addedItems.size());
        for (OrmPersistentType persistentType : addedItems) {
            embeddables.add((XmlEmbeddable)persistentType.getMapping().getXmlTypeMapping());
        }
        sm.subTask(JptCoreMessages.MAKE_PERSISTENT_ADD_TO_XML_RESOURCE_MODEL);
        this.xmlEntityMappings.getEmbeddables().addAll(0, embeddables);
        sm.worked(1);
    }

    protected List<OrmPersistentType> addOrmPersistentTypes(AbstractPersistenceUnit.MappedType[] types, String mappingKey, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        ArrayList<OrmPersistentType> addedItems = new ArrayList<OrmPersistentType>();
        AbstractPersistenceUnit.MappedType[] mappedTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPersistenceUnit.MappedType type = mappedTypeArray[n2];
            if (type.getMappingKey() == mappingKey) {
                String className = type.getFullyQualifiedName();
                sm.subTask(NLS.bind((String)JptCoreMessages.MAKE_PERSISTENT_BUILDING_PERSISTENT_TYPE, (Object)className));
                OrmTypeMappingDefinition md = this.getMappingFileDefinition().getTypeMappingDefinition(type.getMappingKey());
                XmlTypeMapping xmlTypeMapping = md.buildResourceMapping(this.getResourceNodeFactory());
                className = this.normalizeClassName(className);
                xmlTypeMapping.setClassName(className);
                addedItems.add(this.buildPersistentType(xmlTypeMapping));
            }
            ++n2;
        }
        if (addedItems.size() == 0 || sm.isCanceled()) {
            return addedItems;
        }
        sm.worked(1);
        int index = this.calculateInsertionIndex((OrmPersistentType)addedItems.get(0));
        sm.subTask(JptCoreMessages.MAKE_PERSISTENT_UPDATING_JPA_MODEL);
        this.addItemsToList(index, addedItems, this.persistentTypes, "persistentTypes");
        sm.worked(9);
        return addedItems;
    }

    protected String normalizeClassName(String className) {
        return this.package_ != null && className.startsWith(this.package_) && className.charAt(this.package_.length()) == '.' && className.indexOf(46, this.package_.length() + 1) == -1 ? className.substring(this.package_.length() + 1) : className;
    }

    protected OrmPersistentType buildPersistentType(XmlTypeMapping xmlTypeMapping) {
        return this.getContextNodeFactory().buildOrmPersistentType(this, xmlTypeMapping);
    }

    protected int calculateInsertionIndex(OrmPersistentType ormPersistentType) {
        return CollectionTools.insertionIndexOf(this.persistentTypes, (Object)ormPersistentType, MAPPING_COMPARATOR);
    }

    @Override
    public void removePersistentType(int index) {
        OrmPersistentType persistentType = this.removePersistentType_(index);
        persistentType.getMapping().removeXmlTypeMappingFrom(this.xmlEntityMappings);
    }

    protected OrmPersistentType removePersistentType_(int index) {
        OrmPersistentType persistentType = (OrmPersistentType)this.removeItemFromList(index, this.persistentTypes, "persistentTypes");
        persistentType.dispose();
        return persistentType;
    }

    @Override
    public void removePersistentType(OrmPersistentType persistentType) {
        this.removePersistentType(this.persistentTypes.indexOf(persistentType));
    }

    protected void initializePersistentTypes() {
        for (XmlTypeMapping xmlTypeMapping : this.getXmlTypeMappings()) {
            this.persistentTypes.add(this.buildPersistentType(xmlTypeMapping));
        }
    }

    protected void syncPersistentTypes() {
        ContextContainerTools.synchronizeWithResourceModel(this.persistentTypeContainerAdapter);
    }

    protected Iterable<XmlTypeMapping> getXmlTypeMappings() {
        return new LiveCloneIterable(this.xmlEntityMappings.getTypeMappings());
    }

    protected void movePersistentType_(int index, OrmPersistentType persistentType) {
        this.moveItemInList(index, persistentType, this.persistentTypes, "persistentTypes");
    }

    protected void addPersistentType_(int index, XmlTypeMapping xmlTypeMapping) {
        this.addItemToList(index, this.buildPersistentType(xmlTypeMapping), this.persistentTypes, "persistentTypes");
    }

    protected void removePersistentType_(OrmPersistentType persistentType) {
        this.removePersistentType_(this.persistentTypes.indexOf(persistentType));
    }

    @Override
    public ListIterable<OrmSequenceGenerator> getSequenceGenerators() {
        return this.sequenceGeneratorContainer.getContextElements();
    }

    @Override
    public int getSequenceGeneratorsSize() {
        return this.sequenceGeneratorContainer.getContextElementsSize();
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator() {
        return this.addSequenceGenerator(this.getSequenceGeneratorsSize());
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator(int index) {
        XmlSequenceGenerator xmlGenerator = this.buildXmlSequenceGenerator();
        OrmSequenceGenerator sequenceGenerator = (OrmSequenceGenerator)this.sequenceGeneratorContainer.addContextElement(index, xmlGenerator);
        this.xmlEntityMappings.getSequenceGenerators().add(index, (Object)xmlGenerator);
        return sequenceGenerator;
    }

    protected XmlSequenceGenerator buildXmlSequenceGenerator() {
        return OrmFactory.eINSTANCE.createXmlSequenceGenerator();
    }

    protected OrmSequenceGenerator buildSequenceGenerator(XmlSequenceGenerator xmlSequenceGenerator) {
        return this.getContextNodeFactory().buildOrmSequenceGenerator(this, xmlSequenceGenerator);
    }

    @Override
    public void removeSequenceGenerator(OrmSequenceGenerator sequenceGenerator) {
        this.removeSequenceGenerator(this.sequenceGeneratorContainer.indexOfContextElement(sequenceGenerator));
    }

    @Override
    public void removeSequenceGenerator(int index) {
        this.sequenceGeneratorContainer.removeContextElement(index);
        this.xmlEntityMappings.getSequenceGenerators().remove(index);
    }

    @Override
    public void moveSequenceGenerator(int targetIndex, int sourceIndex) {
        this.sequenceGeneratorContainer.moveContextElement(targetIndex, sourceIndex);
        this.xmlEntityMappings.getSequenceGenerators().move(targetIndex, sourceIndex);
    }

    protected void syncSequenceGenerators() {
        this.sequenceGeneratorContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlSequenceGenerator> getXmlSequenceGenerators() {
        return new LiveCloneListIterable(this.xmlEntityMappings.getSequenceGenerators());
    }

    protected AbstractJpaNode.ContextListContainer<OrmSequenceGenerator, XmlSequenceGenerator> buildSequenceGeneratorContainer() {
        SequenceGeneratorContainer container = new SequenceGeneratorContainer();
        container.initialize();
        return container;
    }

    @Override
    public ListIterable<OrmTableGenerator> getTableGenerators() {
        return this.tableGeneratorContainer.getContextElements();
    }

    @Override
    public int getTableGeneratorsSize() {
        return this.tableGeneratorContainer.getContextElementsSize();
    }

    @Override
    public OrmTableGenerator addTableGenerator() {
        return this.addTableGenerator(this.getTableGeneratorsSize());
    }

    @Override
    public OrmTableGenerator addTableGenerator(int index) {
        XmlTableGenerator xmlTableGenerator = this.buildXmlTableGenerator();
        OrmTableGenerator tableGenerator = (OrmTableGenerator)this.tableGeneratorContainer.addContextElement(index, xmlTableGenerator);
        this.xmlEntityMappings.getTableGenerators().add(index, (Object)xmlTableGenerator);
        return tableGenerator;
    }

    protected XmlTableGenerator buildXmlTableGenerator() {
        return OrmFactory.eINSTANCE.createXmlTableGenerator();
    }

    protected OrmTableGenerator buildTableGenerator(XmlTableGenerator xmlTableGenerator) {
        return this.getContextNodeFactory().buildOrmTableGenerator(this, xmlTableGenerator);
    }

    @Override
    public void removeTableGenerator(OrmTableGenerator tableGenerator) {
        this.removeTableGenerator(this.tableGeneratorContainer.indexOfContextElement(tableGenerator));
    }

    @Override
    public void removeTableGenerator(int index) {
        this.tableGeneratorContainer.removeContextElement(index);
        this.xmlEntityMappings.getTableGenerators().remove(index);
    }

    @Override
    public void moveTableGenerator(int targetIndex, int sourceIndex) {
        this.tableGeneratorContainer.moveContextElement(targetIndex, sourceIndex);
        this.xmlEntityMappings.getTableGenerators().move(targetIndex, sourceIndex);
    }

    protected void syncTableGenerators() {
        this.tableGeneratorContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlTableGenerator> getXmlTableGenerators() {
        return new LiveCloneListIterable(this.xmlEntityMappings.getTableGenerators());
    }

    protected AbstractJpaNode.ContextListContainer<OrmTableGenerator, XmlTableGenerator> buildTableGeneratorContainer() {
        TableGeneratorContainer container = new TableGeneratorContainer();
        container.initialize();
        return container;
    }

    @Override
    public OrmQueryContainer getQueryContainer() {
        return this.queryContainer;
    }

    protected OrmQueryContainer buildQueryContainer() {
        return this.getContextNodeFactory().buildOrmQueryContainer(this, this.xmlEntityMappings);
    }

    @Override
    public Iterable<Query> getMappingFileQueries() {
        return new CompositeIterable(new Iterable[]{this.queryContainer.getQueries(), this.getTypeMappingQueries()});
    }

    protected Iterable<Query> getTypeMappingQueries() {
        return new CompositeIterable(this.getTypeMappingQueryLists());
    }

    protected Iterable<Iterable<Query>> getTypeMappingQueryLists() {
        return new TransformationIterable<OrmTypeMapping, Iterable<Query>>(this.getTypeMappings()){

            protected Iterable<Query> transform(OrmTypeMapping typeMapping) {
                return typeMapping.getQueries();
            }
        };
    }

    @Override
    public Iterable<Generator> getMappingFileGenerators() {
        return new CompositeIterable(new Iterable[]{this.getSequenceGenerators(), this.getTableGenerators(), this.getTypeMappingGenerators()});
    }

    protected Iterable<Generator> getTypeMappingGenerators() {
        return new CompositeIterable(this.getTypeMappingGeneratorLists());
    }

    protected Iterable<Iterable<Generator>> getTypeMappingGeneratorLists() {
        return new TransformationIterable<OrmTypeMapping, Iterable<Generator>>(this.getTypeMappings()){

            protected Iterable<Generator> transform(OrmTypeMapping typeMapping) {
                return typeMapping.getGenerators();
            }
        };
    }

    protected Iterable<OrmTypeMapping> getTypeMappings() {
        return new TransformationIterable<OrmPersistentType, OrmTypeMapping>(this.getPersistentTypes()){

            protected OrmTypeMapping transform(OrmPersistentType persistentType) {
                return persistentType.getMapping();
            }
        };
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateVersion(messages);
        this.queryContainer.validate(messages, reporter);
        for (OrmPersistentType ormPersistentType : this.getPersistentTypes()) {
            this.validatePersistentType(ormPersistentType, messages, reporter);
        }
    }

    protected void validateVersion(List<IMessage> messages) {
        if (!this.getLatestDocumentVersion().equals(this.xmlEntityMappings.getVersion())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(4, "XML_VERSION_NOT_LATEST", this, this.xmlEntityMappings.getVersionTextRange()));
        }
    }

    protected String getLatestDocumentVersion() {
        return this.getJpaPlatform().getMostRecentSupportedResourceType(this.getContentType()).getVersion();
    }

    protected IContentType getContentType() {
        return JptJpaCorePlugin.ORM_XML_CONTENT_TYPE;
    }

    protected void validatePersistentType(OrmPersistentType persistentType, List<IMessage> messages, IReporter reporter) {
        try {
            persistentType.validate(messages, reporter);
        }
        catch (Throwable exception) {
            JptJpaCorePlugin.log(exception);
        }
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(final IType type) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentType, Iterable<DeleteEdit>>(this.getPersistentTypes()){

            protected Iterable<DeleteEdit> transform(OrmPersistentType persistentType) {
                return persistentType.createDeleteTypeEdits(type);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(final IType originalType, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentType, Iterable<ReplaceEdit>>(this.getPersistentTypes()){

            protected Iterable<ReplaceEdit> transform(OrmPersistentType persistentType) {
                return persistentType.createRenameTypeEdits(originalType, newName);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(final IType originalType, final IPackageFragment newPackage) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentType, Iterable<ReplaceEdit>>(this.getPersistentTypes()){

            protected Iterable<ReplaceEdit> transform(OrmPersistentType persistentType) {
                return persistentType.createMoveTypeEdits(originalType, newPackage);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return new CompositeIterable(new Iterable[]{this.createPersistentTypeRenamePackageEdits(originalPackage, newName), this.createRenamePackageEdit(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createPersistentTypeRenamePackageEdits(final IPackageFragment originalPackage, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentType, Iterable<ReplaceEdit>>(this.getPersistentTypes()){

            protected Iterable<ReplaceEdit> transform(OrmPersistentType persistentType) {
                return persistentType.createRenamePackageEdits(originalPackage, newName);
            }
        });
    }

    protected Iterable<ReplaceEdit> createRenamePackageEdit(IPackageFragment originalPackage, String newName) {
        return Tools.valuesAreEqual((Object)this.package_, (Object)originalPackage.getElementName()) ? new SingleElementIterable((Object)this.xmlEntityMappings.createRenamePackageEdit(newName)) : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getXmlCompletionProposals(int pos) {
        Iterable result = super.getXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.queryContainer.getXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (OrmTableGenerator tableGenerator : this.getTableGenerators()) {
            result = tableGenerator.getXmlCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        for (OrmSequenceGenerator seqGenerator : this.getSequenceGenerators()) {
            result = seqGenerator.getXmlCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        result = this.persistenceUnitMetadata.getXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.packageTouches(pos)) {
            return this.getCandidatePackages();
        }
        for (OrmPersistentType persistentType : this.getPersistentTypes()) {
            result = persistentType.getXmlCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected Iterable<String> getConnectedXmlCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.schemaTouches(pos)) {
            return this.getCandidateSchemata();
        }
        if (this.catalogTouches(pos)) {
            return this.getCandidateCatalogs();
        }
        return null;
    }

    protected boolean schemaTouches(int pos) {
        return this.getXmlEntityMappings().schemaTouches(pos);
    }

    protected Iterable<String> getCandidateSchemata() {
        SchemaContainer schemaContainer = this.getDbSchemaContainer();
        return schemaContainer != null ? schemaContainer.getSortedSchemaIdentifiers() : EmptyIterable.instance();
    }

    protected boolean catalogTouches(int pos) {
        return this.getXmlEntityMappings().catalogTouches(pos);
    }

    protected Iterable<String> getCandidateCatalogs() {
        Database db = this.getDatabase();
        return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
    }

    private boolean packageTouches(int pos) {
        return this.getXmlEntityMappings().packageTouches(pos);
    }

    private Iterable<String> getCandidatePackages() {
        return this.getPersistenceUnit().getPackageNames();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PersistentTypeContainerAdapter
    implements ContextContainerTools.Adapter<OrmPersistentType, XmlTypeMapping> {
        protected PersistentTypeContainerAdapter() {
        }

        @Override
        public Iterable<OrmPersistentType> getContextElements() {
            return AbstractEntityMappings.this.getPersistentTypes();
        }

        @Override
        public Iterable<XmlTypeMapping> getResourceElements() {
            return AbstractEntityMappings.this.getXmlTypeMappings();
        }

        @Override
        public XmlTypeMapping getResourceElement(OrmPersistentType contextElement) {
            return contextElement.getMapping().getXmlTypeMapping();
        }

        @Override
        public void moveContextElement(int index, OrmPersistentType element) {
            AbstractEntityMappings.this.movePersistentType_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlTypeMapping resourceElement) {
            AbstractEntityMappings.this.addPersistentType_(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmPersistentType element) {
            AbstractEntityMappings.this.removePersistentType_(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SequenceGeneratorContainer
    extends AbstractJpaNode.ContextListContainer<OrmSequenceGenerator, XmlSequenceGenerator> {
        protected SequenceGeneratorContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "sequenceGenerators";
        }

        @Override
        protected OrmSequenceGenerator buildContextElement(XmlSequenceGenerator resourceElement) {
            return AbstractEntityMappings.this.buildSequenceGenerator(resourceElement);
        }

        @Override
        protected ListIterable<XmlSequenceGenerator> getResourceElements() {
            return AbstractEntityMappings.this.getXmlSequenceGenerators();
        }

        @Override
        protected XmlSequenceGenerator getResourceElement(OrmSequenceGenerator contextElement) {
            return contextElement.getXmlGenerator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TableGeneratorContainer
    extends AbstractJpaNode.ContextListContainer<OrmTableGenerator, XmlTableGenerator> {
        protected TableGeneratorContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "tableGenerators";
        }

        @Override
        protected OrmTableGenerator buildContextElement(XmlTableGenerator resourceElement) {
            return AbstractEntityMappings.this.buildTableGenerator(resourceElement);
        }

        @Override
        protected ListIterable<XmlTableGenerator> getResourceElements() {
            return AbstractEntityMappings.this.getXmlTableGenerators();
        }

        @Override
        protected XmlTableGenerator getResourceElement(OrmTableGenerator contextElement) {
            return contextElement.getXmlGenerator();
        }
    }

    protected static interface TypeLookupAdapter {
        public Object resolveType(EntityMappings var1, String var2);
    }
}

