/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextNode;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmGenerator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.orm.XmlGenerator;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmGenerator<X extends XmlGenerator>
extends AbstractOrmXmlContextNode
implements OrmGenerator {
    protected final X xmlGenerator;
    protected String name;
    protected Integer specifiedInitialValue;
    protected int defaultInitialValue;
    protected Integer specifiedAllocationSize;
    protected int defaultAllocationSize;

    protected AbstractOrmGenerator(XmlContextNode parent, X xmlGenerator) {
        super(parent);
        this.xmlGenerator = xmlGenerator;
        this.name = xmlGenerator.getName();
        this.specifiedInitialValue = xmlGenerator.getInitialValue();
        this.specifiedAllocationSize = xmlGenerator.getAllocationSize();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.xmlGenerator.getName());
        this.setSpecifiedInitialValue_(this.xmlGenerator.getInitialValue());
        this.setSpecifiedAllocationSize_(this.xmlGenerator.getAllocationSize());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultInitialValue(this.buildDefaultInitialValue());
        this.setDefaultAllocationSize(this.buildDefaultAllocationSize());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName_(name);
        this.xmlGenerator.setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public int getInitialValue() {
        return this.specifiedInitialValue != null ? this.specifiedInitialValue : this.defaultInitialValue;
    }

    @Override
    public Integer getSpecifiedInitialValue() {
        return this.specifiedInitialValue;
    }

    @Override
    public void setSpecifiedInitialValue(Integer specifiedInitialValue) {
        this.setSpecifiedInitialValue_(specifiedInitialValue);
        this.xmlGenerator.setInitialValue(specifiedInitialValue);
    }

    protected void setSpecifiedInitialValue_(Integer specifiedInitialValue) {
        Integer old = this.specifiedInitialValue;
        this.specifiedInitialValue = specifiedInitialValue;
        this.firePropertyChanged("specifiedInitialValue", old, specifiedInitialValue);
    }

    @Override
    public int getDefaultInitialValue() {
        return this.defaultInitialValue;
    }

    protected void setDefaultInitialValue(int defaultInitialValue) {
        int old = this.defaultInitialValue;
        this.defaultInitialValue = defaultInitialValue;
        this.firePropertyChanged("defaultInitialValue", old, defaultInitialValue);
    }

    protected abstract int buildDefaultInitialValue();

    @Override
    public int getAllocationSize() {
        return this.specifiedAllocationSize != null ? this.specifiedAllocationSize : this.defaultAllocationSize;
    }

    @Override
    public Integer getSpecifiedAllocationSize() {
        return this.specifiedAllocationSize;
    }

    @Override
    public void setSpecifiedAllocationSize(Integer specifiedAllocationSize) {
        this.setSpecifiedAllocationSize_(specifiedAllocationSize);
        this.xmlGenerator.setAllocationSize(specifiedAllocationSize);
    }

    protected void setSpecifiedAllocationSize_(Integer specifiedAllocationSize) {
        Integer old = this.specifiedAllocationSize;
        this.specifiedAllocationSize = specifiedAllocationSize;
        this.firePropertyChanged("specifiedAllocationSize", old, specifiedAllocationSize);
    }

    @Override
    public int getDefaultAllocationSize() {
        return this.defaultAllocationSize;
    }

    protected void setDefaultAllocationSize(int defaultAllocationSize) {
        int old = this.defaultAllocationSize;
        this.defaultAllocationSize = defaultAllocationSize;
        this.firePropertyChanged("defaultAllocationSize", old, defaultAllocationSize);
    }

    protected int buildDefaultAllocationSize() {
        return 50;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.stringIsEmpty((String)this.name)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_NAME_UNDEFINED", EMPTY_STRING_ARRAY, this, this.getNameTextRange()));
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlGenerator.getValidationTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.xmlGenerator.getNameTextRange());
    }

    @Override
    public boolean isEquivalentTo(JpaNamedContextNode node) {
        return this != node && this.getType() == node.getType() && this.isEquivalentTo((Generator)node);
    }

    protected boolean isEquivalentTo(Generator generator) {
        return Tools.valuesAreEqual((Object)this.name, (Object)generator.getName()) && Tools.valuesAreEqual((Object)this.specifiedAllocationSize, (Object)generator.getSpecifiedAllocationSize()) && Tools.valuesAreEqual((Object)this.specifiedInitialValue, (Object)generator.getSpecifiedInitialValue());
    }

    @Override
    protected Iterable<String> getConnectedXmlCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.schemaTouches(pos)) {
            return this.getCandidateSchemata();
        }
        if (this.catalogTouches(pos)) {
            return this.getCandidateCatalogs();
        }
        return null;
    }

    protected boolean schemaTouches(int pos) {
        return this.xmlGenerator.schemaTouches(pos);
    }

    protected Iterable<String> getCandidateSchemata() {
        SchemaContainer schemaContainer = this.getDbSchemaContainer();
        return schemaContainer != null ? schemaContainer.getSortedSchemaIdentifiers() : EmptyIterable.instance();
    }

    protected boolean catalogTouches(int pos) {
        return this.xmlGenerator.catalogTouches(pos);
    }

    protected Iterable<String> getCandidateCatalogs() {
        Database db = this.getDatabase();
        return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    protected abstract String getSchema();

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    protected abstract String getCatalog();

    public void convertFrom(JavaGenerator javaGenerator) {
        this.setName(javaGenerator.getName());
        this.setSpecifiedInitialValue(javaGenerator.getSpecifiedInitialValue());
        this.setSpecifiedAllocationSize(javaGenerator.getSpecifiedAllocationSize());
    }

    @Override
    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }

    public X getXmlGenerator() {
        return this.xmlGenerator;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

