/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmNamedColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmNamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.orm.XmlNamedColumn;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmNamedColumn<X extends XmlNamedColumn, O extends OrmReadOnlyNamedColumn.Owner>
extends AbstractOrmXmlContextNode
implements OrmNamedColumn {
    protected final O owner;
    protected String specifiedName;
    protected String defaultName;
    protected String columnDefinition;

    protected AbstractOrmNamedColumn(XmlContextNode parent, O owner) {
        this(parent, owner, null);
    }

    protected AbstractOrmNamedColumn(XmlContextNode parent, O owner, X xmlColumn) {
        super(parent);
        this.owner = owner;
        this.setXmlColumn(xmlColumn);
        this.specifiedName = this.buildSpecifiedName();
        this.columnDefinition = this.buildColumnDefinition();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(this.buildSpecifiedName());
        this.setColumnDefinition_(this.buildColumnDefinition());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultName(this.buildDefaultName());
    }

    public abstract X getXmlColumn();

    protected void setXmlColumn(X xmlColumn) {
        if (xmlColumn != null) {
            throw new IllegalArgumentException("this method must be overridden if the XML column is not null: " + xmlColumn);
        }
    }

    protected X getXmlColumnForUpdate() {
        X xmlColumn = this.getXmlColumn();
        return xmlColumn != null ? xmlColumn : this.buildXmlColumn();
    }

    protected abstract X buildXmlColumn();

    protected void removeXmlColumnIfUnset() {
        if (this.getXmlColumn().isUnset()) {
            this.removeXmlColumn();
        }
    }

    protected abstract void removeXmlColumn();

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        if (this.valuesAreDifferent(this.specifiedName, name)) {
            X xmlColumn = this.getXmlColumnForUpdate();
            this.setSpecifiedName_(name);
            xmlColumn.setName(name);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        X xmlColumn = this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected String buildDefaultName() {
        return this.owner.getDefaultColumnName(this);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void setColumnDefinition(String columnDefinition) {
        if (this.valuesAreDifferent(this.columnDefinition, columnDefinition)) {
            X xmlColumn = this.getXmlColumnForUpdate();
            this.setColumnDefinition_(columnDefinition);
            xmlColumn.setColumnDefinition(columnDefinition);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setColumnDefinition_(String columnDefinition) {
        String old = this.columnDefinition;
        this.columnDefinition = columnDefinition;
        this.firePropertyChanged("columnDefinition", old, columnDefinition);
    }

    protected String buildColumnDefinition() {
        X xmlColumn = this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getColumnDefinition();
    }

    protected Column getDbColumn() {
        Table table = this.getDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getName());
    }

    @Override
    public Table getDbTable() {
        return this.owner.resolveDbTable(this.getTable());
    }

    @Override
    public String getTable() {
        return this.owner.getDefaultTableName();
    }

    @Override
    public boolean isResolved() {
        return this.getDbColumn() != null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.buildColumnValidator().validate(messages, reporter);
    }

    protected JptValidator buildColumnValidator() {
        return this.owner.buildColumnValidator(this, this.buildTextRangeResolver());
    }

    protected NamedColumnTextRangeResolver buildTextRangeResolver() {
        return new OrmNamedColumnTextRangeResolver(this);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlColumnTextRange();
        return textRange != null ? textRange : this.owner.getValidationTextRange();
    }

    protected TextRange getXmlColumnTextRange() {
        X xmlColumn = this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.getXmlColumnNameTextRange());
    }

    protected TextRange getXmlColumnNameTextRange() {
        X xmlColumn = this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getNameTextRange();
    }

    @Override
    protected Iterable<String> getConnectedXmlCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.columnNameTouches(pos)) {
            return this.getCandidateColumnNames();
        }
        return null;
    }

    protected boolean columnNameTouches(int pos) {
        X column = this.getXmlColumn();
        return column != null && column.columnNameTouches(pos);
    }

    protected Iterable<String> getCandidateColumnNames() {
        Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    protected void initializeFrom(ReadOnlyNamedColumn oldColumn) {
        this.setSpecifiedName(oldColumn.getSpecifiedName());
        this.setColumnDefinition(oldColumn.getColumnDefinition());
    }

    protected void initializeFromVirtual(ReadOnlyNamedColumn virtualColumn) {
        this.setSpecifiedName(virtualColumn.getName());
        this.setColumnDefinition(virtualColumn.getColumnDefinition());
    }

    public void toString(StringBuilder sb) {
        String table = this.getTable();
        if (table != null) {
            sb.append(table);
            sb.append('.');
        }
        sb.append(this.getName());
    }
}

