/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextNode;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.QueryHint;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaQuery;
import org.eclipse.jpt.jpa.core.context.java.JavaQueryHint;
import org.eclipse.jpt.jpa.core.context.orm.OrmQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlQuery;
import org.eclipse.jpt.jpa.core.resource.orm.XmlQueryHint;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmQuery<X extends XmlQuery>
extends AbstractOrmXmlContextNode
implements OrmQuery {
    protected final X xmlQuery;
    protected String name;
    protected String query;
    protected final AbstractJpaNode.ContextListContainer<OrmQueryHint, XmlQueryHint> hintContainer;

    protected AbstractOrmQuery(XmlContextNode parent, X xmlQuery) {
        super(parent);
        this.xmlQuery = xmlQuery;
        this.name = xmlQuery.getName();
        this.query = this.getUnescapedQuery();
        this.hintContainer = this.buildHintContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.xmlQuery.getName());
        this.setQuery_(this.getUnescapedQuery());
        this.syncHints();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getHints());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName_(name);
        this.xmlQuery.setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String query) {
        this.setQuery_(query);
        this.xmlQuery.setQuery(query);
    }

    protected void setQuery_(String query) {
        String old = this.query;
        this.query = query;
        this.firePropertyChanged("query", old, query);
    }

    protected String getUnescapedQuery() {
        String queryString = this.xmlQuery.getQuery();
        if (StringTools.stringIsNotEmpty((String)queryString)) {
            queryString = ExpressionTools.unescape((CharSequence)queryString, (int[])new int[1]);
        }
        return queryString;
    }

    @Override
    public ListIterable<OrmQueryHint> getHints() {
        return this.hintContainer.getContextElements();
    }

    @Override
    public int getHintsSize() {
        return this.hintContainer.getContextElementsSize();
    }

    @Override
    public OrmQueryHint addHint() {
        return this.addHint(this.getHintsSize());
    }

    @Override
    public OrmQueryHint addHint(int index) {
        XmlQueryHint xmlHint = this.buildXmlQueryHint();
        OrmQueryHint hint = (OrmQueryHint)this.hintContainer.addContextElement(index, xmlHint);
        this.xmlQuery.getHints().add(index, (Object)xmlHint);
        return hint;
    }

    protected XmlQueryHint buildXmlQueryHint() {
        return OrmFactory.eINSTANCE.createXmlQueryHint();
    }

    @Override
    public void removeHint(QueryHint hint) {
        this.removeHint(this.hintContainer.indexOfContextElement((OrmQueryHint)hint));
    }

    @Override
    public void removeHint(int index) {
        this.hintContainer.removeContextElement(index);
        this.xmlQuery.getHints().remove(index);
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        this.hintContainer.moveContextElement(targetIndex, sourceIndex);
        this.xmlQuery.getHints().move(targetIndex, sourceIndex);
    }

    @Override
    public OrmQueryHint getHint(int index) {
        return (OrmQueryHint)this.hintContainer.get(index);
    }

    protected OrmQueryHint buildHint(XmlQueryHint xmlHint) {
        return this.getContextNodeFactory().buildOrmQueryHint(this, xmlHint);
    }

    protected void syncHints() {
        this.hintContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlQueryHint> getXmlHints() {
        return new LiveCloneListIterable(this.xmlQuery.getHints());
    }

    protected AbstractJpaNode.ContextListContainer<OrmQueryHint, XmlQueryHint> buildHintContainer() {
        HintContainer container = new HintContainer();
        container.initialize();
        return container;
    }

    public void convertFrom(JavaQuery javaQuery) {
        this.setName(javaQuery.getName());
        this.setQuery(javaQuery.getQuery());
        for (JavaQueryHint javaQueryHint : javaQuery.getHints()) {
            this.addHint().convertFrom(javaQueryHint);
        }
    }

    @Override
    public void validate(JpaJpqlQueryHelper queryHelper, List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateName(messages);
        this.validateQuery(queryHelper, messages, reporter);
    }

    protected void validateName(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.name)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_NAME_UNDEFINED", EMPTY_STRING_ARRAY, this, this.getNameTextRange()));
        }
    }

    protected void validateQuery(JpaJpqlQueryHelper queryHelper, List<IMessage> messages, IReporter reporter) {
        if (StringTools.stringIsEmpty((String)this.query)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_STATEMENT_UNDEFINED", new String[]{this.name}, this, this.getNameTextRange()));
        } else {
            this.validateQuery_(queryHelper, messages, reporter);
        }
    }

    protected abstract void validateQuery_(JpaJpqlQueryHelper var1, List<IMessage> var2, IReporter var3);

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlQuery.getValidationTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.xmlQuery.getNameTextRange());
    }

    @Override
    public TextRange getQueryTextRange() {
        return this.getValidationTextRange(this.xmlQuery.getQueryTextRange());
    }

    @Override
    public boolean isEquivalentTo(JpaNamedContextNode node) {
        return this != node && this.getType() == node.getType() && this.isEquivalentTo((Query)node);
    }

    protected boolean isEquivalentTo(Query other) {
        return Tools.valuesAreEqual((Object)this.name, (Object)other.getName()) && Tools.valuesAreEqual((Object)this.query, (Object)other.getQuery()) && this.hintsAreEquivalentTo(other);
    }

    protected boolean hintsAreEquivalentTo(Query other) {
        ArrayList hints1 = CollectionTools.list(this.getHints());
        ArrayList hints2 = CollectionTools.list(other.getHints());
        if (hints1.size() != hints2.size()) {
            return false;
        }
        int i = 0;
        while (i < hints1.size()) {
            if (!((OrmQueryHint)hints1.get(i)).isEquivalentTo((QueryHint)hints2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }

    public X getXmlQuery() {
        return this.xmlQuery;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HintContainer
    extends AbstractJpaNode.ContextListContainer<OrmQueryHint, XmlQueryHint> {
        protected HintContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "hints";
        }

        @Override
        protected OrmQueryHint buildContextElement(XmlQueryHint resourceElement) {
            return AbstractOrmQuery.this.buildHint(resourceElement);
        }

        @Override
        protected ListIterable<XmlQueryHint> getResourceElements() {
            return AbstractOrmQuery.this.getXmlHints();
        }

        @Override
        protected XmlQueryHint getResourceElement(OrmQueryHint contextElement) {
            return contextElement.getXmlQueryHint();
        }
    }
}

