/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.Relationship;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.AttributeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmTypeMappingTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.GenericTypeMappingValidator;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmTypeMapping<X extends XmlTypeMapping>
extends AbstractOrmXmlContextNode
implements OrmTypeMapping {
    protected final X xmlTypeMapping;
    protected String class_;
    protected Boolean specifiedMetadataComplete;
    protected boolean overrideMetadataComplete;
    protected String specifiedParentClass;
    protected String defaultParentClass;
    protected String fullyQualifiedParentClass;

    protected AbstractOrmTypeMapping(OrmPersistentType parent, X xmlTypeMapping) {
        super(parent);
        this.xmlTypeMapping = xmlTypeMapping;
        this.class_ = xmlTypeMapping.getClassName();
        this.specifiedMetadataComplete = xmlTypeMapping.getMetadataComplete();
        this.specifiedParentClass = this.buildSpecifiedParentClass();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setClass_(this.xmlTypeMapping.getClassName());
        this.setSpecifiedMetadataComplete_(this.xmlTypeMapping.getMetadataComplete());
        this.setSpecifiedParentClass_(this.buildSpecifiedParentClass());
    }

    @Override
    public void update() {
        super.update();
        this.setOverrideMetadataComplete(this.buildOverrideMetadataComplete());
        this.setDefaultParentClass(this.buildDefaultParentClass());
        this.setFullyQualifiedParentClass(this.buildFullyQualifiedParentClass());
    }

    @Override
    public String getClass_() {
        return this.class_;
    }

    @Override
    public void setClass(String class_) {
        this.setClass_(class_);
        this.xmlTypeMapping.setClassName(class_);
    }

    protected void setClass_(String class_) {
        String old = this.class_;
        this.class_ = class_;
        this.firePropertyChanged("class", old, class_);
    }

    @Override
    public boolean isMetadataComplete() {
        if (this.overrideMetadataComplete) {
            return true;
        }
        return this.specifiedMetadataComplete != null ? this.specifiedMetadataComplete : false;
    }

    @Override
    public Boolean getSpecifiedMetadataComplete() {
        return this.specifiedMetadataComplete;
    }

    @Override
    public void setSpecifiedMetadataComplete(Boolean metadataComplete) {
        this.setSpecifiedMetadataComplete_(metadataComplete);
        this.xmlTypeMapping.setMetadataComplete(metadataComplete);
    }

    protected void setSpecifiedMetadataComplete_(Boolean metadataComplete) {
        Boolean old = this.specifiedMetadataComplete;
        this.specifiedMetadataComplete = metadataComplete;
        this.firePropertyChanged("specifiedMetadataComplete", old, metadataComplete);
    }

    @Override
    public boolean isOverrideMetadataComplete() {
        return this.overrideMetadataComplete;
    }

    protected void setOverrideMetadataComplete(boolean metadataComplete) {
        boolean old = this.overrideMetadataComplete;
        this.overrideMetadataComplete = metadataComplete;
        this.firePropertyChanged("overrideMetadataComplete", old, metadataComplete);
    }

    protected boolean buildOverrideMetadataComplete() {
        return this.getPersistenceUnit().isXmlMappingMetadataComplete();
    }

    @Override
    public String getFullyQualifiedParentClass() {
        return this.fullyQualifiedParentClass;
    }

    protected void setFullyQualifiedParentClass(String parentClass) {
        String old = this.fullyQualifiedParentClass;
        this.fullyQualifiedParentClass = parentClass;
        this.firePropertyChanged("fullyQualifiedParentClass", old, parentClass);
    }

    protected String buildFullyQualifiedParentClass() {
        return this.specifiedParentClass == null ? this.defaultParentClass : this.getEntityMappings().getFullyQualifiedName(this.specifiedParentClass);
    }

    @Override
    public String getParentClass() {
        return this.specifiedParentClass != null ? this.specifiedParentClass : this.defaultParentClass;
    }

    @Override
    public String getSpecifiedParentClass() {
        return this.specifiedParentClass;
    }

    @Override
    public void setSpecifiedParentClass(String parentClass) {
        this.setSpecifiedParentClass_(parentClass);
        this.setSpecifiedParentClassInXml(parentClass);
    }

    protected void setSpecifiedParentClass_(String parentClass) {
        String old = this.specifiedParentClass;
        this.specifiedParentClass = parentClass;
        this.firePropertyChanged("specifiedParentClass", old, parentClass);
    }

    protected void setSpecifiedParentClassInXml(String parentClass) {
    }

    protected String buildSpecifiedParentClass() {
        return null;
    }

    @Override
    public String getDefaultParentClass() {
        return this.defaultParentClass;
    }

    protected void setDefaultParentClass(String parentClass) {
        String old = this.defaultParentClass;
        this.defaultParentClass = parentClass;
        this.firePropertyChanged("defaultParentClass", old, parentClass);
    }

    protected String buildDefaultParentClass() {
        JavaResourceType javaResourceType = this.getJavaResourceType();
        return javaResourceType == null ? null : javaResourceType.getSuperclassQualifiedName();
    }

    protected PersistentType getResolvedParentClass() {
        if (this.fullyQualifiedParentClass == null) {
            return null;
        }
        return this.getPersistenceUnit().getPersistentType(this.fullyQualifiedParentClass);
    }

    @Override
    public JavaTypeMapping getJavaTypeMapping() {
        JavaPersistentType javaType = this.getJavaPersistentType();
        if (javaType == null) {
            return null;
        }
        return javaType.getMappingKey() == this.getKey() ? javaType.getMapping() : null;
    }

    @Override
    public JavaTypeMapping getJavaTypeMappingForDefaults() {
        return this.isMetadataComplete() ? null : this.getJavaTypeMapping();
    }

    @Override
    public OrmPersistentType getParent() {
        return (OrmPersistentType)super.getParent();
    }

    @Override
    public OrmPersistentType getPersistentType() {
        return this.getParent();
    }

    @Override
    public String getName() {
        return this.getPersistentType().getName();
    }

    protected JavaPersistentType getJavaPersistentType() {
        return this.getPersistentType().getJavaPersistentType();
    }

    @Override
    public JavaResourceType getJavaResourceType() {
        JavaPersistentType javaType = this.getJavaPersistentType();
        return javaType == null ? null : javaType.getJavaResourceType();
    }

    protected EntityMappings getEntityMappings() {
        return this.getPersistentType().getParent();
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public void initializeFrom(OrmTypeMapping oldMapping) {
        this.setClass(oldMapping.getClass_());
        this.setSpecifiedMetadataComplete(oldMapping.getSpecifiedMetadataComplete());
        this.setOverrideMetadataComplete(oldMapping.isOverrideMetadataComplete());
    }

    public X getXmlTypeMapping() {
        return this.xmlTypeMapping;
    }

    @Override
    public boolean attributeIsDerivedId(String attributeName) {
        return TypeMappingTools.attributeIsDerivedId(this, attributeName);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getPersistentType().getName());
    }

    @Override
    public String getPrimaryTableName() {
        return null;
    }

    @Override
    public Table getPrimaryDbTable() {
        return null;
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return null;
    }

    @Override
    public Schema getDbSchema() {
        return null;
    }

    @Override
    public boolean attributeMappingKeyAllowed(String attributeMappingKey) {
        return true;
    }

    public Iterable<AttributeMapping> getAttributeMappings() {
        return new TransformationIterable<OrmReadOnlyPersistentAttribute, AttributeMapping>(this.getPersistentType().getAttributes()){

            protected AttributeMapping transform(OrmReadOnlyPersistentAttribute attribute) {
                return attribute.getMapping();
            }
        };
    }

    @Override
    public Iterable<AttributeMapping> getAllAttributeMappings() {
        return new CompositeIterable(this.getAllAttributeMappingsLists());
    }

    protected Iterable<Iterable<AttributeMapping>> getAllAttributeMappingsLists() {
        return new TransformationIterable(this.getInheritanceHierarchy(), TypeMappingTools.ATTRIBUTE_MAPPINGS_TRANSFORMER);
    }

    @Override
    public Iterable<String> getOverridableAttributeNames() {
        return new CompositeIterable(this.getOverridableAttributeNamesLists());
    }

    protected Iterable<Iterable<String>> getOverridableAttributeNamesLists() {
        return new TransformationIterable(this.getAttributeMappings(), AttributeMappingTools.ALL_OVERRIDABLE_ATTRIBUTE_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterable<String> getAllOverridableAttributeNames() {
        return new CompositeIterable(this.getAllOverridableAttributeNamesLists());
    }

    protected Iterable<Iterable<String>> getAllOverridableAttributeNamesLists() {
        return new TransformationIterable(this.getInheritanceHierarchy(), TypeMappingTools.OVERRIDABLE_ATTRIBUTE_NAMES_TRANSFORMER);
    }

    public Iterable<AttributeMapping> getAttributeMappings(final String mappingKey) {
        return new FilteringIterable<AttributeMapping>(this.getAttributeMappings()){

            protected boolean accept(AttributeMapping o) {
                return Tools.valuesAreEqual((Object)o.getKey(), (Object)mappingKey);
            }
        };
    }

    public Iterable<AttributeMapping> getAllAttributeMappings(final String mappingKey) {
        return new FilteringIterable<AttributeMapping>(this.getAllAttributeMappings()){

            protected boolean accept(AttributeMapping o) {
                return Tools.valuesAreEqual((Object)o.getKey(), (Object)mappingKey);
            }
        };
    }

    @Override
    public Iterable<AttributeMapping> getNonTransientAttributeMappings() {
        return new FilteringIterable<AttributeMapping>(this.getAllAttributeMappings()){

            protected boolean accept(AttributeMapping attributeMapping) {
                return attributeMapping.getKey() != "transient";
            }
        };
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        JavaPersistentType javaPersistentType;
        for (AttributeMapping attributeMapping : this.getAttributeMappings()) {
            Column column = attributeMapping.resolveOverriddenColumn(attributeName);
            if (column == null) continue;
            return column;
        }
        if (!this.isMetadataComplete() && (javaPersistentType = this.getJavaPersistentType()) != null) {
            return javaPersistentType.getMapping().resolveOverriddenColumn(attributeName);
        }
        return null;
    }

    @Override
    public Iterable<String> getOverridableAssociationNames() {
        return new CompositeIterable(this.getOverridableAssociationNamesLists());
    }

    protected Iterable<Iterable<String>> getOverridableAssociationNamesLists() {
        return new TransformationIterable(this.getAttributeMappings(), AttributeMappingTools.ALL_OVERRIDABLE_ASSOCIATION_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterable<String> getAllOverridableAssociationNames() {
        return new CompositeIterable(this.getAllOverridableAssociationNamesLists());
    }

    protected Iterable<Iterable<String>> getAllOverridableAssociationNamesLists() {
        return new TransformationIterable(this.getInheritanceHierarchy(), TypeMappingTools.OVERRIDABLE_ASSOCIATION_NAMES_TRANSFORMER);
    }

    @Override
    public Relationship resolveOverriddenRelationship(String attributeName) {
        JavaPersistentType javaPersistentType;
        for (AttributeMapping attributeMapping : this.getAttributeMappings()) {
            Relationship relationship = attributeMapping.resolveOverriddenRelationship(attributeName);
            if (relationship == null) continue;
            return relationship;
        }
        if (!this.isMetadataComplete() && (javaPersistentType = this.getJavaPersistentType()) != null) {
            return javaPersistentType.getMapping().resolveOverriddenRelationship(attributeName);
        }
        return null;
    }

    @Override
    public TypeMapping getSuperTypeMapping() {
        PersistentType superPersistentType = this.getPersistentType().getSuperPersistentType();
        return superPersistentType == null ? null : superPersistentType.getMapping();
    }

    @Override
    public Iterable<TypeMapping> getInheritanceHierarchy() {
        return this.convertToMappings(this.getPersistentType().getInheritanceHierarchy());
    }

    protected Iterable<TypeMapping> getAncestors() {
        return this.convertToMappings(this.getPersistentType().getAncestors());
    }

    protected Iterable<TypeMapping> convertToMappings(Iterable<PersistentType> types) {
        return new TransformationIterable<PersistentType, TypeMapping>(types){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return null;
    }

    @Override
    public boolean isRootEntity() {
        return false;
    }

    @Override
    public Entity getRootEntity() {
        return null;
    }

    public JpaStructureNode getStructureNode(int offset) {
        return this.xmlTypeMapping.containsOffset(offset) ? this.getPersistentType() : null;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlTypeMapping.getSelectionTextRange();
    }

    @Override
    public TextRange getClassTextRange() {
        return this.getValidationTextRange(this.xmlTypeMapping.getClassTextRange());
    }

    @Override
    public TextRange getAttributesTextRange() {
        return this.getValidationTextRange(this.xmlTypeMapping.getAttributesTextRange());
    }

    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.xmlTypeMapping.getNameTextRange());
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlTypeMapping.containsOffset(textOffset);
    }

    @Override
    public DeleteEdit createDeleteEdit() {
        return this.xmlTypeMapping.createDeleteEdit();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.getPersistentType().isFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenameTypeEdit(originalType, newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenameTypeEdit(IType originalType, String newName) {
        return this.xmlTypeMapping.createRenameTypeEdit(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.getPersistentType().isFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newPackage.getElementName())) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.getPersistentType().isIn(originalPackage) ? new SingleElementIterable((Object)this.createRenamePackageEdit(newName)) : EmptyIterable.instance();
    }

    protected ReplaceEdit createRenamePackageEdit(String newName) {
        return this.xmlTypeMapping.createRenamePackageEdit(newName);
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return new CompositeIterable(this.getAttributeMappingGeneratorLists());
    }

    protected Iterable<Iterable<Generator>> getAttributeMappingGeneratorLists() {
        return new TransformationIterable<AttributeMapping, Iterable<Generator>>(this.getAttributeMappings()){

            protected Iterable<Generator> transform(AttributeMapping attributeMapping) {
                return attributeMapping.getGenerators();
            }
        };
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateClass(messages, reporter);
    }

    protected void validateClass(List<IMessage> messages, IReporter reporter) {
        if (StringTools.stringIsEmpty((String)this.class_)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNSPECIFIED_CLASS", this, this.getClassTextRange()));
            return;
        }
        this.buildTypeMappingValidator().validate(messages, reporter);
    }

    protected JptValidator buildTypeMappingValidator() {
        return new GenericTypeMappingValidator(this, this.getJavaResourceType(), this.buildTextRangeResolver());
    }

    protected TypeMappingTextRangeResolver buildTextRangeResolver() {
        return new OrmTypeMappingTextRangeResolver(this);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getPersistenceUnit().validatesAgainstDatabase();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlTypeMapping.getValidationTextRange();
        return textRange != null ? textRange : TextRange.Empty.instance();
    }

    @Override
    public Iterable<String> getXmlCompletionProposals(int pos) {
        Iterable<String> result = super.getXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.classNameTouches(pos)) {
            return this.getCandidateClassNames();
        }
        return null;
    }

    private Iterable<String> getCandidateClassNames() {
        final String packageName = this.getEntityMappings().getPackage();
        if (!StringTools.stringIsEmpty((String)packageName)) {
            return new TransformationIterable<String, String>(this.getFilteredCandidateClassNames(packageName)){

                protected String transform(String className) {
                    return className.substring(packageName.length() + 1);
                }
            };
        }
        return this.getCandidateFullyQualifiedClassNames();
    }

    private Iterable<String> getFilteredCandidateClassNames(final String packageName) {
        return new FilteringIterable<String>(this.getCandidateFullyQualifiedClassNames()){

            protected boolean accept(String className) {
                return className.startsWith(packageName);
            }
        };
    }

    private Iterable<String> getCandidateFullyQualifiedClassNames() {
        return new TransformationIterable<PersistentType, String>(this.getPersistenceUnit().getJavaPersistentTypes()){

            protected String transform(PersistentType pType) {
                return pType.getName();
            }
        };
    }

    private boolean classNameTouches(int pos) {
        return this.getXmlTypeMapping().classNameTouches(pos);
    }
}

