/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.facet;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetDataModelProperties;
import org.eclipse.jpt.jpa.core.libprov.JpaLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.DatabaseIdentifierAdapter;
import org.eclipse.jpt.jpa.db.JptJpaDbPlugin;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.IPropertyChangeListener;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JpaFacetDataModelProvider
extends FacetInstallDataModelProvider
implements JpaFacetDataModelProperties {
    protected static final String EJB_FACET_ID = "jst.ejb";
    protected static final IStatus PLATFORM_NOT_SPECIFIED_STATUS = JpaFacetDataModelProvider.buildErrorStatus(JptCoreMessages.VALIDATE_PLATFORM_NOT_SPECIFIED);
    protected static final IStatus CONNECTION_NOT_CONNECTED_STATUS = JpaFacetDataModelProvider.buildInfoStatus(JptCoreMessages.VALIDATE_CONNECTION_NOT_CONNECTED);
    protected static final IStatus USER_OVERRIDE_DEFAULT_CATALOG_NOT_SPECIFIED_STATUS = JpaFacetDataModelProvider.buildErrorStatus(JptCoreMessages.VALIDATE_DEFAULT_CATALOG_NOT_SPECIFIED);
    protected static final IStatus USER_OVERRIDE_DEFAULT_SCHEMA_NOT_SPECIFIED_STATUS = JpaFacetDataModelProvider.buildErrorStatus(JptCoreMessages.VALIDATE_DEFAULT_SCHEMA_NOT_SPECIFIED);
    private LibraryInstallDelegate defaultLibraryProvider;
    private IPropertyChangeListener libraryProviderListener;
    private ConnectionProfile connectionProfile;
    protected static final Comparator<DataModelPropertyDescriptor> DESCRIPTOR_COMPARATOR = new Comparator<DataModelPropertyDescriptor>(){

        @Override
        public int compare(DataModelPropertyDescriptor dmpd1, DataModelPropertyDescriptor dmpd2) {
            return dmpd1.getPropertyDescription().compareTo(dmpd2.getPropertyDescription());
        }
    };
    protected static final DataModelPropertyDescriptor[] EMPTY_DMPD_ARRAY = new DataModelPropertyDescriptor[0];

    protected JpaFacetDataModelProvider() {
    }

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("JpaFacetDataModelProperties.RUNTIME");
        propertyNames.add("JpaFacetDataModelProperties.PLATFORM");
        propertyNames.add("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
        propertyNames.add("JpaFacetDataModelProperties.CONNECTION");
        propertyNames.add("JpaFacetDataModelProperties.CONNECTION_ACTIVE");
        propertyNames.add("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG");
        propertyNames.add("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG");
        propertyNames.add("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA");
        propertyNames.add("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA");
        propertyNames.add("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES");
        propertyNames.add("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES");
        return propertyNames;
    }

    protected IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return (IFacetedProjectWorkingCopy)this.getProperty("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY");
    }

    protected IProjectFacetVersion getProjectFacetVersion() {
        return (IProjectFacetVersion)this.getProperty("IFacetDataModelPropeties.FACET_VERSION");
    }

    protected IRuntime getRuntime() {
        return (IRuntime)this.getProperty("JpaFacetDataModelProperties.RUNTIME");
    }

    protected JpaPlatformDescription getPlatform() {
        return (JpaPlatformDescription)this.getProperty("JpaFacetDataModelProperties.PLATFORM");
    }

    protected LibraryInstallDelegate getLibraryInstallDelegate() {
        return (LibraryInstallDelegate)this.getProperty("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE");
    }

    protected String getConnectionName() {
        return (String)this.getProperty("JpaFacetDataModelProperties.CONNECTION");
    }

    protected boolean userWantsToOverrideDefaultCatalog() {
        return this.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG");
    }

    protected String getUserOverrideDefaultCatalog() {
        return (String)this.getProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG");
    }

    protected boolean userWantsToOverrideDefaultSchema() {
        return this.getBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA");
    }

    protected String getUserOverrideDefaultSchema() {
        return (String)this.getProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA");
    }

    protected boolean discoverAnnotatedClasses() {
        return this.getBooleanProperty("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES");
    }

    public boolean isPropertyEnabled(String propertyName) {
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG")) {
            return this.connectionIsActive() && this.databaseSupportsCatalogs();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG")) {
            return this.userWantsToOverrideDefaultCatalog();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.connectionIsActive();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.userWantsToOverrideDefaultSchema();
        }
        return super.isPropertyEnabled(propertyName);
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jpt.jpa";
        }
        if (propertyName.equals("JpaFacetDataModelProperties.RUNTIME")) {
            return null;
        }
        if (propertyName.equals("JpaFacetDataModelProperties.PLATFORM")) {
            return this.getDefaultPlatform();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE")) {
            return this.getDefaultLibraryProvider();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
            return this.getDefaultConnection();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION_ACTIVE")) {
            return this.connectionIsActive();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG")) {
            return this.getDefaultUserWantsToOverrideDefaultCatalog();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG")) {
            return this.getDefaultCatalogIdentifier();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.getDefaultUserWantsToOverrideDefaultSchema();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.getDefaultSchemaIdentifier();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES")) {
            return this.getDefaultDiscoverAnnotatedClasses();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES")) {
            return this.getDefaultListAnnotatedClasses();
        }
        return super.getDefaultProperty(propertyName);
    }

    protected abstract JpaPlatformDescription getDefaultPlatform();

    protected LibraryInstallDelegate getDefaultLibraryProvider() {
        if (this.defaultLibraryProvider == null) {
            this.defaultLibraryProvider = this.buildDefaultLibraryProvider();
        } else if (!this.defaultLibraryProvider.getProjectFacetVersion().equals(this.getProjectFacetVersion())) {
            this.defaultLibraryProvider.removeListener(this.libraryProviderListener);
            this.defaultLibraryProvider.dispose();
            this.defaultLibraryProvider = this.buildDefaultLibraryProvider();
        }
        return this.defaultLibraryProvider;
    }

    protected LibraryInstallDelegate buildDefaultLibraryProvider() {
        IFacetedProjectWorkingCopy fpjwc = this.getFacetedProjectWorkingCopy();
        if (fpjwc == null) {
            return null;
        }
        IProjectFacetVersion pfv = this.getProjectFacetVersion();
        if (pfv == null) {
            return null;
        }
        HashMap<String, Object> customEnablementVariables = new HashMap<String, Object>();
        JpaPlatformDescription jpaPlatform = this.getPlatform();
        String jpaPlatformId = jpaPlatform == null ? "" : jpaPlatform.getId();
        customEnablementVariables.put("jpaPlatform", jpaPlatformId);
        customEnablementVariables.put("jpaPlatformDescription", jpaPlatform);
        LibraryInstallDelegate lp = new LibraryInstallDelegate((IFacetedProjectBase)fpjwc, pfv, customEnablementVariables);
        this.libraryProviderListener = this.buildLibraryProviderListener();
        lp.addListener(this.libraryProviderListener, new String[0]);
        return lp;
    }

    protected IPropertyChangeListener buildLibraryProviderListener() {
        return new IPropertyChangeListener(){

            public void propertyChanged(String property, Object oldValue, Object newValue) {
                if (LibraryInstallDelegate.PROP_AVAILABLE_PROVIDERS.equals(property)) {
                    JpaFacetDataModelProvider.this.adjustLibraryProviders();
                }
                JpaFacetDataModelProvider.this.getDataModel().notifyPropertyChange("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE", 1);
            }
        };
    }

    protected abstract String getDefaultConnection();

    protected abstract Boolean getDefaultUserWantsToOverrideDefaultCatalog();

    protected abstract String getDefaultCatalogIdentifier();

    protected abstract Boolean getDefaultUserWantsToOverrideDefaultSchema();

    protected abstract String getDefaultSchemaIdentifier();

    protected abstract Boolean getDefaultDiscoverAnnotatedClasses();

    protected Boolean getDefaultListAnnotatedClasses() {
        return !this.discoverAnnotatedClasses();
    }

    protected boolean runtimeSupportsEjb30() {
        IRuntime runtime = this.getRuntime();
        return runtime != null && runtime.supports(this.getEJB30());
    }

    protected IProjectFacetVersion getEJB30() {
        return ProjectFacetsManager.getProjectFacet((String)EJB_FACET_ID).getVersion("3.0");
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (!propertyName.equals("IFacetDataModelProperties.FACETED_PROJECT_WORKING_COPY")) {
            if (propertyName.equals("IFacetDataModelPropeties.FACET_VERSION")) {
                this.adjustLibraryProviders();
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.PLATFORM", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE", 2);
            } else if (propertyName.equals("JpaFacetDataModelProperties.RUNTIME")) {
                LibraryInstallDelegate lid = this.getLibraryInstallDelegate();
                if (lid != null) {
                    lid.refresh();
                }
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES", 2);
            } else if (propertyName.equals("JpaFacetDataModelProperties.PLATFORM")) {
                this.adjustLibraryProviders();
            } else if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
                this.setBooleanProperty("JpaFacetDataModelProperties.CONNECTION_ACTIVE", this.connectionIsActive());
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.CONNECTION", 4);
                if (propertyValue != null && this.databaseSupportsCatalogs()) {
                    this.setProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", this.getDefaultCatalogIdentifier());
                } else {
                    this.setBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG", false);
                }
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG", 3);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", 4);
                if (propertyValue == null) {
                    this.setBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", false);
                } else {
                    this.setProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", this.getDefaultSchemaIdentifier());
                }
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", 3);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 4);
            } else if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION_ACTIVE")) {
                if (this.propertyValueIsFalse(propertyValue)) {
                    this.setBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG", false);
                }
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG", 3);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", 4);
                if (this.propertyValueIsFalse(propertyValue)) {
                    this.setBooleanProperty("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", false);
                }
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", 3);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 4);
            } else if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG")) {
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", 3);
                if (this.propertyValueIsFalse(propertyValue)) {
                    this.setProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", null);
                }
            } else if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG")) {
                this.setProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", this.getDefaultSchemaIdentifier());
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 2);
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 4);
            } else if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA")) {
                this.model.notifyPropertyChange("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", 3);
                if (this.propertyValueIsFalse(propertyValue)) {
                    this.setProperty("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", null);
                }
            } else if (propertyName.equals("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES")) {
                this.setBooleanProperty("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES", this.propertyValueIsFalse(propertyValue));
            } else if (propertyName.equals("JpaFacetDataModelProperties.LIST_ANNOTATED_CLASSES")) {
                this.setBooleanProperty("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", this.propertyValueIsFalse(propertyValue));
            }
        }
        return ok;
    }

    protected boolean propertyValueIsFalse(Object propertyValue) {
        return !this.propertyValueIsTrue(propertyValue);
    }

    protected boolean propertyValueIsTrue(Object propertyValue) {
        return (Boolean)propertyValue;
    }

    protected void adjustLibraryProviders() {
        LibraryInstallDelegate lid = this.getLibraryInstallDelegate();
        if (lid != null) {
            JpaPlatformDescription jpaPlatform = this.getPlatform();
            String jpaPlatformId = jpaPlatform == null ? "" : jpaPlatform.getId();
            lid.setEnablementContextVariable("jpaPlatform", (Object)jpaPlatformId);
            lid.setEnablementContextVariable("jpaPlatformDescription", (Object)jpaPlatform);
            ArrayList<JpaLibraryProviderInstallOperationConfig> jpaConfigs = new ArrayList<JpaLibraryProviderInstallOperationConfig>();
            JpaLibraryProviderInstallOperationConfig currentJpaConfig = null;
            LibraryProviderOperationConfig config = lid.getLibraryProviderOperationConfig();
            if (config instanceof JpaLibraryProviderInstallOperationConfig) {
                currentJpaConfig = (JpaLibraryProviderInstallOperationConfig)config;
                jpaConfigs.add(currentJpaConfig);
            }
            for (ILibraryProvider lp : lid.getLibraryProviders()) {
                config = lid.getLibraryProviderOperationConfig(lp);
                if (!(config instanceof JpaLibraryProviderInstallOperationConfig) || config.equals(currentJpaConfig)) continue;
                jpaConfigs.add((JpaLibraryProviderInstallOperationConfig)config);
            }
            for (JpaLibraryProviderInstallOperationConfig jpaConfig : jpaConfigs) {
                jpaConfig.setJpaPlatform(this.getPlatform());
            }
        }
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("JpaFacetDataModelProperties.PLATFORM")) {
            return this.buildValidPlatformDescriptors();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
            return this.buildValidConnectionDescriptors();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG")) {
            return this.buildValidCatalogDescriptors();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.buildValidSchemaDescriptors();
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    protected DataModelPropertyDescriptor[] buildValidPlatformDescriptors() {
        Iterable<JpaPlatformDescription> validPlatformDescriptions = this.buildValidPlatformDescriptions();
        TransformationIterable<JpaPlatformDescription, DataModelPropertyDescriptor> validPlatformDescriptors = new TransformationIterable<JpaPlatformDescription, DataModelPropertyDescriptor>(validPlatformDescriptions){

            protected DataModelPropertyDescriptor transform(JpaPlatformDescription desc) {
                return JpaFacetDataModelProvider.this.buildPlatformDescriptor(desc);
            }
        };
        return (DataModelPropertyDescriptor[])ArrayTools.sort((Object[])((DataModelPropertyDescriptor[])ArrayTools.array((Iterable)validPlatformDescriptors, (Object[])EMPTY_DMPD_ARRAY)), DESCRIPTOR_COMPARATOR);
    }

    protected Iterable<JpaPlatformDescription> buildValidPlatformDescriptions() {
        return new FilteringIterable<JpaPlatformDescription>(JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatforms()){

            protected boolean accept(JpaPlatformDescription o) {
                return o.supportsJpaFacetVersion(JpaFacetDataModelProvider.this.getProjectFacetVersion());
            }
        };
    }

    protected DataModelPropertyDescriptor[] buildValidConnectionDescriptors() {
        List<String> connectionNames = this.buildValidConnectionNames();
        DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[connectionNames.size()];
        int i = 0;
        while (i < descriptors.length) {
            descriptors[i] = this.buildConnectionDescriptor(connectionNames.get(i));
            ++i;
        }
        return descriptors;
    }

    protected List<String> buildValidConnectionNames() {
        List connectionNames = CollectionTools.sort((List)CollectionTools.list(this.getConnectionProfileNames()));
        connectionNames.add(0, null);
        return connectionNames;
    }

    protected DataModelPropertyDescriptor[] buildValidCatalogDescriptors() {
        Database db = this.getDatabase();
        return db == null ? EMPTY_DMPD_ARRAY : this.buildDescriptors(this.buildValidCatalogIdentifiers(db));
    }

    protected List<String> buildValidCatalogIdentifiers(Database db) {
        return this.buildValidStrings(db.getSortedCatalogIdentifiers(), this.getDefaultCatalogIdentifier());
    }

    protected DataModelPropertyDescriptor[] buildValidSchemaDescriptors() {
        Database db = this.getDatabase();
        return db == null ? EMPTY_DMPD_ARRAY : this.buildDescriptors(this.buildValidSchemaIdentifiers());
    }

    protected List<String> buildValidSchemaIdentifiers() {
        return this.buildValidStrings(this.getSchemaIdentifiers(), this.getDefaultSchemaIdentifier());
    }

    protected Iterable<String> getSchemaIdentifiers() {
        SchemaContainer sc = this.getSchemaContainer();
        return sc != null ? sc.getSortedSchemaIdentifiers() : EmptyIterable.instance();
    }

    protected List<String> buildValidStrings(Iterable<String> strings, String defaultString) {
        ArrayList validStrings = CollectionTools.list(strings);
        if (defaultString != null && !validStrings.contains(defaultString)) {
            validStrings.add(0, defaultString);
        }
        return validStrings;
    }

    protected DataModelPropertyDescriptor[] buildDescriptors(List<String> strings) {
        DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[strings.size()];
        int i = 0;
        while (i < descriptors.length) {
            descriptors[i] = new DataModelPropertyDescriptor((Object)strings.get(i));
            ++i;
        }
        return descriptors;
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (propertyName.equals("JpaFacetDataModelProperties.PLATFORM")) {
            return this.buildPlatformDescriptor(this.getPlatform());
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
            return this.buildConnectionDescriptor(this.getConnectionName());
        }
        return super.getPropertyDescriptor(propertyName);
    }

    protected DataModelPropertyDescriptor buildPlatformDescriptor(JpaPlatformDescription platform) {
        return new DataModelPropertyDescriptor((Object)platform, platform.getLabel());
    }

    protected String getPlatformLabel(String platformId) {
        return JptJpaCorePlugin.getJpaPlatformManager().getJpaPlatform(platformId).getLabel();
    }

    protected DataModelPropertyDescriptor buildConnectionDescriptor(String connectionName) {
        String description = connectionName == null ? JptCoreMessages.NONE : null;
        return new DataModelPropertyDescriptor((Object)connectionName, description);
    }

    protected SchemaContainer getSchemaContainer() {
        return this.databaseSupportsCatalogs() ? this.getCatalog() : this.getDatabase();
    }

    protected Catalog getCatalog() {
        String name = this.getUserOverrideDefaultCatalog();
        return name == null ? null : this.getCatalog(name);
    }

    protected Catalog getCatalog(String name) {
        Database db = this.getDatabase();
        return db == null ? null : db.getCatalogForIdentifier(name);
    }

    protected boolean databaseSupportsCatalogs() {
        Database db = this.getDatabase();
        return db != null && db.supportsCatalogs();
    }

    protected Database getDatabase() {
        ConnectionProfile cp = this.getConnectionProfile();
        return cp == null ? null : cp.getDatabase();
    }

    protected boolean connectionIsActive() {
        ConnectionProfile cp = this.getConnectionProfile();
        return cp != null && cp.isActive();
    }

    protected ConnectionProfile getConnectionProfile() {
        String name = this.getConnectionName();
        return name == null ? null : this.getConnectionProfile(name);
    }

    protected ConnectionProfile getConnectionProfile(String name) {
        if (this.cachedConnectionProfileIsStale(name)) {
            this.connectionProfile = this.buildConnectionProfile(name);
        }
        return this.connectionProfile;
    }

    protected boolean cachedConnectionProfileIsStale(String name) {
        return this.connectionProfile == null || !this.connectionProfile.getName().equals(name);
    }

    protected ConnectionProfile buildConnectionProfile(String name) {
        return this.getConnectionProfileFactory().buildConnectionProfile(name, DatabaseIdentifierAdapter.Default.instance());
    }

    protected Iterable<String> getConnectionProfileNames() {
        return this.getConnectionProfileFactory().getConnectionProfileNames();
    }

    protected ConnectionProfileFactory getConnectionProfileFactory() {
        return JptJpaDbPlugin.getConnectionProfileFactory();
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("JpaFacetDataModelProperties.PLATFORM")) {
            return this.validatePlatform();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.LIBRARY_PROVIDER_DELEGATE")) {
            return this.getLibraryInstallDelegate().validate();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.CONNECTION")) {
            return this.validateConnection();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG") || propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG")) {
            return this.validateUserOverrideDefaultCatalog();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA") || propertyName.equals("JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA")) {
            return this.validateUserOverrideDefaultSchema();
        }
        if (propertyName.equals("JpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES")) {
            return this.validatePersistentClassManagement();
        }
        return super.validate(propertyName);
    }

    protected IStatus validatePlatform() {
        return this.getPlatform() == null ? PLATFORM_NOT_SPECIFIED_STATUS : OK_STATUS;
    }

    protected IStatus validateConnection() {
        String connectionName = this.getConnectionName();
        return connectionName == null ? OK_STATUS : this.validateNonNullConnection(connectionName);
    }

    protected IStatus validateNonNullConnection(String connectionName) {
        ConnectionProfile cp = this.getConnectionProfile(connectionName);
        if (cp == null) {
            return JpaFacetDataModelProvider.buildErrorStatus(NLS.bind((String)JptCoreMessages.VALIDATE_CONNECTION_INVALID, (Object)connectionName));
        }
        if (!cp.isActive()) {
            return CONNECTION_NOT_CONNECTED_STATUS;
        }
        return OK_STATUS;
    }

    protected IStatus validateUserOverrideDefaultCatalog() {
        if (this.userWantsToOverrideDefaultCatalog() && this.getUserOverrideDefaultCatalog() == null) {
            return USER_OVERRIDE_DEFAULT_CATALOG_NOT_SPECIFIED_STATUS;
        }
        return OK_STATUS;
    }

    protected IStatus validateUserOverrideDefaultSchema() {
        if (this.userWantsToOverrideDefaultSchema() && this.getUserOverrideDefaultSchema() == null) {
            return USER_OVERRIDE_DEFAULT_SCHEMA_NOT_SPECIFIED_STATUS;
        }
        return OK_STATUS;
    }

    protected IStatus validatePersistentClassManagement() {
        return OK_STATUS;
    }

    protected static IStatus buildInfoStatus(String message) {
        return JpaFacetDataModelProvider.buildStatus(1, message);
    }

    protected static IStatus buildErrorStatus(String message) {
        return JpaFacetDataModelProvider.buildStatus(4, message);
    }

    protected static IStatus buildStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.jpt.jpa.core", message);
    }

    public void dispose() {
        super.dispose();
        this.defaultLibraryProvider.removeListener(this.libraryProviderListener);
        this.defaultLibraryProvider.dispose();
    }
}

