/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import org.eclipse.jpt.jpa.core.context.DiscriminatorType;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaNamedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaReadOnlyNamedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaNamedDiscriminatorColumn<A extends DiscriminatorColumnAnnotation, O extends JavaReadOnlyNamedDiscriminatorColumn.Owner>
extends AbstractJavaNamedColumn<A, O>
implements JavaNamedDiscriminatorColumn {
    protected DiscriminatorType specifiedDiscriminatorType = this.buildSpecifiedDiscriminatorType();
    protected DiscriminatorType defaultDiscriminatorType;
    protected Integer specifiedLength = this.buildSpecifiedLength();
    protected int defaultLength = 31;

    protected AbstractJavaNamedDiscriminatorColumn(JavaJpaContextNode parent, O owner) {
        this(parent, owner, null);
    }

    protected AbstractJavaNamedDiscriminatorColumn(JavaJpaContextNode parent, O owner, A columnAnnotation) {
        super(parent, owner, columnAnnotation);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedDiscriminatorType_(this.buildSpecifiedDiscriminatorType());
        this.setSpecifiedLength_(this.buildSpecifiedLength());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultDiscriminatorType(this.buildDefaultDiscriminatorType());
        this.setDefaultLength(this.buildDefaultLength());
    }

    @Override
    public abstract A getColumnAnnotation();

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.specifiedDiscriminatorType != null ? this.specifiedDiscriminatorType : this.defaultDiscriminatorType;
    }

    @Override
    public DiscriminatorType getSpecifiedDiscriminatorType() {
        return this.specifiedDiscriminatorType;
    }

    @Override
    public void setSpecifiedDiscriminatorType(DiscriminatorType discriminatorType) {
        if (this.valuesAreDifferent((Object)this.specifiedDiscriminatorType, (Object)discriminatorType)) {
            this.getColumnAnnotation().setDiscriminatorType(DiscriminatorType.toJavaResourceModel(discriminatorType));
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedDiscriminatorType_(discriminatorType);
        }
    }

    protected void setSpecifiedDiscriminatorType_(DiscriminatorType discriminatorType) {
        DiscriminatorType old = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = discriminatorType;
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)old, (Object)discriminatorType);
    }

    protected DiscriminatorType buildSpecifiedDiscriminatorType() {
        return DiscriminatorType.fromJavaResourceModel(this.getColumnAnnotation().getDiscriminatorType());
    }

    @Override
    public DiscriminatorType getDefaultDiscriminatorType() {
        return this.defaultDiscriminatorType;
    }

    protected void setDefaultDiscriminatorType(DiscriminatorType discriminatorType) {
        DiscriminatorType old = this.defaultDiscriminatorType;
        this.defaultDiscriminatorType = discriminatorType;
        this.firePropertyChanged("defaultDiscriminatorType", (Object)old, (Object)discriminatorType);
    }

    protected DiscriminatorType buildDefaultDiscriminatorType() {
        return ((JavaReadOnlyNamedDiscriminatorColumn.Owner)this.owner).getDefaultDiscriminatorType();
    }

    @Override
    public int getLength() {
        return this.specifiedLength != null ? this.specifiedLength : this.defaultLength;
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer length) {
        if (this.valuesAreDifferent(this.specifiedLength, length)) {
            this.getColumnAnnotation().setLength(length);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedLength_(length);
        }
    }

    protected void setSpecifiedLength_(Integer length) {
        Integer old = this.specifiedLength;
        this.specifiedLength = length;
        this.firePropertyChanged("specifiedLength", old, length);
    }

    protected Integer buildSpecifiedLength() {
        return this.getColumnAnnotation().getLength();
    }

    @Override
    public int getDefaultLength() {
        return this.defaultLength;
    }

    protected void setDefaultLength(int length) {
        int old = this.defaultLength;
        this.defaultLength = length;
        this.firePropertyChanged("defaultLength", old, length);
    }

    protected int buildDefaultLength() {
        return ((JavaReadOnlyNamedDiscriminatorColumn.Owner)this.owner).getDefaultLength();
    }
}

