/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmBaseColumn;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmJoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmJoinColumn
extends AbstractOrmBaseColumn<XmlJoinColumn, OrmReadOnlyJoinColumn.Owner>
implements OrmJoinColumn {
    protected XmlJoinColumn xmlColumn;
    protected String specifiedReferencedColumnName = this.buildSpecifiedReferencedColumnName();
    protected String defaultReferencedColumnName;

    public GenericOrmJoinColumn(XmlContextNode parent, OrmReadOnlyJoinColumn.Owner owner) {
        this(parent, owner, null);
    }

    public GenericOrmJoinColumn(XmlContextNode parent, OrmReadOnlyJoinColumn.Owner owner, XmlJoinColumn xmlColumn) {
        super(parent, owner, xmlColumn);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedReferencedColumnName_(this.buildSpecifiedReferencedColumnName());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultReferencedColumnName(this.buildDefaultReferencedColumnName());
    }

    @Override
    public XmlJoinColumn getXmlColumn() {
        return this.xmlColumn;
    }

    @Override
    protected void setXmlColumn(XmlJoinColumn xmlColumn) {
        this.xmlColumn = xmlColumn;
    }

    @Override
    protected XmlJoinColumn buildXmlColumn() {
        throw new IllegalStateException("XML join column is missing");
    }

    @Override
    protected void removeXmlColumn() {
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName != null ? this.specifiedReferencedColumnName : this.defaultReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String name) {
        this.setSpecifiedReferencedColumnName_(name);
        this.getXmlColumn().setReferencedColumnName(name);
    }

    protected void setSpecifiedReferencedColumnName_(String name) {
        String old = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = name;
        this.firePropertyChanged("specifiedReferencedColumnName", old, name);
    }

    protected String buildSpecifiedReferencedColumnName() {
        XmlJoinColumn joinColumn = this.getXmlColumn();
        return joinColumn == null ? null : joinColumn.getReferencedColumnName();
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String name) {
        String old = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = name;
        this.firePropertyChanged("defaultReferencedColumnName", old, name);
    }

    protected String buildDefaultReferencedColumnName() {
        return MappingTools.buildJoinColumnDefaultReferencedColumnName((ReadOnlyJoinColumn.Owner)((Object)this.owner));
    }

    @Override
    public Table getReferencedColumnDbTable() {
        return ((OrmReadOnlyJoinColumn.Owner)this.owner).getReferencedColumnDbTable();
    }

    protected Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedColumnName());
    }

    @Override
    public boolean referencedColumnIsResolved() {
        return this.getReferencedDbColumn() != null;
    }

    @Override
    public void initializeFrom(ReadOnlyJoinColumn oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedReferencedColumnName(oldColumn.getSpecifiedReferencedColumnName());
    }

    @Override
    public void initializeFromVirtual(ReadOnlyJoinColumn virtualColumn) {
        super.initializeFromVirtual(virtualColumn);
        this.setSpecifiedReferencedColumnName(virtualColumn.getReferencedColumnName());
    }

    @Override
    public TextRange getReferencedColumnNameTextRange() {
        return this.getValidationTextRange(this.xmlColumn.getReferencedColumnNameTextRange());
    }

    @Override
    protected NamedColumnTextRangeResolver buildTextRangeResolver() {
        return new OrmJoinColumnTextRangeResolver(this);
    }

    @Override
    protected Iterable<String> getConnectedXmlCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos)) {
            return this.getCandidateReferencedColumnNames();
        }
        return null;
    }

    protected boolean referencedColumnNameTouches(int pos) {
        XmlJoinColumn joinColumn = this.getXmlColumn();
        return joinColumn != null && joinColumn.referencedColumnNameTouches(pos);
    }

    protected Iterable<String> getCandidateReferencedColumnNames() {
        Table table = ((OrmReadOnlyJoinColumn.Owner)this.owner).getReferencedColumnDbTable();
        return table != null ? table.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }
}

