/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.ArrayList;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.TableGenerator;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmTableGenerator
extends AbstractOrmGenerator<XmlTableGenerator>
implements OrmTableGenerator,
ReadOnlyUniqueConstraint.Owner {
    protected String specifiedTable;
    protected String defaultTable;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedPkColumnName;
    protected String defaultPkColumnName;
    protected String specifiedValueColumnName;
    protected String defaultValueColumnName;
    protected String specifiedPkColumnValue;
    protected String defaultPkColumnValue;
    protected final AbstractJpaNode.ContextListContainer<OrmUniqueConstraint, XmlUniqueConstraint> uniqueConstraintContainer;

    public GenericOrmTableGenerator(XmlContextNode parent, XmlTableGenerator xmlTableGenerator) {
        super(parent, xmlTableGenerator);
        this.specifiedTable = xmlTableGenerator.getTable();
        this.specifiedSchema = xmlTableGenerator.getSchema();
        this.specifiedCatalog = xmlTableGenerator.getCatalog();
        this.specifiedPkColumnName = xmlTableGenerator.getPkColumnName();
        this.specifiedValueColumnName = xmlTableGenerator.getValueColumnName();
        this.specifiedPkColumnValue = xmlTableGenerator.getPkColumnValue();
        this.uniqueConstraintContainer = this.buildUniqueConstraintContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedTable_(((XmlTableGenerator)this.xmlGenerator).getTable());
        this.setSpecifiedSchema_(((XmlTableGenerator)this.xmlGenerator).getSchema());
        this.setSpecifiedCatalog_(((XmlTableGenerator)this.xmlGenerator).getCatalog());
        this.setSpecifiedPkColumnName_(((XmlTableGenerator)this.xmlGenerator).getPkColumnName());
        this.setSpecifiedValueColumnName_(((XmlTableGenerator)this.xmlGenerator).getValueColumnName());
        this.setSpecifiedPkColumnValue_(((XmlTableGenerator)this.xmlGenerator).getPkColumnValue());
        this.syncUniqueConstraints();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultTable(this.buildDefaultTable());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.setDefaultPkColumnName(this.buildDefaultPkColumnName());
        this.setDefaultValueColumnName(this.buildDefaultValueColumnName());
        this.setDefaultPkColumnValue(this.buildDefaultPkColumnValue());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getUniqueConstraints());
    }

    @Override
    protected int buildDefaultInitialValue() {
        return 0;
    }

    @Override
    public String getTable() {
        return this.specifiedTable != null ? this.specifiedTable : this.defaultTable;
    }

    @Override
    public String getSpecifiedTable() {
        return this.specifiedTable;
    }

    @Override
    public void setSpecifiedTable(String table) {
        this.setSpecifiedTable_(table);
        ((XmlTableGenerator)this.xmlGenerator).setTable(table);
    }

    protected void setSpecifiedTable_(String table) {
        String old = this.specifiedTable;
        this.specifiedTable = table;
        this.firePropertyChanged("specifiedTable", old, table);
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    protected void setDefaultTable(String table) {
        String old = this.defaultTable;
        this.defaultTable = table;
        this.firePropertyChanged("defaultTable", old, table);
    }

    protected String buildDefaultTable() {
        return null;
    }

    @Override
    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getTable());
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        this.setSpecifiedSchema_(schema);
        ((XmlTableGenerator)this.xmlGenerator).setSchema(schema);
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        this.setSpecifiedCatalog_(catalog);
        ((XmlTableGenerator)this.xmlGenerator).setCatalog(catalog);
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public String getPkColumnName() {
        return this.specifiedPkColumnName != null ? this.specifiedPkColumnName : this.defaultPkColumnName;
    }

    @Override
    public String getSpecifiedPkColumnName() {
        return this.specifiedPkColumnName;
    }

    @Override
    public void setSpecifiedPkColumnName(String name) {
        this.setSpecifiedPkColumnName_(name);
        ((XmlTableGenerator)this.xmlGenerator).setPkColumnName(name);
    }

    protected void setSpecifiedPkColumnName_(String name) {
        String old = this.specifiedPkColumnName;
        this.specifiedPkColumnName = name;
        this.firePropertyChanged("specifiedPkColumnName", old, name);
    }

    @Override
    public String getDefaultPkColumnName() {
        return this.defaultPkColumnName;
    }

    protected void setDefaultPkColumnName(String name) {
        String old = this.defaultPkColumnName;
        this.defaultPkColumnName = name;
        this.firePropertyChanged("defaultPkColumnName", old, name);
    }

    protected String buildDefaultPkColumnName() {
        return null;
    }

    @Override
    public String getValueColumnName() {
        return this.specifiedValueColumnName != null ? this.specifiedValueColumnName : this.defaultValueColumnName;
    }

    @Override
    public String getSpecifiedValueColumnName() {
        return this.specifiedValueColumnName;
    }

    @Override
    public void setSpecifiedValueColumnName(String name) {
        this.setSpecifiedValueColumnName_(name);
        ((XmlTableGenerator)this.xmlGenerator).setValueColumnName(name);
    }

    protected void setSpecifiedValueColumnName_(String name) {
        String old = this.specifiedValueColumnName;
        this.specifiedValueColumnName = name;
        this.firePropertyChanged("specifiedValueColumnName", old, name);
    }

    @Override
    public String getDefaultValueColumnName() {
        return this.defaultValueColumnName;
    }

    protected void setDefaultValueColumnName(String name) {
        String old = this.defaultValueColumnName;
        this.defaultValueColumnName = name;
        this.firePropertyChanged("defaultValueColumnName", old, name);
    }

    protected String buildDefaultValueColumnName() {
        return null;
    }

    @Override
    public String getPkColumnValue() {
        return this.specifiedPkColumnValue != null ? this.specifiedPkColumnValue : this.defaultPkColumnValue;
    }

    @Override
    public String getSpecifiedPkColumnValue() {
        return this.specifiedPkColumnValue;
    }

    @Override
    public void setSpecifiedPkColumnValue(String value) {
        this.setSpecifiedPkColumnValue_(value);
        ((XmlTableGenerator)this.xmlGenerator).setPkColumnValue(value);
    }

    protected void setSpecifiedPkColumnValue_(String value) {
        String old = this.specifiedPkColumnValue;
        this.specifiedPkColumnValue = value;
        this.firePropertyChanged("specifiedPkColummValue", old, value);
    }

    @Override
    public String getDefaultPkColumnValue() {
        return this.defaultPkColumnValue;
    }

    protected void setDefaultPkColumnValue(String value) {
        String old = this.defaultPkColumnValue;
        this.defaultPkColumnValue = value;
        this.firePropertyChanged("defaultPkColummValue", old, value);
    }

    protected String buildDefaultPkColumnValue() {
        return null;
    }

    public ListIterable<OrmUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraintContainer.getContextElements();
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintContainer.getContextElementsSize();
    }

    @Override
    public OrmUniqueConstraint getUniqueConstraint(int index) {
        return this.uniqueConstraintContainer.getContextElement(index);
    }

    @Override
    public OrmUniqueConstraint addUniqueConstraint() {
        return this.addUniqueConstraint(this.getUniqueConstraintsSize());
    }

    @Override
    public OrmUniqueConstraint addUniqueConstraint(int index) {
        XmlUniqueConstraint xmlConstraint = this.buildXmlUniqueConstraint();
        OrmUniqueConstraint constraint = (OrmUniqueConstraint)this.uniqueConstraintContainer.addContextElement(index, xmlConstraint);
        ((XmlTableGenerator)this.xmlGenerator).getUniqueConstraints().add(index, (Object)xmlConstraint);
        return constraint;
    }

    protected XmlUniqueConstraint buildXmlUniqueConstraint() {
        return OrmFactory.eINSTANCE.createXmlUniqueConstraint();
    }

    @Override
    public void removeUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraintContainer.indexOfContextElement((OrmUniqueConstraint)uniqueConstraint));
    }

    @Override
    public void removeUniqueConstraint(int index) {
        this.uniqueConstraintContainer.removeContextElement(index);
        ((XmlTableGenerator)this.xmlGenerator).getUniqueConstraints().remove(index);
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.uniqueConstraintContainer.moveContextElement(targetIndex, sourceIndex);
        ((XmlTableGenerator)this.xmlGenerator).getUniqueConstraints().move(targetIndex, sourceIndex);
    }

    protected OrmUniqueConstraint buildUniqueConstraint(XmlUniqueConstraint resourceUniqueConstraint) {
        return this.getContextNodeFactory().buildOrmUniqueConstraint(this, this, resourceUniqueConstraint);
    }

    protected void syncUniqueConstraints() {
        this.uniqueConstraintContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlUniqueConstraint> getXmlUniqueConstraints() {
        return new LiveCloneListIterable(((XmlTableGenerator)this.xmlGenerator).getUniqueConstraints());
    }

    protected AbstractJpaNode.ContextListContainer<OrmUniqueConstraint, XmlUniqueConstraint> buildUniqueConstraintContainer() {
        UniqueConstraintContainer container = new UniqueConstraintContainer();
        container.initialize();
        return container;
    }

    @Override
    public Iterable<String> getCandidateUniqueConstraintColumnNames() {
        Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    public Class<TableGenerator> getType() {
        return TableGenerator.class;
    }

    @Override
    protected boolean isEquivalentTo(Generator generator) {
        return super.isEquivalentTo(generator) && this.isEquivalentTo((TableGenerator)generator);
    }

    protected boolean isEquivalentTo(TableGenerator generator) {
        return Tools.valuesAreEqual((Object)this.specifiedTable, (Object)generator.getSpecifiedTable()) && Tools.valuesAreEqual((Object)this.specifiedSchema, (Object)generator.getSpecifiedSchema()) && Tools.valuesAreEqual((Object)this.specifiedCatalog, (Object)generator.getSpecifiedCatalog()) && Tools.valuesAreEqual((Object)this.specifiedPkColumnName, (Object)generator.getSpecifiedPkColumnName()) && Tools.valuesAreEqual((Object)this.specifiedValueColumnName, (Object)generator.getSpecifiedValueColumnName()) && Tools.valuesAreEqual((Object)this.specifiedPkColumnValue, (Object)generator.getSpecifiedPkColumnValue()) && this.uniqueConstrainsAreEquivalentTo(generator);
    }

    protected boolean uniqueConstrainsAreEquivalentTo(TableGenerator generator) {
        ArrayList uniqueConstraints1 = CollectionTools.list(this.getUniqueConstraints());
        ArrayList uniqueConstraints2 = CollectionTools.list(generator.getUniqueConstraints());
        if (uniqueConstraints1.size() != uniqueConstraints2.size()) {
            return false;
        }
        int i = 0;
        while (i < uniqueConstraints1.size()) {
            if (!((OrmUniqueConstraint)uniqueConstraints1.get(i)).isEquivalentTo((UniqueConstraint)uniqueConstraints2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void convertFrom(JavaTableGenerator javaTableGenerator) {
        super.convertFrom(javaTableGenerator);
        this.setSpecifiedTable(javaTableGenerator.getSpecifiedTable());
        this.setSpecifiedSchema(javaTableGenerator.getSpecifiedSchema());
        this.setSpecifiedCatalog(javaTableGenerator.getSpecifiedCatalog());
        this.setSpecifiedPkColumnName(javaTableGenerator.getSpecifiedPkColumnName());
        this.setSpecifiedValueColumnName(javaTableGenerator.getSpecifiedValueColumnName());
        this.setSpecifiedPkColumnValue(javaTableGenerator.getSpecifiedPkColumnValue());
        for (JavaUniqueConstraint javaUniqueConstraint : javaTableGenerator.getUniqueConstraints()) {
            this.addUniqueConstraint().convertFrom(javaUniqueConstraint);
        }
    }

    @Override
    public Iterable<String> getXmlCompletionProposals(int pos) {
        Iterable result = super.getXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (OrmUniqueConstraint constraint : this.getUniqueConstraints()) {
            result = constraint.getXmlCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected Iterable<String> getConnectedXmlCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.tableTouches(pos)) {
            return this.getCandidateTables();
        }
        if (this.pkColumnNameTouches(pos)) {
            return this.getCandidateColumnNames();
        }
        if (this.valueColumnNameTouches(pos)) {
            return this.getCandidateColumnNames();
        }
        return null;
    }

    protected boolean tableTouches(int pos) {
        return ((XmlTableGenerator)this.xmlGenerator).tableTouches(pos);
    }

    protected Iterable<String> getCandidateTables() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedTableIdentifiers() : EmptyIterable.instance();
    }

    protected boolean pkColumnNameTouches(int pos) {
        return ((XmlTableGenerator)this.xmlGenerator).pkColumnNameTouches(pos);
    }

    protected Iterable<String> getCandidateColumnNames() {
        Table table = this.getDbTable();
        return table != null ? table.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    protected boolean valueColumnNameTouches(int pos) {
        return ((XmlTableGenerator)this.xmlGenerator).valueColumnNameTouches(pos);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UniqueConstraintContainer
    extends AbstractJpaNode.ContextListContainer<OrmUniqueConstraint, XmlUniqueConstraint> {
        protected UniqueConstraintContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "uniqueConstraints";
        }

        @Override
        protected OrmUniqueConstraint buildContextElement(XmlUniqueConstraint resourceElement) {
            return GenericOrmTableGenerator.this.buildUniqueConstraint(resourceElement);
        }

        @Override
        protected ListIterable<XmlUniqueConstraint> getResourceElements() {
            return GenericOrmTableGenerator.this.getXmlUniqueConstraints();
        }

        @Override
        protected XmlUniqueConstraint getResourceElement(OrmUniqueConstraint contextElement) {
            return contextElement.getXmlUniqueConstraint();
        }
    }
}

