/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.XmlFile;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlDefinition;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmXml
extends AbstractOrmXmlContextNode
implements OrmXml {
    protected final JpaXmlResource xmlResource;
    protected JptResourceType resourceType;
    protected OrmXmlDefinition definition;
    protected EntityMappings root;

    public GenericOrmXml(MappingFileRef parent, JpaXmlResource xmlResource) {
        super(parent);
        this.checkXmlResource(xmlResource);
        this.xmlResource = xmlResource;
        this.resourceType = xmlResource.getResourceType();
        this.definition = this.buildDefinition();
        XmlEntityMappings xmlEntityMappings = (XmlEntityMappings)xmlResource.getRootObject();
        if (xmlEntityMappings != null) {
            this.root = this.buildRoot(xmlEntityMappings);
        }
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncEntityMappings();
    }

    protected void syncEntityMappings() {
        this.syncEntityMappings(true);
    }

    @Override
    public void update() {
        super.update();
        this.updateEntityMappings();
    }

    protected void updateEntityMappings() {
        this.syncEntityMappings(false);
    }

    protected void syncEntityMappings(boolean sync) {
        XmlEntityMappings oldXmlEntityMappings = this.root == null ? null : this.root.getXmlEntityMappings();
        XmlEntityMappings newXmlEntityMappings = (XmlEntityMappings)this.xmlResource.getRootObject();
        JptResourceType newResourceType = this.xmlResource.getResourceType();
        if ((oldXmlEntityMappings != newXmlEntityMappings || newXmlEntityMappings == null || this.valuesAreDifferent(this.resourceType, newResourceType)) && this.root != null) {
            this.unregisterRootStructureNode();
            this.root.dispose();
            this.setRoot(null);
        }
        this.resourceType = newResourceType;
        this.definition = this.buildDefinition();
        if (newXmlEntityMappings != null) {
            if (this.root == null) {
                this.setRoot(this.buildRoot(newXmlEntityMappings));
            } else if (sync) {
                this.root.synchronizeWithResourceModel();
            } else {
                this.root.update();
                this.registerRootStructureNode();
            }
        }
    }

    @Override
    public JptResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public OrmXmlDefinition getMappingFileDefinition() {
        return this.definition;
    }

    protected OrmXmlDefinition buildDefinition() {
        return (OrmXmlDefinition)this.getJpaPlatform().getResourceDefinition(this.resourceType);
    }

    @Override
    public EntityMappings getRoot() {
        return this.root;
    }

    protected void setRoot(EntityMappings root) {
        EntityMappings old = this.root;
        this.root = root;
        this.firePropertyChanged("root", old, root);
    }

    protected EntityMappings buildRoot(XmlEntityMappings xmlEntityMappings) {
        return this.getContextNodeFactory().buildEntityMappings(this, xmlEntityMappings);
    }

    @Override
    public Iterable<Query> getMappingFileQueries() {
        return this.root != null ? this.root.getMappingFileQueries() : EmptyIterable.instance();
    }

    @Override
    public Iterable<Generator> getMappingFileGenerators() {
        return this.root != null ? this.root.getMappingFileGenerators() : EmptyIterable.instance();
    }

    protected void checkXmlResource(JpaXmlResource resource) {
        if (resource == null) {
            throw new NullPointerException();
        }
        if (!resource.getContentType().isKindOf(JptJpaCorePlugin.MAPPING_FILE_CONTENT_TYPE)) {
            throw new IllegalArgumentException("Content type is not 'mapping file': " + (Object)((Object)resource));
        }
    }

    @Override
    public MappingFileRef getParent() {
        return (MappingFileRef)super.getParent();
    }

    @Override
    public IResource getResource() {
        return this.xmlResource.getFile();
    }

    protected JpaFile getJpaFile() {
        return this.getJpaFile(this.xmlResource.getFile());
    }

    @Override
    public boolean isLatestSupportedVersion() {
        return XmlFile.XmlFile_.isLatestSupportedVersion(this);
    }

    @Override
    public boolean isIn(IFolder folder) {
        IResource member = folder.findMember(this.xmlResource.getFile().getName());
        IFile file = this.xmlResource.getFile();
        return Tools.valuesAreEqual((Object)member, (Object)file);
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    public Class<OrmXml> getType() {
        return OrmXml.class;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        if (this.root != null && this.root.containsOffset(textOffset)) {
            return this.root.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public void dispose() {
        if (this.root != null) {
            JpaFile jpaFile = this.getJpaFile();
            if (jpaFile != null) {
                this.unregisterRootStructureNode();
            }
            this.root.dispose();
        }
    }

    protected void registerRootStructureNode() {
        this.getJpaFile().addRootStructureNode((Object)this.xmlResource, this.root);
    }

    protected void unregisterRootStructureNode() {
        this.getJpaFile().removeRootStructureNode((Object)this.xmlResource, this.root);
    }

    @Override
    public JpaXmlResource getXmlResource() {
        return this.xmlResource;
    }

    @Override
    public OrmPersistentType getPersistentType(String name) {
        return this.root == null ? null : this.root.getPersistentType(name);
    }

    public Iterable<OrmPersistentType> getPersistentTypes() {
        return this.root != null ? this.root.getPersistentTypes() : EmptyIterable.instance();
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(IType type) {
        return this.root != null ? this.root.createDeleteTypeEdits(type) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return this.root != null ? this.root.createRenameTypeEdits(originalType, newName) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.root != null ? this.root.createMoveTypeEdits(originalType, newPackage) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.root != null ? this.root.createRenamePackageEdits(originalPackage, newName) : EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.root != null) {
            this.root.validate(messages, reporter);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return TextRange.Empty.instance();
    }
}

