/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.persistence;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.Persistence2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPersistence
extends AbstractPersistenceXmlContextNode
implements Persistence2_0 {
    protected final XmlPersistence xmlPersistence;
    protected PersistenceUnit persistenceUnit;

    public GenericPersistence(PersistenceXml parent, XmlPersistence xmlPersistence) {
        super(parent);
        this.xmlPersistence = xmlPersistence;
        this.initializePersistenceUnits();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncPersistenceUnits();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getPersistenceUnits());
    }

    @Override
    public ListIterable<PersistenceUnit> getPersistenceUnits() {
        return this.persistenceUnit == null ? EmptyListIterable.instance() : this.getPersistenceUnits_();
    }

    protected ListIterable<PersistenceUnit> getPersistenceUnits_() {
        return new SingleElementListIterable((Object)this.persistenceUnit);
    }

    @Override
    public int getPersistenceUnitsSize() {
        return this.persistenceUnit == null ? 0 : 1;
    }

    @Override
    public PersistenceUnit getPersistenceUnit(int index) {
        if (index != 0 || this.persistenceUnit == null) {
            throw this.buildIOOBE(index);
        }
        return this.persistenceUnit;
    }

    protected IndexOutOfBoundsException buildIOOBE(int index) {
        return new IndexOutOfBoundsException("index: " + index);
    }

    @Override
    public PersistenceUnit addPersistenceUnit() {
        return this.addPersistenceUnit(this.getPersistenceUnitsSize());
    }

    @Override
    public PersistenceUnit addPersistenceUnit(int index) {
        if (index != 0 || this.persistenceUnit != null) {
            throw this.buildIOOBE(index);
        }
        XmlPersistenceUnit xmlPersistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        this.persistenceUnit = this.buildPersistenceUnit(xmlPersistenceUnit);
        this.xmlPersistence.getPersistenceUnits().add((Object)xmlPersistenceUnit);
        this.fireItemAdded("persistenceUnits", index, this.persistenceUnit);
        this.persistenceUnit.setName(this.getJpaProject().getName());
        return this.persistenceUnit;
    }

    @Override
    public void removePersistenceUnit(PersistenceUnit pu) {
        if (pu != this.persistenceUnit) {
            throw new IllegalArgumentException("Invalid persistence unit: " + pu);
        }
        this.removePersistenceUnit(0);
    }

    @Override
    public void removePersistenceUnit(int index) {
        if (index != 0 || this.persistenceUnit == null) {
            throw this.buildIOOBE(index);
        }
        PersistenceUnit old = this.persistenceUnit;
        this.persistenceUnit.dispose();
        this.persistenceUnit = null;
        this.xmlPersistence.getPersistenceUnits().remove(index);
        this.fireItemRemoved("persistenceUnits", index, old);
    }

    protected void initializePersistenceUnits() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        if (xmlPersistenceUnit != null) {
            this.persistenceUnit = this.buildPersistenceUnit(xmlPersistenceUnit);
        }
    }

    protected void syncPersistenceUnits() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        if (this.persistenceUnit == null) {
            if (xmlPersistenceUnit != null) {
                this.addPersistenceUnit_(this.buildPersistenceUnit(xmlPersistenceUnit));
            }
        } else if (xmlPersistenceUnit == null) {
            this.removePersistenceUnit_();
        } else if (this.persistenceUnit.getXmlPersistenceUnit() == xmlPersistenceUnit) {
            this.persistenceUnit.synchronizeWithResourceModel();
        } else {
            this.removePersistenceUnit_();
            this.addPersistenceUnit_(this.buildPersistenceUnit(xmlPersistenceUnit));
        }
    }

    protected XmlPersistenceUnit getXmlPersistenceUnit() {
        EList<XmlPersistenceUnit> xmlPersistenceUnits = this.xmlPersistence.getPersistenceUnits();
        return xmlPersistenceUnits.isEmpty() ? null : (XmlPersistenceUnit)xmlPersistenceUnits.get(0);
    }

    protected void addPersistenceUnit_(PersistenceUnit pu) {
        this.persistenceUnit = pu;
        this.fireItemAdded("persistenceUnits", 0, pu);
    }

    protected void removePersistenceUnit_() {
        PersistenceUnit old = this.persistenceUnit;
        this.persistenceUnit = null;
        old.dispose();
        this.fireItemRemoved("persistenceUnits", 0, old);
    }

    protected PersistenceUnit buildPersistenceUnit(XmlPersistenceUnit xmlPersistenceUnit) {
        return this.getContextNodeFactory().buildPersistenceUnit(this, xmlPersistenceUnit);
    }

    @Override
    public void initializeMetamodel() {
        for (PersistenceUnit pu : this.getPersistenceUnits()) {
            ((PersistenceUnit2_0)pu).initializeMetamodel();
        }
    }

    @Override
    public IStatus synchronizeMetamodel(IProgressMonitor monitor) {
        for (PersistenceUnit pu : this.getPersistenceUnits()) {
            IStatus status = ((PersistenceUnit2_0)pu).synchronizeMetamodel(monitor);
            if (status.getSeverity() != 8) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    @Override
    public void disposeMetamodel() {
        for (PersistenceUnit pu : this.getPersistenceUnits()) {
            ((PersistenceUnit2_0)pu).disposeMetamodel();
        }
    }

    @Override
    public XmlPersistence getXmlPersistence() {
        return this.xmlPersistence;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlPersistence == null ? false : this.xmlPersistence.containsOffset(textOffset);
    }

    @Override
    public PersistenceXml getParent() {
        return (PersistenceXml)super.getParent();
    }

    @Override
    public PersistenceXml getPersistenceXml() {
        return this.getParent();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlPersistence.getValidationTextRange();
        return textRange != null ? textRange : this.getPersistenceXml().getValidationTextRange();
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    public Class<Persistence> getType() {
        return Persistence.class;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (PersistenceUnit pu : this.getPersistenceUnits()) {
            if (!pu.containsOffset(textOffset)) continue;
            return pu.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlPersistence.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        for (PersistenceUnit pu : this.getPersistenceUnits()) {
            pu.dispose();
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateVersion(messages);
        this.checkForMultiplePersistenceUnits(messages);
        this.validatePersistenceUnit(messages, reporter);
    }

    protected void validateVersion(List<IMessage> messages) {
        if (!this.getLatestDocumentVersion().equals(this.xmlPersistence.getVersion())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(4, "XML_VERSION_NOT_LATEST", this, this.xmlPersistence.getVersionTextRange()));
        }
    }

    protected String getLatestDocumentVersion() {
        return this.getJpaPlatform().getMostRecentSupportedResourceType(JptJpaCorePlugin.PERSISTENCE_XML_CONTENT_TYPE).getVersion();
    }

    protected void checkForMultiplePersistenceUnits(List<IMessage> messages) {
        if (this.xmlPersistence.getPersistenceUnits().size() > 1) {
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PERSISTENCE_MULTIPLE_PERSISTENCE_UNITS", this, this.getValidationTextRange()));
        }
    }

    protected void validatePersistenceUnit(List<IMessage> messages, IReporter reporter) {
        if (this.persistenceUnit == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_NO_PERSISTENCE_UNIT", this, this.getValidationTextRange()));
            return;
        }
        this.persistenceUnit.validate(messages, reporter);
    }
}

