/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.prefs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.internal.platform.JpaPlatformManagerImpl;
import org.eclipse.jpt.jpa.core.platform.GenericPlatform;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class JpaPreferencesManager {
    private final IProject project;
    private static volatile boolean flushPreferences = true;
    protected static final String JPA_PLATFORM_PREF_KEY = "org.eclipse.jpt.core.platform";
    @Deprecated
    public static final String DEFAULT_JPA_PLATFORM_PREF_KEY = "defaultJpaPlatform";
    public static final String DEFAULT_JPA_PLATFORM_1_0_PREF_KEY = "defaultJpaPlatform_" + JpaFacet.VERSION_1_0.getVersionString();
    public static final String DEFAULT_JPA_PLATFORM_2_0_PREF_KEY = "defaultJpaPlatform_" + JpaFacet.VERSION_2_0.getVersionString();
    public static final String DISCOVER_ANNOTATED_CLASSES = "org.eclipse.jpt.jpa.core.discoverAnnotatedClasses";
    protected static final String LEGACY_DISCOVER_ANNOTATED_CLASSES = "org.eclipse.jpt.core.discoverAnnotatedClasses";
    public static final String METAMODEL_SOURCE_FOLDER_NAME = "org.eclipse.jpt.jpa.core.metamodelSourceFolderName";
    protected static final String LEGACY_METAMODEL_SOURCE_FOLDER_NAME = "org.eclipse.jpt.core.metamodelSourceFolderName";

    public static void clearWorkspacePreferences() throws BackingStoreException {
        JpaPreferencesManager.getLegacyWorkspacePreferences().clear();
    }

    private static IEclipsePreferences getLegacyPreferences(IScopeContext context) {
        return context.getNode("org.eclipse.jpt.core");
    }

    private static IEclipsePreferences getPreferences(IScopeContext context) {
        return context.getNode("org.eclipse.jpt.jpa.core");
    }

    public static IEclipsePreferences getLegacyWorkspacePreferences() {
        return JpaPreferencesManager.getLegacyPreferences(InstanceScope.INSTANCE);
    }

    public static IEclipsePreferences getLegacyDefaultPreferences() {
        return JpaPreferencesManager.getLegacyPreferences(DefaultScope.INSTANCE);
    }

    public static IEclipsePreferences getDefaultPreferences() {
        return JpaPreferencesManager.getPreferences(DefaultScope.INSTANCE);
    }

    public static void initializeDefaultPreferences() {
        IEclipsePreferences node = JpaPreferencesManager.getDefaultPreferences();
        JpaPlatformDescription defaultPlatform_1_0 = JpaPlatformManagerImpl.instance().getDefaultJpaPlatform(JpaFacet.VERSION_1_0);
        if (defaultPlatform_1_0 == null) {
            defaultPlatform_1_0 = GenericPlatform.VERSION_1_0;
        }
        node.put(DEFAULT_JPA_PLATFORM_1_0_PREF_KEY, defaultPlatform_1_0.getId());
        JpaPlatformDescription defaultPlatform_2_0 = JpaPlatformManagerImpl.instance().getDefaultJpaPlatform(JpaFacet.VERSION_2_0);
        if (defaultPlatform_2_0 == null) {
            defaultPlatform_2_0 = GenericPlatform.VERSION_2_0;
        }
        node.put(DEFAULT_JPA_PLATFORM_2_0_PREF_KEY, defaultPlatform_2_0.getId());
    }

    protected static String getLegacyWorkspacePreference(String key, String defaultValue) {
        String value = JpaPreferencesManager.getLegacyWorkspacePreferences().get(key, defaultValue);
        return StringTools.stringIsEmpty((String)value) ? defaultValue : value;
    }

    protected static String getLegacyWorkspacePreference(String key) {
        return JpaPreferencesManager.getLegacyWorkspacePreferences().get(key, null);
    }

    public static void setLegacyWorkspacePreference(String key, String value) {
        IEclipsePreferences wkspPrefs = JpaPreferencesManager.getLegacyWorkspacePreferences();
        if (value == null) {
            wkspPrefs.remove(key);
        } else {
            wkspPrefs.put(key, value);
        }
        JpaPreferencesManager.flush(wkspPrefs);
    }

    protected static boolean getLegacyWorkspacePreference(String key, boolean defaultBooleanValue) {
        return JpaPreferencesManager.getLegacyWorkspacePreferences().getBoolean(key, defaultBooleanValue);
    }

    public static void setLegacyWorkspacePreference(String key, boolean booleanValue) {
        IEclipsePreferences wkspPrefs = JpaPreferencesManager.getLegacyWorkspacePreferences();
        wkspPrefs.putBoolean(key, booleanValue);
        JpaPreferencesManager.flush(wkspPrefs);
    }

    public static void removeLegacyWorkspacePreference(String key) {
        IEclipsePreferences wkspPrefs = JpaPreferencesManager.getLegacyWorkspacePreferences();
        wkspPrefs.remove(key);
        JpaPreferencesManager.flush(wkspPrefs);
    }

    private static void doNotFlushPreferences() {
        flushPreferences = false;
    }

    private static void flush(IEclipsePreferences prefs) {
        if (flushPreferences) {
            new PreferencesFlushJob(prefs).schedule();
        }
    }

    public JpaPreferencesManager(IProject project) {
        if (project == null) {
            throw new RuntimeException("Project is null");
        }
        this.project = project;
    }

    protected String getLegacyPreference(String key) {
        String preferenceValue = this.getLegacyProjectPreference(key);
        if (preferenceValue == null) {
            preferenceValue = JpaPreferencesManager.getLegacyWorkspacePreference(key);
        }
        return preferenceValue;
    }

    protected String getLegacyPreference(String key, String defaultValue) {
        String preferenceValue = this.getLegacyPreference(key);
        if (StringTools.stringIsEmpty((String)preferenceValue)) {
            return defaultValue;
        }
        return preferenceValue;
    }

    public IEclipsePreferences getLegacyProjectPreferences() {
        return JpaPreferencesManager.getLegacyPreferences((IScopeContext)new ProjectScope(this.project));
    }

    public void clearProjectPreferences() {
        this.clearLegacyProjectPreferences(JPA_PLATFORM_PREF_KEY, DISCOVER_ANNOTATED_CLASSES, METAMODEL_SOURCE_FOLDER_NAME, LEGACY_DISCOVER_ANNOTATED_CLASSES, LEGACY_METAMODEL_SOURCE_FOLDER_NAME);
    }

    public void clearLegacyProjectPreferences(String ... preferenceKeys) {
        IEclipsePreferences projectPrefs = this.getLegacyProjectPreferences();
        String[] stringArray = preferenceKeys;
        int n = preferenceKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String preferenceKey = stringArray[n2];
            projectPrefs.remove(preferenceKey);
            ++n2;
        }
        JpaPreferencesManager.flush(projectPrefs);
    }

    protected String getLegacyProjectPreference(String key, String defaultValue) {
        String value = this.getLegacyProjectPreferences().get(key, defaultValue);
        return StringTools.stringIsEmpty((String)value) ? defaultValue : value;
    }

    protected String getLegacyProjectPreference(String key) {
        return this.getLegacyProjectPreferences().get(key, null);
    }

    protected void setLegacyProjectPreference(String key, String value) {
        IEclipsePreferences projectPrefs = this.getLegacyProjectPreferences();
        if (value == null) {
            projectPrefs.remove(key);
        } else {
            projectPrefs.put(key, value);
        }
        JpaPreferencesManager.flush(projectPrefs);
    }

    protected boolean getLegacyProjectPreference(String key, boolean defaultBooleanValue) {
        return this.getLegacyProjectPreferences().getBoolean(key, defaultBooleanValue);
    }

    protected void setLegacyProjectPreference(String key, boolean booleanValue) {
        IEclipsePreferences projectPrefs = this.getLegacyProjectPreferences();
        projectPrefs.putBoolean(key, booleanValue);
        JpaPreferencesManager.flush(projectPrefs);
    }

    protected void removeLegacyProjectPreference(String key) {
        IEclipsePreferences projectPrefs = this.getLegacyProjectPreferences();
        projectPrefs.remove(key);
        JpaPreferencesManager.flush(projectPrefs);
    }

    public String getJpaPlatformId() {
        return this.getLegacyProjectPreference(JPA_PLATFORM_PREF_KEY, GenericPlatform.VERSION_1_0.getId());
    }

    public void setJpaPlatformId(String jpaPlatformId) {
        this.setLegacyProjectPreference(JPA_PLATFORM_PREF_KEY, jpaPlatformId);
    }

    public boolean getDiscoverAnnotatedClasses() {
        if (this.getLegacyProjectPreference(DISCOVER_ANNOTATED_CLASSES, null) != null) {
            return this.getLegacyProjectPreference(DISCOVER_ANNOTATED_CLASSES, false);
        }
        return this.getLegacyProjectPreference(LEGACY_DISCOVER_ANNOTATED_CLASSES, false);
    }

    public void setDiscoverAnnotatedClasses(boolean discoverAnnotatedClasses) {
        this.setLegacyProjectPreference(DISCOVER_ANNOTATED_CLASSES, discoverAnnotatedClasses);
    }

    public String getMetamodelSourceFolderName() {
        String metamodelSourceFolderName = this.getLegacyProjectPreference(METAMODEL_SOURCE_FOLDER_NAME, null);
        if (metamodelSourceFolderName != null) {
            return metamodelSourceFolderName;
        }
        return this.getLegacyProjectPreference(LEGACY_METAMODEL_SOURCE_FOLDER_NAME, null);
    }

    public void setMetamodelSourceFolderName(String metamodelSourceFolderName) {
        this.setLegacyProjectPreference(METAMODEL_SOURCE_FOLDER_NAME, metamodelSourceFolderName);
        if (metamodelSourceFolderName == null) {
            this.setLegacyProjectPreference(LEGACY_METAMODEL_SOURCE_FOLDER_NAME, null);
        }
    }

    protected IProject getProject() {
        return this.project;
    }

    private static class PreferencesFlushJob
    extends Job {
        private final IEclipsePreferences prefs;

        PreferencesFlushJob(IEclipsePreferences prefs) {
            super(NLS.bind((String)JptCoreMessages.PREFERENCES_FLUSH_JOB_NAME, (Object)prefs.absolutePath()));
            this.prefs = prefs;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.prefs.flush();
            }
            catch (BackingStoreException ex) {
                JptJpaCorePlugin.log(ex);
            }
            return Status.OK_STATUS;
        }
    }
}

