/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.GenericJpaPlatform;
import org.eclipse.jpt.jpa.core.internal.refactoring.AbstractJpaDeleteTypeParticipant;
import org.eclipse.jpt.jpa.core.internal.refactoring.JpaCoreRefactoringMessages;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.text.edits.DeleteEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaDeletePackageOrFolderParticipant
extends AbstractJpaDeleteTypeParticipant
implements ISharableParticipant {
    protected final Collection<IFolder> folders = new ArrayList<IFolder>();
    protected final Collection<IPackageFragment> packageFragments = new ArrayList<IPackageFragment>();
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public String getName() {
        return JpaCoreRefactoringMessages.JPA_DELETE_PACKAGE_OR_FOLDER_REFACTORING_PARTICIPANT_NAME;
    }

    protected boolean initialize(Object element) {
        if (this.getProcessor() instanceof RenameProcessor) {
            return false;
        }
        this.addElement(element, (RefactoringArguments)this.getArguments());
        return true;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        if (element instanceof IFolder) {
            IJavaElement javaElement = JavaCore.create((IFolder)((IFolder)element));
            if (javaElement != null) {
                if (javaElement.getElementType() == 3) {
                    this.addPackageFragmentRoot((IPackageFragmentRoot)javaElement);
                } else {
                    this.addPackageFragment((IPackageFragment)javaElement);
                }
            } else {
                this.addFolder((IFolder)element);
            }
        } else {
            this.addPackageFragment((IPackageFragment)element);
        }
    }

    protected void addFolder(IFolder folder) {
        this.folders.add(folder);
    }

    protected void addPackageFragmentRoot(IPackageFragmentRoot root) {
        if (JDTTools.packageFragmentRootIsSourceFolder((IPackageFragmentRoot)root)) {
            IJavaElement[] iJavaElementArray = JDTTools.getChildren((IParent)root);
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                this.addPackageFragment((IPackageFragment)child);
                ++n2;
            }
        }
    }

    protected void addPackageFragment(IPackageFragment packageFragment) {
        this.packageFragments.add(packageFragment);
        HashSet<IType> allDeletedTypes = new HashSet<IType>();
        JpaDeletePackageOrFolderParticipant.addAffectedTypes(allDeletedTypes, packageFragment);
        for (IType deletedType : allDeletedTypes) {
            this.addType(deletedType);
        }
    }

    static void addAffectedTypes(Collection<IType> types, IPackageFragment fragment) {
        try {
            if (fragment.containsJavaResources()) {
                ICompilationUnit[] cunits = fragment.getCompilationUnits();
                IType type = null;
                int i = 0;
                while (i < cunits.length) {
                    type = cunits[i].findPrimaryType();
                    if (type != null) {
                        types.add(type);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    @Override
    protected Iterable<DeleteEdit> createPersistenceXmlDeleteEdits(final PersistenceUnit persistenceUnit) {
        return new CompositeIterable(new Iterable[]{super.createPersistenceXmlDeleteEdits(persistenceUnit), new CompositeIterable((Iterable)new TransformationIterable<IFile, Iterable<DeleteEdit>>(this.getMappingFilesOnClasspath(persistenceUnit.getJpaProject())){

            protected Iterable<DeleteEdit> transform(IFile file) {
                return persistenceUnit.createDeleteMappingFileEdits(file);
            }
        })});
    }

    protected Iterable<IFile> getMappingFilesOnClasspath(JpaProject jpaProject) {
        final IJavaProject javaProject = jpaProject.getJavaProject();
        return new FilteringIterable<IFile>((Iterable)new CompositeIterable(new Iterable[]{this.getPossibleMappingFilesInFolders(), this.getPossibleMappingFilesInPackageFragments()})){

            protected boolean accept(IFile file) {
                if (javaProject.isOnClasspath((IResource)file)) {
                    IContentType contentType = GenericJpaPlatform.getContentType(file);
                    return contentType != null && contentType.isKindOf(JptJpaCorePlugin.MAPPING_FILE_CONTENT_TYPE);
                }
                return false;
            }
        };
    }

    protected Iterable<IFile> getPossibleMappingFilesInFolders() {
        ArrayList<IFile> files = new ArrayList<IFile>();
        FolderResourceProxyVisitor visitor = new FolderResourceProxyVisitor(files);
        for (IFolder folder : this.folders) {
            visitor.visitFolder(folder);
        }
        return files;
    }

    protected Iterable<IFile> getPossibleMappingFilesInPackageFragments() {
        return new CompositeIterable((Iterable)new TransformationIterable<IPackageFragment, Iterable<IFile>>(this.packageFragments){

            protected Iterable<IFile> transform(IPackageFragment packageFragment) {
                return JpaDeletePackageOrFolderParticipant.getNonJavaFiles(packageFragment);
            }
        });
    }

    protected static Iterable<IFile> getNonJavaFiles(IPackageFragment packageFragment) {
        Object[] resources;
        ArrayList<IFile> files = new ArrayList<IFile>();
        Object[] objectArray = resources = JpaDeletePackageOrFolderParticipant.getNonJavaResources(packageFragment);
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Object resource = objectArray[n2];
            if (resource instanceof IFile) {
                files.add((IFile)resource);
            }
            ++n2;
        }
        return files;
    }

    protected static Object[] getNonJavaResources(IPackageFragment packageFragment) {
        try {
            return packageFragment.getNonJavaResources();
        }
        catch (JavaModelException e) {
            JptJpaCorePlugin.log(e);
            return EMPTY_OBJECT_ARRAY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FolderResourceProxyVisitor
    implements IResourceProxyVisitor {
        private Collection<IFile> files;

        protected FolderResourceProxyVisitor(Collection<IFile> files) {
            this.files = files;
        }

        protected void visitFolder(IFolder folder) {
            try {
                folder.accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean visit(IResourceProxy resource) {
            switch (resource.getType()) {
                case 2: {
                    return true;
                }
                case 1: {
                    this.files.add((IFile)resource.requestResource());
                    return false;
                }
            }
            return false;
        }
    }
}

