/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.resource.java.NamedColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceNamedColumnAnnotation
extends SourceAnnotation
implements NamedColumnAnnotation {
    private DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.buildNameDeclarationAdapter();
    private AnnotationElementAdapter<String> nameAdapter = this.buildNameAdapter();
    private String name;
    private TextRange nameTextRange;
    private DeclarationAnnotationElementAdapter<String> columnDefinitionDeclarationAdapter = this.buildColumnDefinitionDeclarationAdapter();
    private AnnotationElementAdapter<String> columnDefinitionAdapter = this.buildColumnDefinitionAdapter();
    private String columnDefinition;
    private TextRange columnDefinitionTextRange;

    protected SourceNamedColumnAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        this(parent, element, daa, (AnnotationAdapter)new ElementAnnotationAdapter(element, daa));
    }

    protected SourceNamedColumnAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.nameTextRange = this.buildNameTextRange(astRoot);
        this.columnDefinition = this.buildColumnDefinition(astRoot);
        this.columnDefinitionTextRange = this.buildColumnDefinitionTextRange(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.nameTextRange = this.buildNameTextRange(astRoot);
        this.syncColumnDefinition(this.buildColumnDefinition(astRoot));
        this.columnDefinitionTextRange = this.buildColumnDefinitionTextRange(astRoot);
    }

    @Override
    public boolean isSpecified() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.nameTextRange;
    }

    private TextRange buildNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public boolean nameTouches(int pos) {
        return this.textRangeTouches(this.nameTextRange, pos);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return this.buildStringElementAdapter(this.getNameElementName());
    }

    private AnnotationElementAdapter<String> buildNameAdapter() {
        return this.buildStringElementAdapter(this.nameDeclarationAdapter);
    }

    protected abstract String getNameElementName();

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void setColumnDefinition(String columnDefinition) {
        if (this.attributeValueHasChanged(this.columnDefinition, columnDefinition)) {
            this.columnDefinition = columnDefinition;
            this.columnDefinitionAdapter.setValue((Object)columnDefinition);
        }
    }

    private void syncColumnDefinition(String astColumnDefinition) {
        String old = this.columnDefinition;
        this.columnDefinition = astColumnDefinition;
        this.firePropertyChanged("columnDefinition", old, astColumnDefinition);
    }

    private String buildColumnDefinition(CompilationUnit astRoot) {
        return (String)this.columnDefinitionAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getColumnDefinitionTextRange() {
        return this.columnDefinitionTextRange;
    }

    private TextRange buildColumnDefinitionTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.columnDefinitionDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildColumnDefinitionDeclarationAdapter() {
        return this.buildStringElementAdapter(this.getColumnDefinitionElementName());
    }

    private AnnotationElementAdapter<String> buildColumnDefinitionAdapter() {
        return this.buildStringElementAdapter(this.columnDefinitionDeclarationAdapter);
    }

    protected abstract String getColumnDefinitionElementName();

    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.columnDefinition == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

