/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.prefs;

import org.eclipse.core.resources.IProject;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.internal.prefs.JpaPreferencesManager;

public class JpaEntityGenPreferencesManager
extends JpaPreferencesManager {
    private static final String ENTITY_GEN_PREFIX = "entitygen.";
    public static final String DEFAULT_PACKAGE = "DEFAULT_PACKAGE";
    public static final String DEFAULT_PACKAGE_NAME = "model";

    public static String getDefaultPackageWorkspacePreference() {
        return JpaEntityGenPreferencesManager.getLegacyWorkspacePreference(JpaEntityGenPreferencesManager.appendPrefix(DEFAULT_PACKAGE), JpaEntityGenPreferencesManager.getDefaultDefaultPackage());
    }

    public static void setDefaultPackageWorkspacePreference(String value) {
        if (StringTools.stringsAreEqual((String)value, (String)JpaEntityGenPreferencesManager.getDefaultDefaultPackage())) {
            JpaEntityGenPreferencesManager.removeLegacyWorkspacePreference(JpaEntityGenPreferencesManager.appendPrefix(DEFAULT_PACKAGE));
        } else {
            JpaEntityGenPreferencesManager.setLegacyWorkspacePreference(JpaEntityGenPreferencesManager.appendPrefix(DEFAULT_PACKAGE), value);
        }
    }

    public static String getDefaultDefaultPackage() {
        return DEFAULT_PACKAGE_NAME;
    }

    private static String appendPrefix(String prefId) {
        return ENTITY_GEN_PREFIX + prefId;
    }

    public JpaEntityGenPreferencesManager(IProject project) {
        super(project);
    }

    public String getDefaultPackagePreference() {
        return this.getLegacyPreference(JpaEntityGenPreferencesManager.appendPrefix(DEFAULT_PACKAGE), JpaEntityGenPreferencesManager.getDefaultDefaultPackage());
    }

    public void setDefaultPackagePreference(String preferenceValue) {
        if (StringTools.stringsAreEqual((String)preferenceValue, (String)JpaEntityGenPreferencesManager.getDefaultPackageWorkspacePreference())) {
            this.removeDefaultPackagePreference();
        } else {
            this.setLegacyProjectPreference(JpaEntityGenPreferencesManager.appendPrefix(DEFAULT_PACKAGE), preferenceValue);
        }
    }

    public void removeDefaultPackagePreference() {
        this.removeLegacyProjectPreference(JpaEntityGenPreferencesManager.appendPrefix(DEFAULT_PACKAGE));
    }
}

