/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.prefs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.jpa.core.internal.prefs.JpaPreferencesManager;

public class JpaValidationPreferencesManager
extends JpaPreferencesManager {
    private static final String PROBLEM_PREFIX = "problem.";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String INFO = "info";
    public static final String IGNORE = "ignore";
    public static final int NO_SEVERITY_PREFERENCE = -1;
    public static final String WORKSPACE_PREFERENCES_OVERRIDEN = "workspace_preferences_overriden";

    public static String getProblemPreference(IResource targetObject, String messageId) {
        return new JpaValidationPreferencesManager(targetObject.getProject()).getLegacyPreference(JpaValidationPreferencesManager.appendProblemPrefix(messageId));
    }

    public static int getProblemSeverityPreference(IResource targetObject, String messageId) {
        String problemPreference = JpaValidationPreferencesManager.getProblemPreference(targetObject, messageId);
        if (problemPreference == null) {
            return -1;
        }
        if (problemPreference.equals(ERROR)) {
            return 1;
        }
        if (problemPreference.equals(WARNING)) {
            return 2;
        }
        if (problemPreference.equals(INFO)) {
            return 4;
        }
        return -1;
    }

    public static String getWorkspaceLevelProblemPreference(String messageId) {
        return JpaValidationPreferencesManager.getLegacyWorkspacePreference(JpaValidationPreferencesManager.appendProblemPrefix(messageId));
    }

    public static void setWorkspaceLevelProblemPreference(String messageId, String problemPreference) {
        JpaValidationPreferencesManager.setLegacyWorkspacePreference(JpaValidationPreferencesManager.appendProblemPrefix(messageId), problemPreference);
    }

    protected static String appendProblemPrefix(String messageId) {
        return PROBLEM_PREFIX + messageId;
    }

    public JpaValidationPreferencesManager(IProject project) {
        super(project);
    }

    public boolean problemIsNotIgnored(String messageId) {
        return !this.problemIsIgnored(messageId);
    }

    public boolean problemIsIgnored(String messageId) {
        return Tools.valuesAreEqual((Object)this.getLegacyPreference(JpaValidationPreferencesManager.appendProblemPrefix(messageId)), (Object)IGNORE);
    }

    public boolean projectHasSpecificOptions() {
        return this.getLegacyProjectPreference(WORKSPACE_PREFERENCES_OVERRIDEN, false);
    }

    public void setProjectHasSpecificOptions(boolean booleanValue) {
        this.setLegacyProjectPreference(WORKSPACE_PREFERENCES_OVERRIDEN, booleanValue);
    }

    public String getProjectLevelProblemPreference(String messageId) {
        return this.getLegacyProjectPreference(JpaValidationPreferencesManager.appendProblemPrefix(messageId));
    }

    public void setProjectLevelProblemPreference(String messageId, String problemPreference) {
        this.setLegacyProjectPreference(JpaValidationPreferencesManager.appendProblemPrefix(messageId), problemPreference);
    }
}

