/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.ddlgen;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.common.ui.internal.dialogs.OptionalMessageDialog;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.OutputMode;
import org.eclipse.jpt.jpa.eclipselink.core.internal.ddlgen.EclipseLinkDDLGenerator;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiPlugin;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.ddlgen.wizards.GenerateDDLWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkDDLGeneratorUi {
    private final JpaProject project;
    private static final String CR = StringTools.CR;

    public static void generate(JpaProject project) {
        new EclipseLinkDDLGeneratorUi(project).generate();
    }

    protected EclipseLinkDDLGeneratorUi(JpaProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        this.project = project;
    }

    protected void generate() {
        int returnCode;
        PersistenceUnit persistenceUnit = (PersistenceUnit)this.getPersistenceUnits().iterator().next();
        String puName = persistenceUnit.getName();
        GenerateDDLWizard wizard = new GenerateDDLWizard(this.project);
        WizardDialog wizardDialog = new WizardDialog(this.getCurrentShell(), (IWizard)wizard);
        wizardDialog.create();
        if (wizard.getPageCount() > 0 && (returnCode = wizardDialog.open()) == 1) {
            return;
        }
        OutputMode outputMode = wizard.getOutputMode();
        if (outputMode != OutputMode.sql_script && !this.displayGeneratingDDLWarning()) {
            return;
        }
        WorkspaceJob job = this.buildGenerateDDLJob(puName, this.project, outputMode);
        job.schedule();
    }

    protected WorkspaceJob buildGenerateDDLJob(String puName, JpaProject project, OutputMode outputMode) {
        return new GenerateDDLJob(puName, project, outputMode);
    }

    private Shell getCurrentShell() {
        return Display.getCurrent().getActiveShell();
    }

    private boolean displayGeneratingDDLWarning() {
        if (!OptionalMessageDialog.isDialogEnabled((String)"dontShowOverwriteExistingTablesFromClasses.warning")) {
            return true;
        }
        OverwriteConfirmerDialog dialog = new OverwriteConfirmerDialog(this.getCurrentShell());
        return dialog.open() == 2;
    }

    protected JpaPlatform getPlatform() {
        return this.project.getJpaPlatform();
    }

    protected ListIterable<PersistenceUnit> getPersistenceUnits() {
        return this.getPersistence().getPersistenceUnits();
    }

    protected Persistence getPersistence() {
        return this.project.getRootContextNode().getPersistenceXml().getPersistence();
    }

    protected static class GenerateDDLJob
    extends WorkspaceJob {
        private final String puName;
        private final JpaProject project;
        private final OutputMode outputMode;

        public GenerateDDLJob(String puName, JpaProject project, OutputMode outputMode) {
            super(EclipseLinkUiMessages.ECLIPSELINK_GENERATE_TABLES_JOB);
            this.puName = puName;
            this.project = project;
            this.outputMode = outputMode;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)EclipseLinkUiMessages.ECLIPSELINK_GENERATE_TABLES_TASK, (int)1);
            try {
                this.ddlGeneratorGenerate(this.puName, this.project, this.outputMode, (IProgressMonitor)sm.newChild(1));
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
            catch (RuntimeException re) {
                this.logException(re);
            }
            return Status.OK_STATUS;
        }

        protected void ddlGeneratorGenerate(String puName, JpaProject project, OutputMode outputMode, IProgressMonitor monitor) {
            EclipseLinkDDLGenerator.generate((String)puName, (JpaProject)project, (OutputMode)outputMode, (IProgressMonitor)monitor);
        }

        protected void logException(RuntimeException re) {
            String msg = re.getMessage();
            String message = msg == null ? re.toString() : msg;
            this.displayError(message);
            JptJpaEclipseLinkUiPlugin.log(re);
        }

        private void displayError(final String message) {
            SWTUtil.syncExec((Runnable)new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)GenerateDDLJob.this.getShell(), (String)EclipseLinkUiMessages.EclipseLinkDDLGeneratorUi_error, (String)message);
                }
            });
        }

        protected Shell getShell() {
            Shell[] shells;
            Shell shell;
            Display display = Display.getCurrent();
            Shell shell2 = shell = display == null ? null : display.getActiveShell();
            if (shell == null && display != null && (shells = display.getShells()).length > 0) {
                shell = shells[0];
            }
            return shell;
        }
    }

    static class OverwriteConfirmerDialog
    extends OptionalMessageDialog {
        private static final String ID = "dontShowOverwriteExistingTablesFromClasses.warning";

        OverwriteConfirmerDialog(Shell parent) {
            super(ID, parent, EclipseLinkUiMessages.EclipseLinkDDLGeneratorUi_generatingDDLWarningTitle, NLS.bind((String)EclipseLinkUiMessages.EclipseLinkDDLGeneratorUi_generatingDDLWarningMessage, (Object)CR, (Object)(String.valueOf(CR) + CR)), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
        }
    }
}

