/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.dialogs;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmPersistentType;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiPlugin;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.details.MappingUiDefinition;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddVirtualAttributeDialog
extends StatusDialog {
    private EclipseLinkOrmPersistentType persistentType;
    protected Text nameText;
    protected ComboViewer mappingCombo;
    protected Text attributeTypeText;
    private Button attributeTypeBrowseButton;
    private OrmPersistentAttribute addedAttribute;

    public AddVirtualAttributeDialog(Shell parentShell, EclipseLinkOrmPersistentType persistentType) {
        super(parentShell);
        this.persistentType = persistentType;
        this.setTitle(EclipseLinkUiMessages.AddVirtualAttributeDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createLabel(composite, 1, EclipseLinkUiMessages.AddVirtualAttributeDialog_nameLabel);
        this.nameText = this.createText(composite, 2);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddVirtualAttributeDialog.this.validate();
            }
        });
        this.createLabel(composite, 1, EclipseLinkUiMessages.AddVirtualAttributeDialog_mappingLabel);
        this.mappingCombo = new ComboViewer(this.createCombo(composite, 2));
        this.mappingCombo.getCombo().setFocus();
        this.mappingCombo.setContentProvider((IContentProvider)this.buildComboContentProvider());
        this.mappingCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((MappingUiDefinition)element).getLabel();
            }
        });
        this.mappingCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddVirtualAttributeDialog.this.validate();
            }
        });
        this.mappingCombo.setInput((Object)this.getJpaPlatformUi());
        this.createLabel(composite, 1, EclipseLinkUiMessages.AddVirtualAttributeDialog_attributeTypeLabel);
        this.attributeTypeText = this.createAttributeTypeText(composite);
        this.attributeTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddVirtualAttributeDialog.this.validate();
            }
        });
        this.attributeTypeBrowseButton = this.createButton(composite, JptUiMessages.General_browse);
        this.attributeTypeBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IType type = AddVirtualAttributeDialog.this.chooseType();
                if (type != null) {
                    AddVirtualAttributeDialog.this.attributeTypeText.setText(type.getFullyQualifiedName('$'));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.nameText.setFocus();
        AddVirtualAttributeDialog.applyDialogFont((Control)dialogArea);
        this.validate();
        return dialogArea;
    }

    protected JpaPlatformUi getJpaPlatformUi() {
        return (JpaPlatformUi)this.getJpaProject().getJpaPlatform().getAdapter(JpaPlatformUi.class);
    }

    protected IStructuredContentProvider buildComboContentProvider() {
        return new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ArrayTools.array((Iterator)CollectionTools.sort((Iterator)((JpaPlatformUi)inputElement).attributeMappingUiDefinitions(AddVirtualAttributeDialog.this.getJptResourceType()), AddVirtualAttributeDialog.this.getProvidersComparator()));
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected JptResourceType getJptResourceType() {
        return this.persistentType.getResourceType();
    }

    protected Comparator<MappingUiDefinition<?, ?>> getProvidersComparator() {
        return new Comparator<MappingUiDefinition<?, ?>>(){

            @Override
            public int compare(MappingUiDefinition<?, ?> item1, MappingUiDefinition<?, ?> item2) {
                String displayString1 = item1.getLabel();
                String displayString2 = item2.getLabel();
                return Collator.getInstance().compare(displayString1, displayString2);
            }
        };
    }

    private Label createLabel(Composite container, int span, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Text createText(Composite container, int span) {
        Text text = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = 250;
        text.setLayoutData((Object)gd);
        return text;
    }

    private Text createAttributeTypeText(Composite container) {
        JavaTypeCompletionProcessor javaTypeCompletionProcessor = new JavaTypeCompletionProcessor(true, false);
        IPackageFragmentRoot pfr = this.getPackageFragmentRoot();
        if (pfr != null) {
            javaTypeCompletionProcessor.setPackageFragment(pfr.getPackageFragment(""));
        }
        Text text = new Text(container, 2052);
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)javaTypeCompletionProcessor);
        text.setLayoutData((Object)this.getFieldGridData());
        return text;
    }

    protected GridData getFieldGridData() {
        int margin = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = 200 + margin;
        data.horizontalIndent = margin;
        data.grabExcessHorizontalSpace = true;
        return data;
    }

    protected IPackageFragmentRoot getPackageFragmentRoot() {
        try {
            return this.getJpaProject().getJavaProject().getPackageFragmentRoots()[0];
        }
        catch (JavaModelException ex) {
            JptJpaEclipseLinkUiPlugin.log(ex);
            return null;
        }
    }

    private Combo createCombo(Composite container, int span) {
        Combo combo = new Combo(container, 2060);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    private Button createButton(Composite container, String text) {
        Button button = new Button(container, 0);
        button.setText(text);
        return button;
    }

    protected JpaProject getJpaProject() {
        return this.persistentType.getJpaProject();
    }

    public String getAttributeType() {
        return this.attributeTypeText.getText();
    }

    public String getAttributeName() {
        return this.nameText.getText();
    }

    public String getMappingKey() {
        StructuredSelection selection = (StructuredSelection)this.mappingCombo.getSelection();
        return selection.isEmpty() ? null : ((MappingUiDefinition)selection.getFirstElement()).getKey();
    }

    protected IType chooseType() {
        SelectionDialog typeSelectionDialog;
        IJavaElement[] elements = new IJavaElement[]{this.getJpaProject().getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)256, (boolean)false, (String)this.getAttributeType());
        }
        catch (JavaModelException e) {
            JptJpaEclipseLinkUiPlugin.log(e);
            throw new RuntimeException(e);
        }
        typeSelectionDialog.setTitle(JptUiMessages.AddPersistentClassDialog_classDialog_title);
        typeSelectionDialog.setMessage(JptUiMessages.AddPersistentClassDialog_classDialog_message);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    private void validate() {
        if (StringTools.stringIsEmpty((String)this.getAttributeName())) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", EclipseLinkUiMessages.AddVirtualAttributeDialog_noNameError));
            return;
        }
        if (this.getMappingKey() == null) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", EclipseLinkUiMessages.AddVirtualAttributeDialog_noMappingKeyError));
            return;
        }
        if (StringTools.stringIsEmpty((String)this.getAttributeType())) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", EclipseLinkUiMessages.AddVirtualAttributeDialog_noAttributeTypeError));
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    protected void okPressed() {
        this.addedAttribute = this.persistentType.addVirtualAttribute(this.getAttributeName(), this.getMappingKey(), this.getAttributeType());
        super.okPressed();
    }

    public OrmPersistentAttribute openAndReturnAttribute() {
        super.open();
        return this.addedAttribute;
    }
}

