/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.entity.data.model;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.JpaRootContextNode;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiPlugin;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.entity.data.model.DynamicEntityField;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.entity.data.operation.NewDynamicEntityClassOperation;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.data.model.IEntityDataModelProperties;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicEntityDataModelProvider
extends NewJavaClassDataModelProvider
implements IEntityDataModelProperties {
    private static final String DOT = ".";

    public IDataModelOperation getDefaultOperation() {
        return new NewDynamicEntityClassOperation(this.getDataModel());
    }

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IEntityDataModelProperties.ENTITY");
        propertyNames.add("IEntityDataModelProperties.XML_NAME");
        propertyNames.add("IEntityDataModelProperties.ENTITY_NAME");
        propertyNames.add("IEntityDataModelProperties.TABLE_NAME_DEFAULT");
        propertyNames.add("IEntityDataModelProperties.TABLE_NAME");
        propertyNames.add("IEntityDataModelProperties.ENTITY_FIELDS");
        propertyNames.add("IEntityDataModelProperties.PK_FIELDS");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IEntityDataModelProperties.ENTITY")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IEntityDataModelProperties.XML_NAME")) {
            return "";
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_NAME")) {
            return this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        }
        if (propertyName.equals("IEntityDataModelProperties.TABLE_NAME_DEFAULT")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IEntityDataModelProperties.TABLE_NAME")) {
            return this.getStringProperty("NewJavaClassDataModel.CLASS_NAME");
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_FIELDS")) {
            return new ArrayList();
        }
        if (propertyName.equals("IEntityDataModelProperties.PK_FIELDS")) {
            return new ArrayList();
        }
        if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT")) {
            return this.getJavaPackageFragmentRoots();
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (ok && ("IArtifactEditOperationDataModelProperties.PROJECT_NAME".equals(propertyName) || "IEntityDataModelProperties.XML_SUPPORT".equals(propertyName))) {
            this.model.notifyPropertyChange("IEntityDataModelProperties.XML_NAME", 4);
        }
        return ok;
    }

    protected IPackageFragmentRoot[] getJavaPackageFragmentRoots() {
        IJavaProject javaProject;
        JpaProject jpaProject = this.getJpaProject();
        IPackageFragmentRoot[] packRoots = new IPackageFragmentRoot[]{};
        ArrayList<IPackageFragmentRoot> rootList = new ArrayList<IPackageFragmentRoot>();
        if (jpaProject != null && (javaProject = jpaProject.getJavaProject()) != null) {
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = packRoots = javaProject.getAllPackageFragmentRoots();
                int n = packRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root.getKind() == 1) {
                        rootList.add(root);
                    }
                    ++n2;
                }
                packRoots = new IPackageFragmentRoot[rootList.size()];
                rootList.toArray(packRoots);
            }
            catch (JavaModelException e) {
                JptJpaEclipseLinkUiPlugin.log(e);
            }
        }
        return packRoots;
    }

    public IStatus validate(String propertyName) {
        IStatus result = super.validate(propertyName);
        if (propertyName.equals("NewJavaClassDataModel.JAVA_PACKAGE")) {
            return this.validateJavaPackage(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("IEntityDataModelProperties.XML_NAME")) {
            return this.validateXmlName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals("IEntityDataModelProperties.ENTITY_FIELDS")) {
            return this.validateFieldsList((ArrayList)this.getProperty(propertyName));
        }
        if (propertyName.equals("IEntityDataModelProperties.PK_FIELDS")) {
            return this.validatePrimaryKeyFieldsList((ArrayList)this.getProperty(propertyName));
        }
        return result;
    }

    private IStatus validateJavaPackage(String packName) {
        if (packName == null || packName.equals("")) {
            return new Status(2, "org.eclipse.jpt.jpa.eclipselink.ui", EclipseLinkUiMessages.DynamicEntityClassWizardPage_defaultPackageWarning);
        }
        IStatus javaStatus = JavaConventions.validatePackageName((String)packName, (String)"1.5", (String)"1.5");
        if (javaStatus.getSeverity() == 4) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACAKGE_NAME_INVALID) + javaStatus.getMessage();
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (javaStatus.getSeverity() == 2) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACKAGE_NAME_WARNING) + javaStatus.getMessage();
            return WTPCommonPlugin.createWarningStatus((String)msg);
        }
        return Status.OK_STATUS;
    }

    private IStatus validateXmlName(String xmlName) {
        IProject project = this.getTargetProject();
        if (project != null) {
            JpaXmlResource ormXmlResource;
            JpaXmlResource jpaXmlResource = ormXmlResource = StringTools.stringIsEmpty((String)xmlName) ? null : this.getOrmXmlResource(xmlName);
            if (ormXmlResource == null) {
                return new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", EclipseLinkUiMessages.DynamicEntityClassWizardPage_invalidXMLName);
            }
            if (this.getJpaProject().getJpaFile(ormXmlResource.getFile()).getRootStructureNodesSize() == 0) {
                return new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", EclipseLinkUiMessages.DynamicEntityClassWizardPage_xmlNotListedError);
            }
        }
        return Status.OK_STATUS;
    }

    protected JpaXmlResource getOrmXmlResource(String xmlName) {
        return this.getJpaProject() == null ? null : this.getJpaProject().getMappingFileXmlResource((IPath)new Path(xmlName));
    }

    private IStatus validateFieldsList(ArrayList<DynamicEntityField> fields) {
        if (fields != null && !fields.isEmpty()) {
            boolean hasDuplicates = this.hasDuplicatesInEntityFields(fields);
            if (hasDuplicates) {
                return new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", EclipseLinkUiMessages.DynamicEntityFieldsWizardPage_duplicateEntityFieldsError);
            }
            String errorMsg1 = this.checkInputFieldsMappingTypes(fields);
            if (errorMsg1 != null) {
                return new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", errorMsg1);
            }
            String errorMsg2 = this.checkInputFieldsAttributeTypeValidity(fields);
            if (errorMsg2 != null) {
                return new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", errorMsg2);
            }
            String warningMsg = this.checkInputFieldsAttributeTypeExistence(fields);
            if (warningMsg != null) {
                return new Status(2, "org.eclipse.jpt.jpa.eclipselink.ui", warningMsg);
            }
        }
        return Status.OK_STATUS;
    }

    private String checkInputFieldsMappingTypes(ArrayList<DynamicEntityField> fields) {
        IStatus validateFieldMappingTypeStatus = Status.OK_STATUS;
        Iterable<String> mappingKeys = this.getMappingKeys(fields);
        if (this.hasIDAndEmbeddedIDMappingDefined(mappingKeys)) {
            validateFieldMappingTypeStatus = new Status(4, "org.eclipse.jpt.jpa.ui", EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_bothIDAndEmbeddedIDDefinedError);
        } else if (this.hasMultipleEmbeddedIDMappings(mappingKeys)) {
            validateFieldMappingTypeStatus = new Status(4, "org.eclipse.jpt.jpa.ui", EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_multipleEmbeddedIDsDefinedError);
        }
        if (!validateFieldMappingTypeStatus.isOK()) {
            return validateFieldMappingTypeStatus.getMessage();
        }
        return null;
    }

    private Iterable<String> getMappingKeys(ArrayList<DynamicEntityField> fields) {
        return new TransformationIterable<DynamicEntityField, String>(fields){

            protected String transform(DynamicEntityField field) {
                return field.getMappingType().getKey();
            }
        };
    }

    private boolean hasIDAndEmbeddedIDMappingDefined(Iterable<String> mappingKeys) {
        return CollectionTools.contains(mappingKeys, (Object)"id") && CollectionTools.contains(mappingKeys, (Object)"embeddedId");
    }

    private boolean hasMultipleEmbeddedIDMappings(Iterable<String> mappingKeys) {
        int i = 0;
        for (String key : mappingKeys) {
            if (key != "embeddedId" || ++i <= 1) continue;
            return true;
        }
        return false;
    }

    private String checkInputFieldsAttributeTypeValidity(List<DynamicEntityField> fields) {
        IStatus validateFieldTypeStatus = Status.OK_STATUS;
        for (DynamicEntityField field : fields) {
            String elementSignature;
            if (field.isKey() && !field.couldTypeBePKType()) {
                String message = MessageFormat.format((String)EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_invalidPKType, (Object[])new Object[]{field.getFqnTypeName()});
                validateFieldTypeStatus = new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", message);
                break;
            }
            String sig = null;
            try {
                sig = Signature.createTypeSignature((String)field.getFqnTypeName(), (boolean)true);
            }
            catch (IllegalArgumentException e) {
                String message = MessageFormat.format((String)EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_invalidArgument, (Object[])new Object[]{e.getLocalizedMessage()});
                validateFieldTypeStatus = new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", message);
                break;
            }
            if (sig == null) {
                validateFieldTypeStatus = JavaConventions.validateJavaTypeName((String)field.getType(), (String)"1.5", (String)"1.5");
                break;
            }
            int sigType = Signature.getTypeSignatureKind((String)sig);
            if (sigType != 2 && sigType == 4 && Signature.getTypeSignatureKind((String)(elementSignature = Signature.getElementType((String)sig))) != 2) continue;
        }
        if (!validateFieldTypeStatus.isOK()) {
            return validateFieldTypeStatus.getMessage();
        }
        return null;
    }

    protected String checkInputFieldsAttributeTypeExistence(List<DynamicEntityField> fields) {
        IStatus validateFieldTypeStatus = Status.OK_STATUS;
        for (DynamicEntityField field : fields) {
            String sig = Signature.createTypeSignature((String)field.getFqnTypeName(), (boolean)true);
            if (sig == null) {
                String message = MessageFormat.format((String)EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_typeNotInProjectClasspath, (Object[])new Object[]{field.getFqnTypeName()});
                validateFieldTypeStatus = new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", message);
                break;
            }
            int sigType = Signature.getTypeSignatureKind((String)sig);
            if (sigType == 2) continue;
            if (sigType == 4) {
                String elementSignature = Signature.getElementType((String)sig);
                if (Signature.getTypeSignatureKind((String)elementSignature) == 2) continue;
                String qualifiedName = Signature.toString((String)elementSignature);
                IProject project = this.getTargetProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType type = null;
                try {
                    type = javaProject.findType(qualifiedName);
                }
                catch (JavaModelException e) {
                    validateFieldTypeStatus = e.getStatus();
                    break;
                }
                if (type != null) continue;
                String message = MessageFormat.format((String)EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_typeNotInProjectClasspath, (Object[])new Object[]{field.getFqnTypeName()});
                validateFieldTypeStatus = new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", message);
                break;
            }
            IProject project = this.getTargetProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IType type = null;
            try {
                type = javaProject.findType(field.getFqnTypeName());
            }
            catch (JavaModelException e) {
                validateFieldTypeStatus = e.getStatus();
                break;
            }
            if (type != null) continue;
            String message = MessageFormat.format((String)EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_typeNotInProjectClasspath, (Object[])new Object[]{field.getFqnTypeName()});
            validateFieldTypeStatus = new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", message);
            break;
        }
        if (!validateFieldTypeStatus.isOK()) {
            return validateFieldTypeStatus.getMessage();
        }
        return null;
    }

    private boolean hasDuplicatesInEntityFields(ArrayList<DynamicEntityField> fields) {
        if (fields == null) {
            return false;
        }
        int n = fields.size();
        int i = 0;
        while (i < n) {
            DynamicEntityField field = fields.get(i);
            int j = i + 1;
            while (j < n) {
                DynamicEntityField intEntity = fields.get(j);
                if (intEntity.getName().equals(field.getName())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private IStatus validatePrimaryKeyFieldsList(ArrayList<DynamicEntityField> pkFields) {
        if (pkFields.size() > 1) {
            return new Status(1, "org.eclipse.jpt.jpa.eclipselink.ui", EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_applyEmbeddedIdMappingInfo);
        }
        return null;
    }

    protected IStatus canCreateTypeInClasspath(String packageName, String typeName) {
        String fullyQualifiedName = "";
        fullyQualifiedName = !StringTools.stringIsEmpty((String)packageName) ? String.valueOf(packageName) + DOT + typeName : typeName;
        for (String name : this.getJavaTypeNames()) {
            if (StringTools.stringsAreEqual((String)name, (String)fullyQualifiedName)) {
                String message = NLS.bind((String)EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_typeExistsWarning, (Object[])new Object[]{fullyQualifiedName});
                return new Status(2, "org.eclipse.jpt.jpa.eclipselink.ui", message);
            }
            if (!StringTools.stringsAreEqualIgnoreCase((String)name, (String)fullyQualifiedName)) continue;
            String message = NLS.bind((String)EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_typeWithDiffCaseExistsWarning, (Object[])new Object[]{fullyQualifiedName});
            return new Status(2, "org.eclipse.jpt.jpa.eclipselink.ui", message);
        }
        PersistenceUnit pu = this.getPersistenceUnit();
        if (pu != null) {
            for (String name : ((EclipseLinkPersistenceUnit)this.getPersistenceUnit()).getEclipseLinkDynamicPersistentTypeNames()) {
                if (StringTools.stringsAreEqual((String)name, (String)fullyQualifiedName)) {
                    String message = NLS.bind((String)EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_dynamicTypeExistsError, (Object[])new Object[]{fullyQualifiedName});
                    return new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", message);
                }
                if (!StringTools.stringsAreEqualIgnoreCase((String)name, (String)fullyQualifiedName)) continue;
                String message = NLS.bind((String)EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_dynamicTypeWithDiffCaseExistsError, (Object[])new Object[]{fullyQualifiedName});
                return new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", message);
            }
        } else {
            return new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", EclipseLinkUiMessages.EclipseLinkDynamicEntityWizard_persistenceUnitNotFoundError);
        }
        return Status.OK_STATUS;
    }

    private Iterable<String> getJavaTypeNames() {
        return new TransformationIterable<IType, String>(this.getJavaTypes()){

            protected String transform(IType type) {
                return type.getFullyQualifiedName();
            }
        };
    }

    protected List<IType> getJavaTypes() {
        IPackageFragmentRoot[] packRoots = this.getJavaPackageFragmentRoots();
        ArrayList<IType> typesList = new ArrayList<IType>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = packRoots;
        int n = packRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            try {
                IJavaElement[] jElements;
                IJavaElement[] iJavaElementArray = jElements = root.getChildren();
                int n3 = jElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement jElement = iJavaElementArray[n4];
                    if (jElement.getElementType() == 4) {
                        ICompilationUnit[] units;
                        ICompilationUnit[] iCompilationUnitArray = units = ((IPackageFragment)jElement).getCompilationUnits();
                        int n5 = units.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ICompilationUnit unit = iCompilationUnitArray[n6];
                            CollectionTools.addAll(typesList, (Object[])unit.getTypes());
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            catch (JavaModelException e) {
                JptJpaEclipseLinkUiPlugin.log(e);
            }
            ++n2;
        }
        return typesList;
    }

    protected JpaProject getJpaProject() {
        IProject project = this.getTargetProject();
        return project != null && JpaFacet.isInstalled((IProject)project) ? this.getJpaProject(project) : null;
    }

    protected JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    protected PersistenceUnit getPersistenceUnit() {
        Persistence p = this.getPersistence();
        if (p == null) {
            return null;
        }
        ListIterator units = p.getPersistenceUnits().iterator();
        return units.hasNext() ? (PersistenceUnit)units.next() : null;
    }

    protected Persistence getPersistence() {
        PersistenceXml pxml = this.getPersistenceXml();
        return pxml == null ? null : pxml.getPersistence();
    }

    protected PersistenceXml getPersistenceXml() {
        JpaRootContextNode rcn = this.getJpaProject().getRootContextNode();
        return rcn == null ? null : rcn.getPersistenceXml();
    }
}

