/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.entity.data.operation;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkAccessType;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkEntityMappings;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmPersistentType;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmTypeMapping;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiPlugin;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.entity.data.model.DynamicEntityField;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.entity.data.model.DynamicEntityTemplateModel;
import org.eclipse.jpt.jpa.ui.internal.wizards.entity.data.operation.NewEntityClassOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class NewDynamicEntityClassOperation
extends NewEntityClassOperation {
    public NewDynamicEntityClassOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            this.generateUsingTemplates(monitor);
        }
        catch (Exception e) {
            return WTPCommonPlugin.createErrorStatus((String)e.toString());
        }
        return OK_STATUS;
    }

    protected void generateUsingTemplates(IProgressMonitor monitor) {
        DynamicEntityTemplateModel tempModel = new DynamicEntityTemplateModel(this.model);
        IProject project = this.getTargetProject();
        AddDynamicEntityToXMLCommand command = new AddDynamicEntityToXMLCommand(tempModel, project);
        this.run((IWorkspaceRunnable)new NewEntityClassOperation.DaliRunnable(project.getWorkspace(), (Command)command));
    }

    protected static class AddDynamicEntityToXMLCommand
    extends AddDynamicTypeMappingToXMLCommand {
        protected AddDynamicEntityToXMLCommand(DynamicEntityTemplateModel model, IProject project) {
            super(model, project, "entity");
        }

        protected void updateTypeMapping(EclipseLinkOrmTypeMapping typeMapping) {
            super.updateTypeMapping(typeMapping);
            Entity entity = (Entity)typeMapping;
            if (this.model.isEntityNameSet()) {
                entity.setSpecifiedName(this.model.getEntityName());
            }
            if (this.model.isTableNameSet()) {
                entity.getTable().setSpecifiedName(this.model.getTableName());
            }
        }
    }

    protected static class AddDynamicTypeMappingToXMLCommand
    implements Command {
        protected final DynamicEntityTemplateModel model;
        protected final IProject project;
        protected final String typeMappingKey;

        protected AddDynamicTypeMappingToXMLCommand(DynamicEntityTemplateModel model, IProject project, String typeMappingKey) {
            this.model = model;
            this.project = project;
            this.typeMappingKey = typeMappingKey;
        }

        public void execute() {
            JpaXmlResource xmlResource = this.getOrmXmlResource();
            EclipseLinkEntityMappings entityMappings = (EclipseLinkEntityMappings)this.getJpaProject().getJpaFile(xmlResource.getFile()).getRootStructureNodes().iterator().next();
            EclipseLinkOrmPersistentType persistentType = (EclipseLinkOrmPersistentType)entityMappings.addPersistentType(this.typeMappingKey, this.model.getQualifiedJavaClassName());
            this.updatePersistentType(entityMappings, persistentType);
            try {
                xmlResource.saveIfNecessary();
            }
            catch (Exception e) {
                JptJpaEclipseLinkUiPlugin.log(e);
            }
        }

        protected void updatePersistentType(EclipseLinkEntityMappings entityMappings, EclipseLinkOrmPersistentType persistentType) {
            this.updateTypeMapping(persistentType.getMapping());
            this.setAccessType(entityMappings, persistentType);
            if (this.model.isCompositePK()) {
                String mappingType;
                String name;
                String attributeType;
                EclipseLinkOrmPersistentType embeddable = (EclipseLinkOrmPersistentType)entityMappings.addPersistentType("embeddable", this.model.getEmbeddableClassName());
                this.setAccessType(entityMappings, embeddable);
                persistentType.addVirtualAttribute(this.model.getDefaultEmbeddedIdName(), "embeddedId", embeddable.getName());
                for (DynamicEntityField field : this.model.getPKFields()) {
                    attributeType = field.getFqnTypeName();
                    name = field.getName();
                    mappingType = "basic";
                    embeddable.addVirtualAttribute(name, mappingType, attributeType);
                }
                for (DynamicEntityField field : this.model.getEntityFields()) {
                    if (field.getMappingType().getKey() == "id") continue;
                    attributeType = field.getFqnTypeName();
                    name = field.getName();
                    mappingType = field.getMappingType().getKey();
                    persistentType.addVirtualAttribute(name, mappingType, attributeType);
                }
            } else {
                for (DynamicEntityField field : this.model.getEntityFields()) {
                    String attributeType = field.getFqnTypeName();
                    String name = field.getName();
                    String mappingType = field.getMappingType().getKey();
                    persistentType.addVirtualAttribute(name, mappingType, attributeType);
                }
            }
        }

        private void setAccessType(EclipseLinkEntityMappings entityMappings, EclipseLinkOrmPersistentType persistentType) {
            if (entityMappings.getAccess() != EclipseLinkAccessType.VIRTUAL) {
                persistentType.setSpecifiedAccess(EclipseLinkAccessType.VIRTUAL);
            }
        }

        protected void updateTypeMapping(EclipseLinkOrmTypeMapping typeMapping) {
        }

        protected JpaXmlResource getOrmXmlResource() {
            return this.model.isMappingXMLDefault() ? this.getJpaProject().getDefaultOrmXmlResource() : this.getJpaProject().getMappingFileXmlResource((IPath)new Path(this.model.getMappingXMLName()));
        }

        protected JpaProject getJpaProject() {
            return (JpaProject)this.project.getAdapter(JpaProject.class);
        }
    }
}

