/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.customization;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.Customization;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiPlugin;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionCustomizersComposite
extends Pane<Customization> {
    public SessionCustomizersComposite(Pane<? extends Customization> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private void addSessionCustomizerClass(ObjectListSelectionModel listSelectionModel) {
        IType type = this.chooseType();
        if (type != null) {
            String className = type.getFullyQualifiedName('$');
            if (!((Customization)this.getSubject()).sessionCustomizerExists(className)) {
                String classRef = ((Customization)this.getSubject()).addSessionCustomizer(className);
                listSelectionModel.setSelectedValue((Object)classRef);
            }
        }
    }

    private AddRemovePane.Adapter buildAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                SessionCustomizersComposite.this.addSessionCustomizerClass(listSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    ((Customization)SessionCustomizersComposite.this.getSubject()).removeSessionCustomizer((String)item);
                    ++n2;
                }
            }
        };
    }

    private ILabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                String name = (String)element;
                if (name == null) {
                    name = EclipseLinkUiMessages.PersistenceXmlCustomizationTab_noName;
                }
                return name;
            }
        };
    }

    private ListValueModel<String> buildListHolder() {
        return new ListAspectAdapter<Customization, String>(this.getSubjectHolder(), new String[]{"sessionCustomizers"}){

            protected ListIterable<String> getListIterable() {
                return ((Customization)this.subject).getSessionCustomizers();
            }

            protected int size_() {
                return ((Customization)this.subject).getSessionCustomizersSize();
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildSelectedItemHolder() {
        return new SimplePropertyValueModel();
    }

    private IType chooseType() {
        SelectionDialog typeSelectionDialog;
        IJavaProject javaProject = this.getJavaProject();
        IJavaElement[] elements = new IJavaElement[]{javaProject};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            JptJpaEclipseLinkUiPlugin.log(e);
            return null;
        }
        typeSelectionDialog.setTitle(JptCommonUiMessages.ClassChooserPane_dialogTitle);
        typeSelectionDialog.setMessage(JptCommonUiMessages.ClassChooserPane_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    protected void initializeLayout(Composite container) {
        container = this.addTitledGroup(container, EclipseLinkUiMessages.PersistenceXmlCustomizationTab_sessionCustomizerLabel);
        new AddRemoveListPane<Customization>((Pane)this, container, this.buildAdapter(), this.buildListHolder(), this.buildSelectedItemHolder(), this.buildLabelProvider()){

            protected void initializeTable(Table table) {
                super.initializeTable(table);
                Composite container = table.getParent();
                GridData gridData = (GridData)container.getLayoutData();
                gridData.heightHint = 75;
            }
        };
    }

    private IJavaProject getJavaProject() {
        return ((Customization)this.getSubject()).getJpaProject().getJavaProject();
    }
}

