/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.gen;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.eclipselink.core.platform.EclipseLinkPlatform;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.gen.DynamicDefaultTableGenerationWizardPage;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.gen.DynamicTablesAndColumnsCustomizationWizardPage;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.gen.JptJpaEclipseLinkUiEntityGenMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards.gen.PromptEclipseLinkProjectWizardPage;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.GenerateEntitiesFromSchemaWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.PromptJPAProjectWizardPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.TableAssociationsWizardPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.TablesSelectorWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class GenerateDynamicEntitiesFromSchemaWizard
extends GenerateEntitiesFromSchemaWizard
implements INewWizard {
    public static final String HELP_CONTEXT_ID = "org.eclipse.jpt.jpa.ui.GenerateEntitiesFromSchemaWizard";

    public GenerateDynamicEntitiesFromSchemaWizard() {
        this.setWindowTitle(JptJpaEclipseLinkUiEntityGenMessages.GenerateDynamicEntitiesWizard_generateEntities);
    }

    public GenerateDynamicEntitiesFromSchemaWizard(JpaProject jpaProject, IStructuredSelection selection) {
        super(jpaProject, selection);
        this.setWindowTitle(JptJpaEclipseLinkUiEntityGenMessages.GenerateDynamicEntitiesWizard_generateEntities);
    }

    protected void addMainPages() {
        this.tablesSelectorPage = new TablesSelectorWizardPage(this.jpaProject, this.resourceManager, true);
        this.addPage((IWizardPage)this.tablesSelectorPage);
        this.tableAssociationsPage = new TableAssociationsWizardPage(this.jpaProject, this.resourceManager);
        this.addPage((IWizardPage)this.tableAssociationsPage);
        this.defaultTableGenerationPage = new DynamicDefaultTableGenerationWizardPage(this.jpaProject);
        this.addPage((IWizardPage)this.defaultTableGenerationPage);
        this.defaultTableGenerationPage.init(this.selection);
        this.tablesAndColumnsCustomizationPage = new DynamicTablesAndColumnsCustomizationWizardPage(this.jpaProject, this.resourceManager);
        this.addPage((IWizardPage)this.tablesAndColumnsCustomizationPage);
        this.tablesAndColumnsCustomizationPage.init(this.selection);
    }

    protected String getCustomizationFileName() {
        ConnectionProfile profile = this.getProjectConnectionProfile();
        String connection = profile == null ? "" : profile.getName();
        String name = "org.eclipse.jpt.jpa.gen.dynamic." + (connection == null ? "" : connection.replace(' ', '-'));
        Schema schema = this.getDefaultSchema();
        if (schema != null) {
            name = String.valueOf(name) + "." + schema.getName();
        }
        return name.toLowerCase();
    }

    protected void scheduleGenerateEntitiesJob(GenerateEntitiesFromSchemaWizard.OverwriteConfirmer overwriteConfirmer) {
        IFile mappingFile;
        GenerateEntitiesFromSchemaWizard.GenerateEntitiesJob genEntitiesJob = new GenerateEntitiesFromSchemaWizard.GenerateEntitiesJob(this.jpaProject, this.getCustomizer(), overwriteConfirmer, true);
        genEntitiesJob.schedule();
        String xmlMappingFileLocation = this.getCustomizer().getXmlMappingFile();
        JpaXmlResource jpaXmlResource = this.jpaProject.getMappingFileXmlResource((IPath)new Path(xmlMappingFileLocation));
        if (jpaXmlResource != null) {
            mappingFile = jpaXmlResource.getFile();
        } else {
            IProject project = this.jpaProject.getProject();
            IContainer container = ((ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class)).getDefaultResourceLocation();
            mappingFile = container.getFile((IPath)new Path(xmlMappingFileLocation.substring(xmlMappingFileLocation.lastIndexOf("/"))));
        }
        OpenXmlMappingFileJob openXmlMappingFileJob = new OpenXmlMappingFileJob(this.jpaProject, mappingFile);
        openXmlMappingFileJob.schedule();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(JptJpaEclipseLinkUiEntityGenMessages.GenerateDynamicEntitiesWizard_generateEntities);
    }

    protected PromptJPAProjectWizardPage buildProjectWizardPage() {
        return new PromptEclipseLinkProjectWizardPage(HELP_CONTEXT_ID);
    }

    protected boolean projectIsValidSelection(JpaProject jpaProject) {
        if (jpaProject == null) {
            return false;
        }
        return jpaProject.getJpaPlatform().getDescription().getGroup().getId().equals(EclipseLinkPlatform.GROUP.getId());
    }

    public ORMGenCustomizer createORMGenCustomizer(Schema schema) {
        ORMGenCustomizer customizer = super.createORMGenCustomizer(schema);
        customizer.setPlatformVersion(this.getJpaProject().getJpaPlatform().getJpaVersion().getVersion());
        return customizer;
    }

    public static class OpenXmlMappingFileJob
    extends WorkspaceJob {
        private final JpaProject jpaProject;
        private final IFile mappingFile;

        public OpenXmlMappingFileJob(JpaProject jpaProject, IFile mappingFile) {
            super("Open XML File");
            this.jpaProject = jpaProject;
            this.mappingFile = mappingFile;
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            this.setRule(ruleFactory.modifyRule((IResource)jpaProject.getProject()));
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                this.postGeneration(this.jpaProject, this.mappingFile);
            }
            catch (InvocationTargetException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", "error", (Throwable)e));
            }
            return Status.OK_STATUS;
        }

        private void postGeneration(JpaProject jpaProject, IFile mappingFile) throws InvocationTargetException {
            try {
                this.openEditor(mappingFile);
            }
            catch (Exception cantOpen) {
                throw new InvocationTargetException(cantOpen);
            }
        }

        private void openEditor(final IFile file) {
            if (file != null) {
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        try {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                        }
                        catch (PartInitException e) {
                            JptJpaUiPlugin.log((Throwable)e);
                        }
                    }
                });
            }
        }
    }
}

