/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.gen.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.gen.internal.Association;
import org.eclipse.jpt.jpa.gen.internal.AssociationRole;
import org.eclipse.jpt.jpa.gen.internal.DatabaseAnnotationNameBuilder;
import org.eclipse.jpt.jpa.gen.internal.JptJpaGenPlugin;
import org.eclipse.jpt.jpa.gen.internal.ORMGenColumn;
import org.eclipse.jpt.jpa.gen.internal.ORMGenTable;
import org.eclipse.jpt.jpa.gen.internal.util.DTPUtil;
import org.eclipse.jpt.jpa.gen.internal.util.FileUtil;
import org.eclipse.jpt.jpa.gen.internal.util.ForeignKeyInfo;
import org.eclipse.jpt.jpa.gen.internal.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ORMGenCustomizer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ANY_TABLE = "__anyTable__";
    public static final String GENERATE_DDL_ANNOTATION = "generateDDLAnnotations";
    private static final String NULL_TABLE = "";
    private static final String NULL_COLUMN = "";
    private static final int FILE_VERSION = 2;
    private static final String UPDATE_CONFIG_FILE = "updateConfigFile";
    private transient Schema mSchema;
    private transient File mFile;
    private List<String> mTableNames;
    private transient Map<String, ORMGenTable> mTables;
    private List<Association> mAssociations;
    private transient List<Association> mValidAssociations;
    private transient boolean mInvalidForeignAssociations;
    private Map<String, String> mProps = new HashMap<String, String>();
    private transient DatabaseAnnotationNameBuilder databaseAnnotationNameBuilder = DatabaseAnnotationNameBuilder.Default.INSTANCE;
    private boolean mUpdatePersistenceXml = true;
    private static final String DEFAULT_XML_MAPPING_FILE = "META-INF/eclipselink-orm.xml";
    private static final String XML_MAPPING_FILE = "xmlMappingFileName";
    private static final String PLATFORM_VERSION_PROPERTY = "platformVersion";

    public abstract List<String> getAllIdGenerators();

    public abstract String getNoIdGenerator();

    public abstract String getIdentityIdGenerator();

    public abstract Set<String> getSequenceIdGenerators();

    public abstract String getPropertyTypeFromColumn(Column var1);

    public abstract String[] getAllPropertyTypes();

    public abstract String[] getAllMappingKinds();

    public abstract String getBasicMappingKind();

    public abstract String getIdMappingKind();

    public abstract boolean editCascade(AssociationRole var1);

    public void init(File file, Schema schema) {
        block25: {
            this.mSchema = schema;
            this.mFile = file;
            if (!file.exists()) {
                this.setProperty("defaultFetch", "defaultFetch", ANY_TABLE, null);
                return;
            }
            ByteArrayInputStream istream = null;
            ObjectInputStream ois = null;
            try {
                try {
                    byte[] bytes = FileUtil.readFile(file);
                    istream = new ByteArrayInputStream(bytes);
                    ois = new ObjectInputStream(istream);
                    FileHeader header = (FileHeader)ois.readObject();
                    if (header.mVersion == 2) {
                        ORMGenCustomizer customizer = (ORMGenCustomizer)ois.readObject();
                        this.restore(customizer);
                    }
                }
                catch (Exception ex) {
                    JptJpaGenPlugin.logException("***ORMGenCustomizer.load failed " + file, ex);
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (istream != null) {
                        try {
                            ((InputStream)istream).close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
                if (istream != null) {
                    try {
                        ((InputStream)istream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            if (istream != null) {
                try {
                    ((InputStream)istream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public File getFile() {
        return this.mFile;
    }

    public void setSchema(Schema schema) {
        this.mSchema = schema;
    }

    public Schema getSchema() {
        return this.mSchema;
    }

    public void save() throws IOException {
        block21: {
            if (!this.mFile.exists() && !this.mFile.createNewFile()) {
                return;
            }
            FileOutputStream fos = null;
            ObjectOutputStream oos = null;
            boolean deleteIt = true;
            try {
                try {
                    fos = new FileOutputStream(this.mFile);
                    oos = new ObjectOutputStream(fos);
                    FileHeader header = new FileHeader();
                    oos.writeObject(header);
                    oos.writeObject(this);
                    deleteIt = false;
                }
                catch (Exception ex) {
                    CoreException ce = new CoreException((IStatus)new Status(4, "org.eclipse.jpt.jpa.gen", "Unable to save the ORMGenCustomizer file: " + this.mFile, (Throwable)ex));
                    JptJpaGenPlugin.logException(ce);
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        if (deleteIt) {
                            this.mFile.delete();
                        }
                        break block21;
                    }
                    catch (IOException iOException) {}
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    if (deleteIt) {
                        this.mFile.delete();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (oos != null) {
                    oos.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (deleteIt) {
                    this.mFile.delete();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public DatabaseAnnotationNameBuilder getDatabaseAnnotationNameBuilder() {
        return this.databaseAnnotationNameBuilder;
    }

    public void setDatabaseAnnotationNameBuilder(DatabaseAnnotationNameBuilder databaseAnnotationNameBuilder) {
        if (databaseAnnotationNameBuilder == null) {
            throw new NullPointerException("database annotation name builder is required");
        }
        this.databaseAnnotationNameBuilder = databaseAnnotationNameBuilder;
    }

    public boolean isGenerateDDLAnnotations() {
        return "true".equals(this.getProperty(GENERATE_DDL_ANNOTATION, ANY_TABLE, null));
    }

    public String getProperty(String propertyName, String tableName, String colName) {
        String key = this.getPropKey(propertyName, tableName, colName);
        String value = this.mProps.get(key);
        if (value == null && tableName != null && colName == null && !tableName.equals(ANY_TABLE)) {
            value = this.getProperty(propertyName, ANY_TABLE, colName);
        }
        return value;
    }

    public void setProperty(String propertyName, String value, String tableName, String colName) {
        String key = this.getPropKey(propertyName, tableName, colName);
        if (value != null) {
            this.mProps.put(key, value);
        } else {
            this.mProps.remove(key);
        }
    }

    public boolean getBooleanProperty(String propertyName, String tableName, String colName) {
        String value = this.getProperty(propertyName, tableName, colName);
        return "true".equals(value);
    }

    public void setBooleanProperty(String propertyName, boolean value, String tableName, String colName) {
        this.setProperty(propertyName, value ? "true" : "false", tableName, colName);
    }

    public List<String> getTableNames() {
        return this.mTableNames != null ? this.mTableNames : Collections.EMPTY_LIST;
    }

    public String genFetch(ORMGenTable table) {
        return "";
    }

    public String genFetchXml(ORMGenTable table) {
        return "";
    }

    public void setXmlMappingFile(String xmlMappingFile) {
        this.setProperty(XML_MAPPING_FILE, xmlMappingFile, null, null);
    }

    public String getXmlMappingFile() {
        String xmlMappingFile = this.getProperty(XML_MAPPING_FILE, null, null);
        return xmlMappingFile == null ? DEFAULT_XML_MAPPING_FILE : xmlMappingFile;
    }

    public void setPlatformVersion(String platformVersion) {
        this.setProperty(PLATFORM_VERSION_PROPERTY, platformVersion, null, null);
    }

    public void setTableNames(List<String> tableNames) {
        this.mTableNames = tableNames;
        this.mTables = null;
        this.mValidAssociations = null;
        this.mInvalidForeignAssociations = true;
    }

    public List<String> getGenTableNames() {
        List<String> names = this.getTableNames();
        ArrayList<String> result = new ArrayList<String>(names.size());
        List<Association> associations = this.getAssociations();
        for (String tableName : names) {
            boolean isValid = true;
            for (Association association : associations) {
                if (!association.isGenerated()) continue;
                if (tableName.equals(association.getReferrerTableName()) || tableName.equals(association.getReferencedTableName())) {
                    isValid = true;
                    break;
                }
                if (!tableName.equals(association.getJoinTableName())) continue;
                isValid = false;
            }
            if (!isValid) continue;
            result.add(tableName);
        }
        return result;
    }

    public ORMGenTable getTable(String tableName) {
        if (this.mTables == null) {
            this.mTables = new HashMap<String, ORMGenTable>(this.mTableNames.size());
        }
        if (this.mTableNames != null && this.mSchema != null) {
            for (String name : this.mTableNames) {
                Table dbTable = this.mSchema.getTableNamed(name);
                if (dbTable == null) continue;
                this.mTables.put(name, this.createGenTable(dbTable));
            }
        }
        return this.mTables.get(tableName);
    }

    public List<Association> getAssociations() {
        return this.getAssociations(true);
    }

    public void addAssociation(Association association) {
        this.getAssociations(false).add(association);
        if (this.mValidAssociations != null) {
            this.mValidAssociations.add(association);
        }
    }

    public void deleteAssociation(Association association) {
        boolean removed = this.getAssociations(false).remove(association);
        assert (removed);
        if (this.mValidAssociations != null) {
            removed = this.mValidAssociations.remove(association);
            assert (removed);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean similarAssociationExists(Association association) {
        try {
            Iterator<Association> iter = this.getAssociations(false).iterator();
            while (true) {
                if (!iter.hasNext()) {
                    return false;
                }
                Association association2 = iter.next();
                if (!association.getReferrerTableName().equals(association2.getReferrerTableName()) || !association.getReferencedTableName().equals(association2.getReferencedTableName()) || !StringUtil.equalObjects(association.getJoinTableName(), association2.getJoinTableName()) || !association.getReferrerColumnNames().equals(association2.getReferrerColumnNames()) || !association.getReferencedColumnNames().equals(association2.getReferencedColumnNames())) continue;
                if (association.getJoinTableName() == null) {
                    return true;
                }
                if (association.getReferrerJoinColumnNames().equals(association2.getReferrerJoinColumnNames()) && association.getReferencedJoinColumnNames().equals(association2.getReferencedJoinColumnNames())) break;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ORMGenTable createGenTable(Table dbTable) {
        return new ORMGenTable(dbTable, this);
    }

    protected ORMGenColumn createGenColumn(Column dbCol) {
        return new ORMGenColumn(dbCol, this);
    }

    protected boolean manySideIsAssociationOwner() {
        return false;
    }

    public boolean isUpdateConfigFile() {
        return !"false".equals(this.getProperty(UPDATE_CONFIG_FILE, null, null));
    }

    public void setUpdateConfigFile(boolean value) {
        if (value) {
            this.setProperty(UPDATE_CONFIG_FILE, null, null, null);
        } else {
            this.setBooleanProperty(UPDATE_CONFIG_FILE, value, null, null);
        }
    }

    public String propertyGetter(String propertyName) {
        return "get" + StringUtil.initUpper(propertyName);
    }

    public String propertySetter(String propertyName) {
        return "set" + StringUtil.initUpper(propertyName);
    }

    public String propertyAdd(String propertyName) {
        String name = StringUtil.singularise(propertyName);
        return "add" + StringUtil.initUpper(name);
    }

    public String propertyRemove(String propertyName) {
        String name = StringUtil.singularise(propertyName);
        return "remove" + StringUtil.initUpper(name);
    }

    public String quote(String s) {
        return StringUtil.quote(s, '\"');
    }

    public String quote(boolean b) {
        return this.quote(String.valueOf(b));
    }

    public String quote(int i) {
        return this.quote(String.valueOf(i));
    }

    public String convertToJavaStringLiteral(String s) {
        return StringTools.convertToJavaStringLiteral((String)s);
    }

    public String convertToXmlStringLiteral(String s) {
        return StringTools.convertToXmlStringLiteral((String)s);
    }

    public String convertToSingularisedString(String s) {
        return StringUtil.singularise(s);
    }

    public String appendAnnotation(String s, String memberName, String memberValue, boolean quote) {
        if (memberValue == null || memberValue.length() == 0) {
            return s;
        }
        StringBuffer buffer = new StringBuffer(s);
        if (buffer.length() != 0) {
            buffer.append(", ");
        }
        buffer.append(memberName);
        buffer.append('=');
        if (quote) {
            buffer.append('\"');
        }
        buffer.append(memberValue);
        if (quote) {
            buffer.append('\"');
        }
        return buffer.toString();
    }

    public String appendAttribute(String s, String memberName, String memberValue, boolean quote) {
        if (memberValue == null || memberValue.length() == 0) {
            return s;
        }
        StringBuffer buffer = new StringBuffer(s);
        if (buffer.length() != 0) {
            buffer.append(" ");
        }
        buffer.append(memberName);
        buffer.append('=');
        if (quote) {
            buffer.append('\"');
        }
        buffer.append(memberValue);
        if (quote) {
            buffer.append('\"');
        }
        return buffer.toString();
    }

    public boolean isJDK1_5() {
        return true;
    }

    public String getPlatformVersion() {
        return this.getProperty(PLATFORM_VERSION_PROPERTY, null, null);
    }

    public String getPlatformVersionWithUnderscore() {
        String version = this.getProperty(PLATFORM_VERSION_PROPERTY, null, null);
        return version.replace('.', '_');
    }

    private void restore(ORMGenCustomizer customizer) {
        this.mTableNames = customizer.mTableNames;
        this.mAssociations = customizer.mAssociations;
        this.mProps = customizer.mProps;
        this.mUpdatePersistenceXml = customizer.mUpdatePersistenceXml;
        if (this.mSchema == null) {
            return;
        }
        int i = this.mTableNames.size() - 1;
        while (i >= 0) {
            String tableName = this.mTableNames.get(i);
            if (this.mSchema.getTableNamed(tableName) == null) {
                this.mTableNames.remove(i);
            }
            --i;
        }
        if (this.mAssociations != null) {
            for (Association association : this.mAssociations) {
                association.restore(this);
            }
            this.addForeignKeyAssociations(true);
            this.sortAssociations(this.mAssociations);
        }
    }

    private String getPropKey(String propertyName, String tableName, String colName) {
        if (tableName == null) {
            tableName = "";
        }
        if (colName == null) {
            colName = "";
        }
        return String.valueOf(tableName) + '.' + colName + '.' + propertyName;
    }

    private List<Association> getAssociations(boolean validOnly) {
        List<Association> associations;
        if (this.mAssociations == null) {
            this.mAssociations = new ArrayList<Association>();
            this.addForeignKeyAssociations(false);
        } else if (this.mInvalidForeignAssociations) {
            this.mInvalidForeignAssociations = false;
            this.addForeignKeyAssociations(true);
        }
        if (validOnly) {
            if (this.mValidAssociations == null) {
                this.mValidAssociations = new ArrayList<Association>(this.mAssociations.size());
                int i = 0;
                int n = this.mAssociations.size();
                while (i < n) {
                    Association association = this.mAssociations.get(i);
                    if (association.isValid()) {
                        this.mValidAssociations.add(association);
                    }
                    ++i;
                }
            }
            associations = this.mValidAssociations;
        } else {
            associations = this.mAssociations;
        }
        return associations;
    }

    private void addForeignKeyAssociations(boolean checkExisting) {
        List<String> tableNames = this.getTableNames();
        Iterator<String> iter = tableNames.iterator();
        while (iter.hasNext()) {
            ORMGenTable table = this.getTable(iter.next());
            this.addForeignKeyAssociations(table, checkExisting);
        }
    }

    private void addForeignKeyAssociations(ORMGenTable table, boolean checkExisting) {
        if (table == null) {
            return;
        }
        List<ForeignKeyInfo> fKeys = null;
        try {
            fKeys = DTPUtil.getForeignKeys(table.getDbTable());
        }
        catch (Exception exception) {
            return;
        }
        if (fKeys.size() == 0) {
            return;
        }
        ArrayList<Association> addedAssociations = new ArrayList<Association>();
        for (ForeignKeyInfo fki : fKeys) {
            ORMGenTable referencedTable = this.getTable(fki.getReferencedTableName());
            if (referencedTable == null) continue;
            Association association = new Association(this, table.getName(), fki.getReferrerColumnNames(), referencedTable.getName(), fki.getReferencedColumnNames());
            association.computeCardinality();
            addedAssociations.add(association);
        }
        Association m2m = this.computeManyToMany(table, addedAssociations);
        if (m2m != null) {
            addedAssociations.clear();
            addedAssociations.add(0, m2m);
        }
        Iterator it = addedAssociations.iterator();
        block3: while (it.hasNext()) {
            Association newAssociation = (Association)it.next();
            for (Association association : this.mAssociations) {
                if (!newAssociation.equals(association)) continue;
                it.remove();
                continue block3;
            }
        }
        this.mAssociations.addAll(addedAssociations);
    }

    private Association computeManyToMany(ORMGenTable table, List<Association> addedAssociations) {
        if (addedAssociations.size() != 2) {
            return null;
        }
        Association assoc1 = addedAssociations.get(0);
        Association assoc2 = addedAssociations.get(1);
        if (assoc1.getCardinality() != "many-to-one" || assoc2.getCardinality() != "many-to-one") {
            return null;
        }
        for (ORMGenColumn col : table.getColumns()) {
            if (col.isForeignKey()) continue;
            return null;
        }
        ORMGenTable t1 = assoc1.getReferencedTable();
        ORMGenTable t2 = assoc2.getReferencedTable();
        if (t1.getName().equals(table.getName()) || t2.getName().equals(table.getName())) {
            return null;
        }
        if (!table.getName().equals(String.valueOf(t1.getName()) + "_" + t2.getName())) {
            ORMGenTable t3 = t1;
            t1 = t2;
            t2 = t3;
            Association assoc3 = assoc1;
            assoc1 = assoc2;
            assoc2 = assoc3;
        }
        Association m2m = new Association(this, t1.getName(), assoc1.getReferencedColumnNames(), t2.getName(), assoc2.getReferencedColumnNames(), table.getName(), assoc1.getReferrerColumnNames(), assoc2.getReferrerColumnNames());
        m2m.setCustom(false);
        return m2m;
    }

    private void sortAssociations(List<Association> list) {
        Collections.sort(list, new Comparator<Association>(){

            @Override
            public int compare(Association lhs, Association rhs) {
                int test = lhs.getReferrerTableName().compareTo(rhs.getReferrerTableName());
                if (test != 0) {
                    return test;
                }
                test = lhs.getReferencedTableName().compareTo(rhs.getReferencedTableName());
                if (test != 0) {
                    return test;
                }
                return 0;
            }
        });
    }

    public boolean updatePersistenceXml() {
        return this.mUpdatePersistenceXml;
    }

    public void setUpdatePersistenceXml(boolean updatePersistenceXml) {
        this.mUpdatePersistenceXml = updatePersistenceXml;
    }

    private static class FileHeader
    implements Serializable {
        private static final long serialVersionUID = 1L;
        int mVersion = 2;
    }
}

