/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.internal.ui.text.JavaReconciler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jpt.common.ui.internal.JptUIPlugin;
import org.eclipse.jpt.common.utility.BooleanReference;
import org.eclipse.jpt.common.utility.internal.AbstractBooleanReference;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.osgi.framework.BundleContext;

public class JptJpaUiPlugin
extends JptUIPlugin {
    private final AsyncEventListenerFlag asyncEventListenerFlag = new AsyncEventListenerFlag();
    private final Listener focusListener = this.buildFocusListener();
    public static final String PLUGIN_ID = "org.eclipse.jpt.jpa.ui";
    public static final String PLUGIN_ID_ = "org.eclipse.jpt.jpa.ui.";
    private static final String DALI_UI_KEY = "org.eclipse.jpt.jpa.ui";
    private static final Object DALI_UI_DATA = new Object();
    @Deprecated
    public static final String JPQL_IDENTIFIER_CASE_PREF_KEY = "org.eclipse.jpt.jpa.ui.jpqlIdentifier.case";
    @Deprecated
    public static final String JPQL_IDENTIFIER_LOWERCASE_PREF_VALUE = "lowercase";
    @Deprecated
    public static final String JPQL_IDENTIFIER_UPPERCASE_PREF_VALUE = "uppercase";
    @Deprecated
    public static final String JPQL_IDENTIFIER_MATCH_FIRST_CHARACTER_CASE_PREF_KEY = "org.eclipse.jpt.jpa.ui.jpqlIdentifier.matchFirstCharacterCase";
    private static JptJpaUiPlugin INSTANCE;

    public static JptJpaUiPlugin instance() {
        return INSTANCE;
    }

    public static void log(String msg) {
        INSTANCE.logError(msg);
    }

    public static void log(Throwable throwable) {
        INSTANCE.logError(throwable);
    }

    public static void log(String msg, Throwable throwable) {
        INSTANCE.logError(msg, throwable);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (!key.startsWith("icons/")) {
            key = "icons/" + key;
        }
        if (!key.endsWith(".gif")) {
            key = String.valueOf(key) + ".gif";
        }
        return JptJpaUiPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jpt.jpa.ui", (String)key);
    }

    public static Image getImage(String key) {
        ImageRegistry imageRegistry = JptJpaUiPlugin.instance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            imageRegistry.put(key, JptJpaUiPlugin.getImageDescriptor(key));
            image = imageRegistry.get(key);
        }
        return image;
    }

    public JptJpaUiPlugin() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
    }

    private Listener buildFocusListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                JptJpaUiPlugin.this.focusIn((Control)event.widget);
            }
        };
    }

    void focusIn(Control control) {
        this.asyncEventListenerFlag.setValue(this.controlIsNonDali(control));
    }

    private boolean controlIsNonDali(Control control) {
        return !this.controlIsDali(control);
    }

    private boolean controlIsDali(Control control) {
        while (control != null) {
            if (control.getData("org.eclipse.jpt.jpa.ui") == DALI_UI_DATA) {
                return true;
            }
            control = control.getParent();
        }
        return false;
    }

    public void controlAffectsJavaSource(Control control) {
        control.setData("org.eclipse.jpt.jpa.ui", DALI_UI_DATA);
    }

    public synchronized void start(BundleContext context) throws Exception {
        super.start(context);
        this.getJpaProjectManager().addAsyncEventListenerFlag((BooleanReference)this.asyncEventListenerFlag);
        Display.getDefault().addFilter(15, this.focusListener);
    }

    private JpaProjectManager getJpaProjectManager() {
        return (JpaProjectManager)ResourcesPlugin.getWorkspace().getAdapter(JpaProjectManager.class);
    }

    public synchronized void stop(BundleContext context) throws Exception {
        try {
            Display.getDefault().removeFilter(15, this.focusListener);
            this.getJpaProjectManager().removeAsyncEventListenerFlag((BooleanReference)this.asyncEventListenerFlag);
        }
        finally {
            super.stop(context);
        }
    }

    static class AsyncEventListenerFlag
    extends AbstractBooleanReference {
        private volatile boolean value = true;
        private static final String JAVA_RECONCILER_THREAD_NAME = JavaReconciler.class.getName();

        AsyncEventListenerFlag() {
        }

        public boolean getValue() {
            if (Thread.currentThread().getName().equals(JAVA_RECONCILER_THREAD_NAME)) {
                return this.value;
            }
            return true;
        }

        public boolean setValue(boolean value) {
            boolean old = this.value;
            this.value = value;
            return old;
        }
    }
}

