/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.SimpleFilter;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ElementPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.ui.JpaFileModel;
import org.eclipse.jpt.jpa.ui.JpaProjectModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{JpaFileModel.class};

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IFile) {
            return this.getAdapter((IFile)adaptableObject, adapterType);
        }
        return null;
    }

    private Object getAdapter(IFile file, Class<?> adapterType) {
        if (adapterType == JpaFileModel.class) {
            return this.getJpaFileModel(file);
        }
        return null;
    }

    private JpaFileModel getJpaFileModel(IFile file) {
        return new JpaFileModelAdapter(this.buildJpaFilesModel(file.getProject()), file);
    }

    private CollectionValueModel<JpaFile> buildJpaFilesModel(IProject project) {
        return new JpaFilesModel(this.getJpaProjectModel(project));
    }

    private JpaProjectModel getJpaProjectModel(IProject project) {
        return (JpaProjectModel)project.getAdapter(JpaProjectModel.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpaFileModelAdapter
    extends ElementPropertyValueModelAdapter<JpaFile>
    implements JpaFileModel {
        JpaFileModelAdapter(CollectionValueModel<JpaFile> jpaFilesModel, IFile file) {
            super(jpaFilesModel, (Filter)new Predicate(file));
        }

        @Override
        public IFile getFile() {
            return (IFile)((Predicate)this.predicate).getCriterion();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Predicate
        extends SimpleFilter<JpaFile, IFile> {
            Predicate(IFile file) {
                super((Object)file);
            }

            public boolean accept(JpaFile jpaFile) {
                return jpaFile.getFile().equals(this.criterion);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpaFilesModel
    extends CollectionAspectAdapter<JpaProject, JpaFile> {
        JpaFilesModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, new String[]{"jpaFiles"});
        }

        protected Iterable<JpaFile> getIterable() {
            return ((JpaProject)this.subject).getJpaFiles();
        }

        protected int size_() {
            return ((JpaProject)this.subject).getJpaFilesSize();
        }
    }
}

