/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JpaXmlStructureNode;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.DefaultJpaXmlCompletionProposalComputer;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaXmlCompletionProposalComputer
extends DefaultJpaXmlCompletionProposalComputer {
    @Override
    public List<ICompletionProposal> computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        try {
            return super.computeCompletionProposals(context, monitor);
        }
        catch (RuntimeException ex) {
            JptJpaUiPlugin.log(ex);
            return Collections.emptyList();
        }
    }

    @Override
    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        List<String> proposedValues = this.getProposedValues(context);
        if (proposedValues.size() > 0) {
            String matchString = contentAssistRequest.getMatchString();
            if (matchString == null) {
                matchString = "";
            }
            if (matchString.length() > 0 && (matchString.startsWith("\"") || matchString.startsWith("'"))) {
                matchString = matchString.substring(1);
            }
            int rOffset = contentAssistRequest.getReplacementBeginPosition();
            int rLength = contentAssistRequest.getReplacementLength();
            for (String possibleValue : proposedValues) {
                if (matchString.length() != 0 && !StringTools.stringStartsWithIgnoreCase((String)possibleValue, (String)matchString)) continue;
                String rString = "\"" + possibleValue + "\"";
                CompletionProposal proposal = new CompletionProposal(rString, rOffset, rLength, rString.length());
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        } else {
            this.setErrorMessage(XMLUIMessages.Content_Assist_not_availab_UI_);
        }
    }

    @Override
    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext context) {
        List<String> proposedValues;
        Node parent = contentAssistRequest.getParent();
        if (parent != null && parent.getNodeType() == 9 && ((IDOMDocument)parent).isXMLType() && !this.isCursorAfterXMLPI(contentAssistRequest)) {
            return;
        }
        if (!this.isCursorAfterDoctype(contentAssistRequest)) {
            return;
        }
        if (parent != null && parent instanceof IDOMNode && this.isCommentNode((IDOMNode)parent)) {
            while (parent != null && this.isCommentNode((IDOMNode)parent)) {
                parent = parent.getParentNode();
            }
        }
        if ((proposedValues = this.getProposedValues(context)).size() > 0) {
            String matchString = contentAssistRequest.getMatchString();
            if (matchString == null) {
                matchString = "";
            }
            int begin = contentAssistRequest.getReplacementBeginPosition();
            int length = contentAssistRequest.getReplacementLength();
            if (parent instanceof IDOMNode && parent.getNodeType() == 1 && ((IDOMNode)parent).getLastStructuredDocumentRegion() != ((IDOMNode)parent).getFirstStructuredDocumentRegion()) {
                begin = ((IDOMNode)parent).getFirstStructuredDocumentRegion().getEndOffset();
                length = ((IDOMNode)parent).getLastStructuredDocumentRegion().getStartOffset() - begin;
            }
            for (String possibleValue : proposedValues) {
                if (matchString.length() != 0 && !StringTools.stringStartsWithIgnoreCase((String)possibleValue, (String)matchString)) continue;
                CustomCompletionProposal proposal = new CustomCompletionProposal(possibleValue, begin, length, possibleValue.length(), JptJpaUiPlugin.getImage("full/obj16/jpa-content"), possibleValue, null, null, 500);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        } else {
            this.setErrorMessage(XMLUIMessages.Content_Assist_not_availab_UI_);
        }
    }

    private List<String> getProposedValues(CompletionProposalInvocationContext context) {
        ArrayList<String> list = new ArrayList<String>();
        int documentPosition = context.getInvocationOffset();
        if (documentPosition == -1) {
            return Collections.emptyList();
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer buffer = manager.getTextFileBuffer(context.getDocument());
        if (buffer == null) {
            return Collections.emptyList();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile(buffer.getLocation());
        JpaFile jpaFile = (JpaFile)file.getAdapter(JpaFile.class);
        if (jpaFile == null) {
            return Collections.emptyList();
        }
        HashBag rootStructureNodes = CollectionTools.collection((Iterable)jpaFile.getRootStructureNodes());
        if (rootStructureNodes.isEmpty()) {
            return Collections.emptyList();
        }
        for (JpaStructureNode node : rootStructureNodes) {
            Iterable strings = ((JpaXmlStructureNode)node).getXmlCompletionProposals(documentPosition);
            if (strings != null) {
                CollectionTools.addAll(list, (Iterable)strings);
                continue;
            }
            return Collections.emptyList();
        }
        return list;
    }

    protected boolean isCursorAfterXMLPI(ContentAssistRequest car) {
        Node aNode = car.getNode();
        boolean xmlpiFound = false;
        Document parent = aNode.getOwnerDocument();
        int xmlpiNodePosition = -1;
        boolean isAfterXMLPI = false;
        if (parent == null) {
            return true;
        }
        Node child = parent.getFirstChild();
        while (child != null) {
            boolean xmlpi = child.getNodeType() == 7 && child.getNodeName().equals("xml");
            boolean bl = xmlpiFound = xmlpiFound || xmlpi;
            if (xmlpiFound) {
                if (!(child instanceof IDOMNode)) break;
                xmlpiNodePosition = ((IDOMNode)child).getEndOffset();
                isAfterXMLPI = car.getReplacementBeginPosition() >= xmlpiNodePosition;
                break;
            }
            child = child.getNextSibling();
        }
        return isAfterXMLPI;
    }

    private boolean isCursorAfterDoctype(ContentAssistRequest car) {
        Node aNode = car.getNode();
        Document parent = aNode.getOwnerDocument();
        int xmldoctypeNodePosition = -1;
        boolean isAfterDoctype = true;
        if (parent == null) {
            return true;
        }
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child instanceof IDOMNode && child.getNodeType() == 10) {
                xmldoctypeNodePosition = ((IDOMNode)child).getEndOffset();
                isAfterDoctype = car.getReplacementBeginPosition() >= xmldoctypeNodePosition;
                break;
            }
            child = child.getNextSibling();
        }
        return isAfterDoctype;
    }

    private boolean isCommentNode(IDOMNode node) {
        return node != null && node instanceof IDOMElement && ((IDOMElement)node).isCommentTag();
    }
}

