/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.AbstractTransformer;
import org.eclipse.jpt.common.utility.internal.SimpleFilter;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.model.value.ElementPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.JpaRootContextNode;
import org.eclipse.jpt.jpa.ui.JpaProjectModel;
import org.eclipse.jpt.jpa.ui.JpaProjectsModel;
import org.eclipse.jpt.jpa.ui.JpaRootContextNodeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{JpaProjectModel.class, JpaRootContextNodeModel.class};

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IProject) {
            return this.getAdapter((IProject)adaptableObject, adapterType);
        }
        return null;
    }

    private Object getAdapter(IProject project, Class<?> adapterType) {
        if (adapterType == JpaProjectModel.class) {
            return this.getJpaProjectModel(project);
        }
        if (adapterType == JpaRootContextNodeModel.class) {
            return this.getJpaRootContextNodeModel(project);
        }
        return null;
    }

    private JpaProjectModel getJpaProjectModel(IProject project) {
        return new JpaProjectModelAdapter(this.getJpaProjectsModel(project.getWorkspace()), project);
    }

    private JpaProjectsModel getJpaProjectsModel(IWorkspace workspace) {
        return (JpaProjectsModel)workspace.getAdapter(JpaProjectsModel.class);
    }

    private JpaRootContextNodeModel getJpaRootContextNodeModel(IProject project) {
        return new JpaRootContextNodeModelAdapter(this.getJpaProjectModel(project));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpaProjectModelAdapter
    extends ElementPropertyValueModelAdapter<JpaProject>
    implements JpaProjectModel {
        JpaProjectModelAdapter(CollectionValueModel<JpaProject> jpaProjectsModel, IProject project) {
            super(jpaProjectsModel, (Filter)new Predicate(project));
        }

        @Override
        public IProject getProject() {
            return (IProject)((Predicate)this.predicate).getCriterion();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Predicate
        extends SimpleFilter<JpaProject, IProject> {
            Predicate(IProject project) {
                super((Object)project);
            }

            public boolean accept(JpaProject jpaProject) {
                return jpaProject.getProject().equals(this.criterion);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JpaRootContextNodeModelAdapter
    extends TransformationPropertyValueModel<JpaProject, JpaRootContextNode>
    implements JpaRootContextNodeModel {
        private static final Transformer TRANSFORMER = new Transformer();

        JpaRootContextNodeModelAdapter(JpaProjectModel jpaProjectsModel) {
            super((PropertyValueModel)jpaProjectsModel, (org.eclipse.jpt.common.utility.internal.Transformer)TRANSFORMER);
        }

        @Override
        public IProject getProject() {
            return ((JpaProjectModel)this.valueModel).getProject();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Transformer
        extends AbstractTransformer<JpaProject, JpaRootContextNode> {
            Transformer() {
            }

            protected JpaRootContextNode transform_(JpaProject jpaProject) {
                return jpaProject.getRootContextNode();
            }
        }
    }
}

