/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.selection.JpaSelectionManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OpenJpaResourceAction
extends BaseSelectionListenerAction {
    private JpaContextNode selectedNode;

    public OpenJpaResourceAction() {
        super(JptUiMessages.OpenJpaResourceAction_open);
    }

    public boolean updateSelection(IStructuredSelection s) {
        this.selectedNode = null;
        return super.updateSelection(s) && this.updateSelection_(s);
    }

    private boolean updateSelection_(IStructuredSelection s) {
        if (s.size() == 1) {
            this.selectedNode = (JpaContextNode)s.getFirstElement();
            return true;
        }
        return false;
    }

    public void run() {
        if (this.isEnabled()) {
            this.run_();
        }
    }

    private void run_() {
        IResource resource = this.selectedNode.getResource();
        if (resource != null && resource.exists() && resource.getType() == 1) {
            this.openEditor((IFile)resource);
            if (this.selectedNode instanceof JpaStructureNode) {
                JpaSelectionManager selectionManager = (JpaSelectionManager)PlatformTools.getAdapter((Object)PlatformUI.getWorkbench(), JpaSelectionManager.class);
                selectionManager.setSelection((JpaStructureNode)this.selectedNode);
            }
        }
    }

    protected void openEditor(IFile file) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IContentType contentType = IDE.getContentType((IFile)file);
        IEditorDescriptor editorDescriptor = registry.getDefaultEditor(file.getName(), contentType);
        if (editorDescriptor == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.openEditor((IEditorInput)new FileEditorInput(file), editorDescriptor.getId());
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)JptUiMessages.OpenJpaResourceAction_error, (String)e.getMessage());
        }
    }
}

