/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.ui.details.JpaComposite;
import org.eclipse.jpt.jpa.ui.internal.details.IdMappingGenerationComposite;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.TemporalTypeComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIdMappingComposite<T extends IdMapping>
extends Pane<T>
implements JpaComposite {
    public AbstractIdMappingComposite(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    protected void initializeLayout(Composite container) {
        this.initializeIdCollapsibleSection(container);
        this.initializeTypeCollapsibleSection(container);
        this.initializeGenerationCollapsibleSection(container);
    }

    protected void initializeIdCollapsibleSection(Composite container) {
        container = this.addCollapsibleSection(container, JptUiDetailsMessages.IdSection_title, (PropertyValueModel)new SimplePropertyValueModel((Object)Boolean.TRUE));
        this.initializeIdSection(container);
    }

    protected abstract void initializeIdSection(Composite var1);

    protected void initializeTypeCollapsibleSection(Composite container) {
        container = this.addCollapsibleSection(container, JptUiDetailsMessages.TypeSection_type);
        this.initializeTypeSection(container);
    }

    protected void initializeTypeSection(Composite container) {
        ((GridLayout)container.getLayout()).numColumns = 2;
        Button noConverterButton = this.addRadioButton(container, JptUiDetailsMessages.TypeSection_default, this.buildConverterBooleanHolder(null), null);
        ((GridData)noConverterButton.getLayoutData()).horizontalSpan = 2;
        PropertyValueModel<Converter> converterHolder = this.buildConverterHolder();
        this.addRadioButton(container, JptUiDetailsMessages.TypeSection_temporal, this.buildConverterBooleanHolder(BaseTemporalConverter.class), null);
        this.registerSubPane(new TemporalTypeComposite(this.buildTemporalConverterHolder(converterHolder), container, this.getWidgetFactory()));
    }

    protected void initializeGenerationCollapsibleSection(Composite container) {
        new IdMappingGenerationComposite(this, container);
    }

    protected PropertyValueModel<? extends Column> buildColumnHolder() {
        return new TransformationPropertyValueModel<T, Column>(this.getSubjectHolder()){

            protected Column transform_(T value) {
                return value.getColumn();
            }
        };
    }

    protected ModifiablePropertyValueModel<Boolean> buildConverterBooleanHolder(final Class<? extends Converter> converterType) {
        return new PropertyAspectAdapter<T, Boolean>(this.getSubjectHolder(), new String[]{"converter"}){

            protected Boolean buildValue_() {
                Converter converter = ((IdMapping)this.subject).getConverter();
                return converter.getType() == converterType;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((IdMapping)this.subject).setConverter(converterType);
                }
            }
        };
    }

    protected PropertyValueModel<Converter> buildConverterHolder() {
        return new PropertyAspectAdapter<T, Converter>(this.getSubjectHolder(), new String[]{"converter"}){

            protected Converter buildValue_() {
                return ((IdMapping)this.subject).getConverter();
            }
        };
    }

    protected PropertyValueModel<BaseTemporalConverter> buildTemporalConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, BaseTemporalConverter>(converterHolder){

            protected BaseTemporalConverter transform_(Converter converter) {
                return converter.getType() == BaseTemporalConverter.class ? (BaseTemporalConverter)converter : null;
            }
        };
    }
}

