/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import org.eclipse.jpt.common.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorComposite<T extends Generator>
extends Pane<T> {
    protected GeneratorBuilder<T> generatorBuilder;

    protected GeneratorComposite(Pane<?> parentPane, PropertyValueModel<T> subjectHolder, Composite parent, GeneratorBuilder<T> generatorBuilder) {
        super(parentPane, subjectHolder, parent, false);
        this.generatorBuilder = generatorBuilder;
    }

    protected final T buildGenerator() {
        return (T)((Generator)this.generatorBuilder.addGenerator());
    }

    protected final T retrieveGenerator() {
        Object generator = (Generator)this.getSubject();
        if (generator == null) {
            generator = this.buildGenerator();
        }
        return (T)generator;
    }

    protected final ModifiablePropertyValueModel<String> buildGeneratorNameHolder() {
        return new PropertyAspectAdapter<Generator, String>(this.getSubjectHolder(), new String[]{"name"}){

            protected String buildValue_() {
                return ((Generator)this.subject).getName();
            }

            public void setValue(String value) {
                if (this.subject != null) {
                    this.setValue_(value);
                    return;
                }
                if (value.length() == 0) {
                    return;
                }
                GeneratorComposite.this.retrieveGenerator().setName(value);
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Generator)this.subject).setName(value);
            }
        };
    }

    protected void addAllocationSizeCombo(Composite container) {
        new IntegerCombo<Generator>((Pane)this, this.getSubjectHolder(), container){

            protected String getLabelText() {
                return JptUiDetailsMessages.GeneratorComposite_allocationSize;
            }

            protected String getHelpId() {
                return null;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<Generator, Integer>(this.getSubjectHolder(), new String[]{"defaultAllocationSize"}){

                    protected Integer buildValue_() {
                        return ((Generator)this.subject).getDefaultAllocationSize();
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<Generator, Integer>(this.getSubjectHolder(), new String[]{"specifiedAllocationSize"}){

                    protected Integer buildValue_() {
                        return ((Generator)this.subject).getSpecifiedAllocationSize();
                    }

                    public void setValue(Integer value) {
                        GeneratorComposite.this.retrieveGenerator().setSpecifiedAllocationSize(value);
                    }
                };
            }
        };
    }

    protected void addInitialValueCombo(Composite container) {
        new IntegerCombo<Generator>((Pane)this, this.getSubjectHolder(), container){

            protected String getLabelText() {
                return JptUiDetailsMessages.GeneratorComposite_initialValue;
            }

            protected String getHelpId() {
                return null;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<Generator, Integer>(this.getSubjectHolder(), new String[]{"defaultInitialValue"}){

                    protected Integer buildValue_() {
                        return ((Generator)this.subject).getDefaultInitialValue();
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<Generator, Integer>(this.getSubjectHolder(), new String[]{"specifiedInitialValue"}){

                    protected Integer buildValue_() {
                        return ((Generator)this.subject).getSpecifiedInitialValue();
                    }

                    public void setValue(Integer value) {
                        GeneratorComposite.this.retrieveGenerator().setSpecifiedInitialValue(value);
                    }
                };
            }
        };
    }

    protected final JpaProject getJpaProject() {
        return this.getSubject() == null ? null : ((Generator)this.getSubject()).getJpaProject();
    }

    protected abstract String getPropertyName();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface GeneratorBuilder<T> {
        public T addGenerator();
    }
}

