/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.SecondaryTable;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SecondaryTableDialog
extends Dialog {
    private final JpaProject jpaProject;
    private final SecondaryTable secondaryTable;
    private final String defaultCatalog;
    private final String defaultSchema;
    protected Combo tableCombo;
    protected Combo catalogCombo;
    protected Combo schemaCombo;
    private String selectedTable;
    private String selectedSchema;
    private String selectedCatalog;

    public SecondaryTableDialog(Shell parent, JpaProject jpaProject, String defaultCatalog, String defaultSchema) {
        this(parent, jpaProject, null, defaultCatalog, defaultSchema);
    }

    public SecondaryTableDialog(Shell parent, JpaProject jpaProject, SecondaryTable secondaryTable) {
        this(parent, jpaProject, secondaryTable, secondaryTable.getDefaultCatalog(), secondaryTable.getDefaultSchema());
    }

    protected SecondaryTableDialog(Shell parent, JpaProject jpaProject, SecondaryTable secondaryTable, String defaultCatalog, String defaultSchema) {
        super(parent);
        this.jpaProject = jpaProject;
        this.secondaryTable = secondaryTable;
        this.defaultCatalog = defaultCatalog;
        this.defaultSchema = defaultSchema;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        size.x = this.convertWidthInCharsToPixels(50);
        return size;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    protected String getTitle() {
        return this.secondaryTable == null ? JptUiDetailsMessages.SecondaryTableDialog_addSecondaryTable : JptUiDetailsMessages.SecondaryTableDialog_editSecondaryTable;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 2;
        Label tableLabel = new Label(composite, 16384);
        tableLabel.setText(JptUiDetailsMessages.SecondaryTableDialog_name);
        GridData gridData = new GridData();
        tableLabel.setLayoutData((Object)gridData);
        this.tableCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.tableCombo.setLayoutData((Object)gridData);
        Label catalogLabel = new Label(composite, 16384);
        catalogLabel.setText(JptUiDetailsMessages.SecondaryTableDialog_catalog);
        gridData = new GridData();
        catalogLabel.setLayoutData((Object)gridData);
        this.catalogCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.catalogCombo.setLayoutData((Object)gridData);
        Label schemaLabel = new Label(composite, 16384);
        schemaLabel.setText(JptUiDetailsMessages.SecondaryTableDialog_schema);
        gridData = new GridData();
        schemaLabel.setLayoutData((Object)gridData);
        this.schemaCombo = new Combo(composite, 16384);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.schemaCombo.setLayoutData((Object)gridData);
        this.initializeCatalogCombo();
        this.initializeSchemaCombo();
        this.initializeTableCombo();
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        this.tableCombo.addModifyListener(this.buildTableModifyListener());
        this.catalogCombo.addSelectionListener(this.buildCatalogSelectionListener());
        this.schemaCombo.addSelectionListener(this.buildSchemaSelectionListener());
        this.refreshButtons();
        return composite;
    }

    protected void initializeCatalogCombo() {
        this.populateCatalogCombo();
        if (this.isAddDialog()) {
            this.catalogCombo.select(0);
        } else {
            String specifiedCatalog = this.secondaryTable.getSpecifiedCatalog();
            if (specifiedCatalog == null) {
                this.catalogCombo.select(0);
            } else {
                this.catalogCombo.setText(specifiedCatalog);
            }
        }
    }

    protected void populateCatalogCombo() {
        Database database = this.getDatabase();
        if (database != null && !database.supportsCatalogs()) {
            this.catalogCombo.setEnabled(false);
            return;
        }
        if (this.defaultCatalog != null) {
            this.catalogCombo.add(NLS.bind((String)JptUiDetailsMessages.SecondaryTableDialog_defaultCatalog, (Object)this.defaultCatalog));
        }
        if (database != null) {
            for (String identifier : database.getSortedCatalogIdentifiers()) {
                this.catalogCombo.add(identifier);
            }
        }
    }

    protected void initializeSchemaCombo() {
        this.populateSchemaCombo();
        if (this.isAddDialog()) {
            this.schemaCombo.select(0);
        } else {
            String specifiedSchema = this.secondaryTable.getSpecifiedSchema();
            if (specifiedSchema == null) {
                this.schemaCombo.select(0);
            } else {
                this.schemaCombo.setText(specifiedSchema);
            }
        }
    }

    protected void populateSchemaCombo() {
        SchemaContainer sc;
        if (this.defaultSchema != null) {
            this.schemaCombo.add(NLS.bind((String)JptUiDetailsMessages.SecondaryTableDialog_defaultSchema, (Object)this.defaultSchema));
        }
        if ((sc = this.getCurrentDbSchemaContainer()) != null) {
            for (String identifier : sc.getSortedSchemaIdentifiers()) {
                this.schemaCombo.add(identifier);
            }
        }
    }

    protected void initializeTableCombo() {
        String specifiedName;
        this.populateTableCombo();
        if (this.isEditDialog() && (specifiedName = this.secondaryTable.getSpecifiedName()) != null) {
            this.tableCombo.setText(specifiedName);
        }
    }

    protected void populateTableCombo() {
        Schema dbSchema = this.getCurrentDbSchema();
        if (dbSchema != null) {
            for (String identifier : dbSchema.getSortedTableIdentifiers()) {
                this.tableCombo.add(identifier);
            }
        }
    }

    protected SelectionListener buildCatalogSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SecondaryTableDialog.this.selectedCatalogChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SecondaryTableDialog.this.selectedCatalogChanged();
            }

            public String toString() {
                return "catalog selection listener";
            }
        };
    }

    protected void selectedCatalogChanged() {
        this.refreshSchemaCombo();
        this.refreshTableCombo();
    }

    protected void refreshSchemaCombo() {
        String schema = this.schemaCombo.getText();
        this.schemaCombo.removeAll();
        this.populateSchemaCombo();
        this.schemaCombo.setText(schema);
    }

    protected SelectionListener buildSchemaSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SecondaryTableDialog.this.selectedSchemaChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SecondaryTableDialog.this.selectedSchemaChanged();
            }

            public String toString() {
                return "schema selection listener";
            }
        };
    }

    protected void selectedSchemaChanged() {
        this.refreshTableCombo();
    }

    protected void refreshTableCombo() {
        String table = this.tableCombo.getText();
        this.tableCombo.removeAll();
        this.populateTableCombo();
        this.tableCombo.setText(table);
    }

    protected ModifyListener buildTableModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SecondaryTableDialog.this.tableChanged();
            }

            public String toString() {
                return "table modify listener";
            }
        };
    }

    protected void tableChanged() {
        this.refreshButtons();
    }

    protected boolean isAddDialog() {
        return this.secondaryTable == null;
    }

    protected boolean isEditDialog() {
        return !this.isAddDialog();
    }

    protected Database getDatabase() {
        return this.jpaProject.getDataSource().getDatabase();
    }

    protected SchemaContainer getCurrentDbSchemaContainer() {
        Database database = this.getDatabase();
        if (database == null) {
            return null;
        }
        if (!database.supportsCatalogs()) {
            return database;
        }
        String catalog = this.getCurrentCatalog();
        return catalog == null ? null : database.getCatalogForIdentifier(catalog);
    }

    protected String getCurrentCatalog() {
        if (this.defaultCatalog != null && this.catalogCombo.getSelectionIndex() == 0) {
            return this.defaultCatalog;
        }
        return SecondaryTableDialog.convertText(this.catalogCombo);
    }

    protected Schema getCurrentDbSchema() {
        String schema = this.getCurrentSchema();
        if (schema == null) {
            return null;
        }
        SchemaContainer sc = this.getCurrentDbSchemaContainer();
        return sc == null ? null : sc.getSchemaForIdentifier(schema);
    }

    protected String getCurrentSchema() {
        if (this.defaultSchema != null && this.schemaCombo.getSelectionIndex() == 0) {
            return this.defaultSchema;
        }
        return SecondaryTableDialog.convertText(this.schemaCombo);
    }

    protected void refreshButtons() {
        this.getButton(0).setEnabled(this.validateEntryValues());
    }

    protected boolean validateEntryValues() {
        return !StringTools.stringIsEmpty((String)this.tableCombo.getText());
    }

    public boolean close() {
        this.selectedTable = this.tableCombo.getText();
        this.selectedCatalog = SecondaryTableDialog.convertText(this.catalogCombo, this.defaultCatalog);
        this.selectedSchema = SecondaryTableDialog.convertText(this.schemaCombo, this.defaultSchema);
        return super.close();
    }

    protected static String convertText(Combo combo, String defaultText) {
        if (defaultText != null && combo.getSelectionIndex() == 0) {
            return null;
        }
        return SecondaryTableDialog.convertText(combo);
    }

    protected static String convertText(Combo combo) {
        String text = combo.getText();
        return text.length() == 0 ? null : text;
    }

    public String getSelectedTable() {
        return this.selectedTable;
    }

    public String getSelectedCatalog() {
        return this.selectedCatalog;
    }

    public String getSelectedSchema() {
        return this.selectedSchema;
    }
}

